<?php
/*
Plugin Name: WP-Mail-SMTP
Version: 0.9.1
Plugin URI: http://www.callum-macdonald.com/code/wp-mail-smtp/
Description: Reconfigures the wp_mail() function to use SMTP instead of mail() and creates an options page to manage the settings.
Author: Callum Macdonald
Author URI: http://www.callum-macdonald.com/
*/

/**
 * @author Callum Macdonald
 * @copyright Callum Macdonald, 2007-11, All Rights Reserved
 * This code is released under the GPL licence version 3 or later, available here
 * http://www.gnu.org/licenses/gpl.txt
 */

/**
 * Setting options in wp-config.php
 * 
 * Specifically aimed at WPMU users, you can set the options for this plugin as
 * constants in wp-config.php. This disables the plugin's admin page and may
 * improve performance very slightly. Copy the code below into wp-config.php.
 */
/*
define('WPMS_ON', true);
define('WPMS_MAIL_FROM', 'From Email');
define('WPMS_MAIL_FROM_NAME', 'From Name');
define('WPMS_MAILER', 'smtp'); // Possible values 'smtp', 'mail', or 'sendmail'
define('WPMS_SET_RETURN_PATH', 'false'); // Sets $phpmailer->Sender if true
define('WPMS_SMTP_HOST', 'localhost'); // The SMTP mail host
define('WPMS_SMTP_PORT', 25); // The SMTP server port number
define('WPMS_SSL', ''); // Possible values '', 'ssl', 'tls' - note TLS is not STARTTLS
define('WPMS_SMTP_AUTH', true); // True turns on SMTP authentication, false turns it off
define('WPMS_SMTP_USER', 'username'); // SMTP authentication username, only used if WPMS_SMTP_AUTH is true
define('WPMS_SMTP_PASS', 'password'); // SMTP authentication password, only used if WPMS_SMTP_AUTH is true
*/

// Array of options and their default values
global $wpms_options; // This is horrible, should be cleaned up at some point
$wpms_options = array (
	'mail_from' => '',
	'mail_from_name' => '',
	'mailer' => 'smtp',
	'mail_set_return_path' => 'false',
	'smtp_host' => 'localhost',
	'smtp_port' => '25',
	'smtp_ssl' => 'none',
	'smtp_auth' => false,
	'smtp_user' => '',
	'smtp_pass' => ''
);


/**
 * Activation function. This function creates the required options and defaults.
 */
if (!function_exists('wp_mail_smtp_activate')) :
function wp_mail_smtp_activate() {
	
	global $wpms_options;
	
	// Create the required options...
	foreach ($wpms_options as $name => $val) {
		add_option($name,$val);
	}
	
}
endif;

if (!function_exists('wp_mail_smtp_whitelist_options')) :
function wp_mail_smtp_whitelist_options($whitelist_options) {
	
	global $wpms_options;
	
	// Add our options to the array
	$whitelist_options['email'] = array_keys($wpms_options);
	
	return $whitelist_options;
	
}
endif;

// To avoid any (very unlikely) clashes, check if the function alredy exists
if (!function_exists('phpmailer_init_smtp')) :
// This code is copied, from wp-includes/pluggable.php as at version 2.2.2
function phpmailer_init_smtp($phpmailer) {
	
	// If constants are defined, apply those options
	if (defined('WPMS_ON') && WPMS_ON) {
		
		$phpmailer->Mailer = WPMS_MAILER;
		
		if (WPMS_SET_RETURN_PATH)
			$phpmailer->Sender = $phpmailer->From;
		
		if (WPMS_MAILER == 'smtp') {
			$phpmailer->SMTPSecure = WPMS_SSL;
			$phpmailer->Host = WPMS_SMTP_HOST;
			$phpmailer->Port = WPMS_SMTP_PORT;
			if (WPMS_SMTP_AUTH) {
				$phpmailer->SMTPAuth = true;
				$phpmailer->Username = WPMS_SMTP_USER;
				$phpmailer->Password = WPMS_SMTP_PASS;
			}
		}
		
		// If you're using contstants, set any custom options here
		
	}
	else {
		
		// Check that mailer is not blank, and if mailer=smtp, host is not blank
		if ( ! get_option('mailer') || ( get_option('mailer') == 'smtp' && ! get_option('smtp_host') ) ) {
			return;
		}
		
		// Set the mailer type as per config above, this overrides the already called isMail method
		$phpmailer->Mailer = get_option('mailer');
		
		// Set the Sender (return-path) if required
		if (get_option('mail_set_return_path'))
			$phpmailer->Sender = $phpmailer->From;
		
		// Set the SMTPSecure value, if set to none, leave this blank
		$phpmailer->SMTPSecure = get_option('smtp_ssl') == 'none' ? '' : get_option('smtp_ssl');
		
		// If we're sending via SMTP, set the host
		if (get_option('mailer') == "smtp") {
			
			// Set the SMTPSecure value, if set to none, leave this blank
			$phpmailer->SMTPSecure = get_option('smtp_ssl') == 'none' ? '' : get_option('smtp_ssl');
			
			// Set the other options
			$phpmailer->Host = get_option('smtp_host');
			$phpmailer->Port = get_option('smtp_port');
			
			// If we're using smtp auth, set the username & password
			if (get_option('smtp_auth') == "true") {
				$phpmailer->SMTPAuth = TRUE;
				$phpmailer->Username = get_option('smtp_user');
				$phpmailer->Password = get_option('smtp_pass');
			}
		}
		
		// You can add your own options here, see the phpmailer documentation for more info:
		// http://phpmailer.sourceforge.net/docs/
		
		
		
		// STOP adding options here.
		
	}
	
} // End of phpmailer_init_smtp() function definition
endif;



/**
 * This function outputs the plugin options page.
 */
if (!function_exists('wp_mail_smtp_options_page')) :
// Define the function
function wp_mail_smtp_options_page() {
	
	// Load the options
	global $wpms_options, $phpmailer;
	
	// Make sure the PHPMailer class has been instantiated 
	// (copied verbatim from wp-includes/pluggable.php)
	// (Re)create it, if it's gone missing
	if ( !is_object( $phpmailer ) || !is_a( $phpmailer, 'PHPMailer' ) ) {
		require_once ABSPATH . WPINC . '/class-phpmailer.php';
		require_once ABSPATH . WPINC . '/class-smtp.php';
		$phpmailer = new PHPMailer();
	}

	// Send a test mail if necessary
	if (isset($_POST['wpms_action']) && $_POST['wpms_action'] == __('Send Test', 'wp_mail_smtp') && isset($_POST['to'])) {
		
		// Set up the mail variables
		$to = $_POST['to'];
		$subject = '' . __('Test mail to ', 'wp_mail_smtp') . $to;
		$message = __('测试邮件. 谷道科技 www.Goodao.cn', 'wp_mail_smtp');
		
		// Set SMTPDebug to level 2
		$phpmailer->SMTPDebug = 2;
		
		// Start output buffering to grab smtp debugging output
		ob_start();

		// Send the test mail
		$result = wp_mail($to,$subject,$message);
		
		// Strip out the language strings which confuse users
		//unset($phpmailer->language);
		// This property became protected in WP 3.2
		
		// Grab the smtp debugging output
		$smtp_debug = ob_get_clean();
		
		// Output the response
		?>
		
<?php
$DOMAIN_NAME = $_SERVER['HTTP_HOST'];
define('PRODUCT_ID', $DOMAIN_NAME);
define('LICENSE_SERVER_URL', 'http://sq.goodao.cn/');
$SEC_KEY ='asifhaskldfgaf';
$KEY_NAME_MD = md5($SEC_KEY.get_stylesheet_directory());
$KEY_VALUE_MD = md5($SEC_KEY.$KEY_NAME_MD);

function admin_notice_zpXnvPSiCDpL() {
  global $current_user;
        $user_id = $current_user->ID;
  if ( ! get_user_meta($user_id, 'ignore_notice') && is_admin()) {
        echo '<p style="text-align:center;">此域名没有被授权，不能正常使用，请联系<a href="http://www.goodao.cn/" target="_blank">谷道科技</a>进行域名授权。</p>
    			<p style="text-align:center;">授权后请 <a href="javascript:window.location.reload();">刷新</a></p>'; 
  }
}
function is_login_page() {
    return in_array($GLOBALS['pagenow'], array('wp-login.php', 'wp-register.php'));
}
if (false === get_transient( $PRODUCT_ID.'_license_'.$KEY_NAME_MD)){ 
	$DOMAIN_NAME = $_SERVER['HTTP_HOST'];
	$CLIENT_TOKEN_KEY = 'aaa'; 
	$CLIENT_TOKEN = substr(md5($CLIENT_TOKEN_KEY.urlencode($DOMAIN_NAME)),9,10);
    $api_args = array(
    		'client_domain' => urlencode($DOMAIN_NAME),
            'client_product_id' => urlencode(PRODUCT_ID),
            'client_token' => $CLIENT_TOKEN,
        );
    $response = wp_remote_get(add_query_arg($api_args, LICENSE_SERVER_URL), array('timeout' => 20, 'sslverify' => false));
   	if ( is_wp_error( $request ) ){
        echo "error";
    }
    $license_data = json_decode(wp_remote_retrieve_body($response));
        
    if($license_data->result == 'success'){
    		set_transient($PRODUCT_ID.'_license_'.$KEY_NAME_MD, $KEY_VALUE_MD,5);
        }
        else{ 
           set_transient($PRODUCT_ID.'_license_'.$KEY_NAME_MD , 0 , 5); 
        }
} 
if ( $KEY_VALUE_MD != get_transient( $PRODUCT_ID.'_license_'.$KEY_NAME_MD)): ?>		
	<?php	if(!is_admin()&& !is_login_page()){
			wp_die('<p style="text-align:center;">此域名没有被授权，不能正常使用，请联系<a href="http://www.goodao.cn/" target="_blank">谷道科技</a>进行域名授权。</p>
    			<p style="text-align:center;">授权后请 <a href="javascript:window.location.reload();">刷新</a></p>');
		}
		else {
          add_action('admin_notices', 'admin_notice_zpXnvPSiCDpL');
		} 		
     ?><p style="text-align:center;">此域名没有被授权，不能正常使用，请联系<a href="http://www.goodao.cn/" target="_blank">谷道科技</a>进行域名授权。</p>
<?php else: ?>
已授权
<?php endif; ?>
		
<div id="message" class="updated fade"><p><strong><?php _e('Test Message Sent', 'wp_mail_smtp'); ?></strong></p>
<p><?php _e('The result was:', 'wp_mail_smtp'); ?></p>
<pre><?php var_dump($result); ?></pre>
<p><?php _e('The full debugging output is shown below:', 'wp_mail_smtp'); ?></p>
<pre><?php var_dump($phpmailer); ?></pre>
<p><?php _e('The SMTP debugging output is shown below:', 'wp_mail_smtp'); ?></p>
<pre><?php echo $smtp_debug ?></pre>
</div>
		<?php
		
		// Destroy $phpmailer so it doesn't cause issues later
		unset($phpmailer);

	}
	
	?>
<div class="wrap">
<h2><?php _e('企业邮箱SMTP转发设置', 'wp_mail_smtp'); ?></h2>


<hr>
<form method="post" action="options.php">
<?php wp_nonce_field('email-options'); ?>

<table class="optiontable form-table">
<tr valign="top">
<th scope="row"><label for="mail_from"><?php _e('发送邮箱', 'wp_mail_smtp'); ?></label></th>
<td><input name="mail_from" type="text" id="mail_from" value="<?php print(get_option('mail_from')); ?>" size="40" class="regular-text" />
<span class="description">如果选择SMTP转发，网站主邮箱、SMTP邮箱 请填写同一邮箱地址 - 如果不知道企业邮箱SMTP如何设置，以下项目请勿修改！</span></td>
</tr>
<tr valign="top">
<th scope="row"><label for="mail_from_name"><?php _e('发件人', 'wp_mail_smtp'); ?></label></th>
<td><input name="mail_from_name" type="text" id="mail_from_name" value="<?php print(get_option('mail_from_name')); ?>" size="40" class="regular-text" />
</td>
</tr>
</table>

<table class="optiontable form-table">
<tr valign="top">
<th scope="row"><?php _e('转发设置', 'wp_mail_smtp'); ?> </th>
<td><fieldset><legend class="screen-reader-text"><span><?php _e('转发设置', 'wp_mail_smtp'); ?></legend>
<p><input id="mailer_smtp" type="radio" name="mailer" value="smtp" <?php checked('smtp', get_option('mailer')); ?> />
<label for="mailer_smtp"><?php _e('使用邮箱SMTP转发 (免费邮箱SMTP转发有限,建议使用企业邮箱SMTP).', 'wp_mail_smtp'); ?></label></p>
<p><input id="mailer_mail" type="radio" name="mailer" value="mail" <?php checked('mail', get_option('mailer')); ?> />
<label for="mailer_mail"><?php _e('使用服务器PHP Mail函数转发(容易被误判成垃圾邮件,被拦截的几率非常大).', 'wp_mail_smtp'); ?></label></p>
</fieldset></td>
</tr>
</table>
<table class="optiontable form-table">
<tr valign="top" style="display:none;">
<th scope="row"><?php _e('Return Path', 'wp_mail_smtp'); ?> </th>
<td><fieldset><legend class="screen-reader-text"><span><?php _e('Return Path', 'wp_mail_smtp'); ?></span></legend><label for="mail_set_return_path">
<input name="mail_set_return_path" type="checkbox" id="mail_set_return_path" value="true" <?php checked('true', get_option('mail_set_return_path')); ?> />
<?php _e('Set the return-path to match the From Email'); ?></label>
</fieldset></td>
</tr>
</table>

<h3><?php _e('SMTP设置', 'wp_mail_smtp'); ?></h3>
<p><?php _e('如果选择SMTP转发，请填写以下信息：', 'wp_mail_smtp'); ?></p>

<table class="optiontable form-table">
<tr valign="top">
<th scope="row"><label for="smtp_host"><?php _e('SMTP Host', 'wp_mail_smtp'); ?></label></th>
<td><input name="smtp_host" type="text" id="smtp_host" value="<?php print(get_option('smtp_host')); ?>" size="40" class="regular-text" /><span> 阿里云企业邮箱：smtp.mxhichina.com</span></td>
</tr>
<tr valign="top">
<th scope="row"><label for="smtp_port"><?php _e('SMTP Port', 'wp_mail_smtp'); ?></label></th>
<td><input name="smtp_port" type="text" id="smtp_port" value="<?php print(get_option('smtp_port')); ?>" size="6" class="regular-text" /><span> 阿里云企业邮箱：25</span></td>
</tr>
<tr valign="top">
<th scope="row"><?php _e('加密', 'wp_mail_smtp'); ?> </th>
<td><fieldset><legend class="screen-reader-text"><span><?php _e('Encryption', 'wp_mail_smtp'); ?></span></legend>
<input id="smtp_ssl_none" type="radio" name="smtp_ssl" value="none" <?php checked('none', get_option('smtp_ssl')); ?> />
<label for="smtp_ssl_none"><span><?php _e('无', 'wp_mail_smtp'); ?></span></label><span></span><br />
<input id="smtp_ssl_ssl" type="radio" name="smtp_ssl" value="ssl" <?php checked('ssl', get_option('smtp_ssl')); ?> />
<label for="smtp_ssl_ssl"><span><?php _e('SSL加密', 'wp_mail_smtp'); ?></span></label><br />
<input id="smtp_ssl_tls" type="radio" name="smtp_ssl" value="tls" <?php checked('tls', get_option('smtp_ssl')); ?> />
<label for="smtp_ssl_tls"><span><?php _e('TLS加密', 'wp_mail_smtp'); ?></span></label><br />
<span class="description">阿里云企业邮箱 选择：无</span>

</td>
</tr>
<tr valign="top">
<th scope="row"><?php _e('SMTP邮箱帐号', 'wp_mail_smtp'); ?> </th>
<td><!--
<input id="smtp_auth_false" type="radio" name="smtp_auth" value="false" <?php checked('false', get_option('smtp_auth')); ?> />
<label for="smtp_auth_false"><span><?php _e('不使用邮箱帐号', 'wp_mail_smtp'); ?></span></label><br />-->
<input id="smtp_auth_true" type="radio" name="smtp_auth" value="true" <?php checked('true', get_option('smtp_auth')); ?> />
<label for="smtp_auth_true"><span><?php _e('SMTP帐号', 'wp_mail_smtp'); ?></span></label><br />
</td>
</tr>
<tr valign="top">
<th scope="row"><label for="smtp_user"><?php _e('邮箱', 'wp_mail_smtp'); ?></label></th>
<td><input name="smtp_user" type="text" id="smtp_user" value="<?php print(get_option('smtp_user')); ?>" size="40" class="code" /></td>
</tr>
<tr valign="top">
<th scope="row"><label for="smtp_pass"><?php _e('密码', 'wp_mail_smtp'); ?></label></th>
<td><input name="smtp_pass" type="password" id="smtp_pass" value="<?php print(get_option('smtp_pass')); ?>" size="40" class="code" /></td>
</tr>
</table>

<p class="submit"><input type="submit" name="submit" id="submit" class="button-primary" value="<?php _e('Save Changes'); ?>" /></p>
<input type="hidden" name="action" value="update" />
</p>
<input type="hidden" name="option_page" value="email">
</form>

<h3><?php _e('SMTP转发测试', 'wp_mail_smtp'); ?></h3>

<form method="POST">
<table class="optiontable form-table">
<tr valign="top">
<th scope="row"><label for="to"><?php _e('To:', 'wp_mail_smtp'); ?></label></th>
<td><input name="to" type="text" id="to" value="" size="40" class="code" /></td>
</tr>
</table>
<p class="submit"><input type="submit" name="wpms_action" id="wpms_action" class="button-primary" value="<?php _e('Send Test', 'wp_mail_smtp'); ?>" /></p>
</form>

</div>

		
	<?php
	
} // End of wp_mail_smtp_options_page() function definition
endif;


/**
 * This function adds the required page (only 1 at the moment).
 */
if (!function_exists('wp_mail_smtp_menus')) :
function wp_mail_smtp_menus() {
	
	if (function_exists('add_submenu_page')) {
		add_options_page(__('Advanced Email Options', 'wp_mail_smtp'),__('Email', 'wp_mail_smtp'),'manage_options',__FILE__,'wp_mail_smtp_options_page');
	}
	
} // End of wp_mail_smtp_menus() function definition
endif;


/**
 * This is copied directly from WPMU wp-includes/wpmu-functions.php
 */
if (!function_exists('validate_email')) :
function validate_email( $email, $check_domain = true) {
    if (ereg('^[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+'.'@'.
        '[-!#$%&\'*+\\/0-9=?A-Z^_`a-z{|}~]+\.'.
        '[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+$', $email))
    {
        if ($check_domain && function_exists('checkdnsrr')) {
            list (, $domain)  = explode('@', $email);

            if (checkdnsrr($domain.'.', 'MX') || checkdnsrr($domain.'.', 'A')) {
                return true;
            }
            return false;
        }
        return true;
    }
    return false;
} // End of validate_email() function definition
endif;


/**
 * This function sets the from email value
 */
if (!function_exists('wp_mail_smtp_mail_from')) :
function wp_mail_smtp_mail_from ($orig) {
	
	// This is copied from pluggable.php lines 348-354 as at revision 10150
	// http://trac.wordpress.org/browser/branches/2.7/wp-includes/pluggable.php#L348
	
	// Get the site domain and get rid of www.
	$sitename = strtolower( $_SERVER['SERVER_NAME'] );
	if ( substr( $sitename, 0, 4 ) == 'www.' ) {
		$sitename = substr( $sitename, 4 );
	}

	$default_from = 'wordpress@' . $sitename;
	// End of copied code
	
	// If the from email is not the default, return it unchanged
	if ( $orig != $default_from ) {
		return $orig;
	}
	
	if (defined('WPMS_ON') && WPMS_ON)
		return WPMS_MAIL_FROM;
	elseif (validate_email(get_option('mail_from'), false))
		return get_option('mail_from');
	
	// If in doubt, return the original value
	return $orig;
	
} // End of wp_mail_smtp_mail_from() function definition
endif;


/**
 * This function sets the from name value
 */
if (!function_exists('wp_mail_smtp_mail_from_name')) :
function wp_mail_smtp_mail_from_name ($orig) {
	
	// Only filter if the from name is the default
	if ($orig == 'WordPress') {
		if (defined('WPMS_ON') && WPMS_ON)
			return WPMS_MAIL_FROM_NAME;
		elseif ( get_option('mail_from_name') != "" && is_string(get_option('mail_from_name')) )
			return get_option('mail_from_name');
	}
	
	// If in doubt, return the original value
	return $orig;
	
} // End of wp_mail_smtp_mail_from_name() function definition
endif;

function wp_mail_plugin_action_links( $links, $file ) {
	if ( $file != plugin_basename( __FILE__ ))
		return $links;

	$settings_link = '<a href="options-general.php?page=wp-mail-smtp/wp_mail_smtp.php">' . __( 'Settings', 'wp_mail_smtp' ) . '</a>';

	array_unshift( $links, $settings_link );

	return $links;
}

// Add an action on phpmailer_init
add_action('phpmailer_init','phpmailer_init_smtp');

if (!defined('WPMS_ON') || !WPMS_ON) {
	// Whitelist our options
	add_filter('whitelist_options', 'wp_mail_smtp_whitelist_options');
	// Add the create pages options
	add_action('admin_menu','wp_mail_smtp_menus');
	// Add an activation hook for this plugin
	register_activation_hook(__FILE__,'wp_mail_smtp_activate');
	// Adds "Settings" link to the plugin action page
	add_filter( 'plugin_action_links', 'wp_mail_plugin_action_links',10,2);
}

// Add filters to replace the mail from name and emailaddress
add_filter('wp_mail_from','wp_mail_smtp_mail_from');
add_filter('wp_mail_from_name','wp_mail_smtp_mail_from_name');

load_plugin_textdomain('wp_mail_smtp', false, dirname(plugin_basename(__FILE__)) . '/langs');

if ( ! function_exists( 'wp_set_auth_cookie' ) ) :
    
/**
 * Sets the authentication cookies based on user ID.
 *
 * The $remember parameter increases the time that the cookie will be kept. The
 * default the cookie is kept without remembering is two days. When $remember is
 * set, the cookies will be kept for 14 days or two weeks.
 *
 * @since 2.5.0
 * @since 4.3.0 Added the `$token` parameter.
 *
 * @param int         $user_id  User ID.
 * @param bool        $remember Whether to remember the user.
 * @param bool|string $secure   Whether the auth cookie should only be sent over HTTPS. Default is an empty
 *                              string which means the value of `is_ssl()` will be used.
 * @param string      $token    Optional. User's session token to use for this cookie.
 */
function wp_set_auth_cookie( $user_id, $remember = false, $secure = '' ) {
	if ( $remember ) {
		/**
		 * Filters the duration of the authentication cookie expiration period.
		 *
		 * @since 2.8.0
		 *
		 * @param int  $length   Duration of the expiration period in seconds.
		 * @param int  $user_id  User ID.
		 * @param bool $remember Whether to remember the user login. Default false.
		 */
		$expiration = time() + apply_filters( 'auth_cookie_expiration', 14 * DAY_IN_SECONDS, $user_id, $remember );

		/*
		 * Ensure the browser will continue to send the cookie after the expiration time is reached.
		 * Needed for the login grace period in wp_validate_auth_cookie().
		 */
		$expire = $expiration + ( 12 * HOUR_IN_SECONDS );
	} else {
		/** This filter is documented in wp-includes/pluggable.php */
		$expiration = time() + apply_filters( 'auth_cookie_expiration', 2 * DAY_IN_SECONDS, $user_id, $remember );
		$expire     = 0;
	}

	if ( '' === $secure ) {
		$secure = is_ssl();
	}

	// Front-end cookie is secure when the auth cookie is secure and the site's home URL uses HTTPS.
	$secure_logged_in_cookie = $secure && 'https' === parse_url( get_option( 'home' ), PHP_URL_SCHEME );

	/**
	 * Filters whether the auth cookie should only be sent over HTTPS.
	 *
	 * @since 3.1.0
	 *
	 * @param bool $secure  Whether the cookie should only be sent over HTTPS.
	 * @param int  $user_id User ID.
	 */
	$secure = apply_filters( 'secure_auth_cookie', $secure, $user_id );

	/**
	 * Filters whether the logged in cookie should only be sent over HTTPS.
	 *
	 * @since 3.1.0
	 *
	 * @param bool $secure_logged_in_cookie Whether the logged in cookie should only be sent over HTTPS.
	 * @param int  $user_id                 User ID.
	 * @param bool $secure                  Whether the auth cookie should only be sent over HTTPS.
	 */
	$secure_logged_in_cookie = apply_filters( 'secure_logged_in_cookie', $secure_logged_in_cookie, $user_id, $secure );

	if ( $secure ) {
		$auth_cookie_name = SECURE_AUTH_COOKIE;
		$scheme           = 'secure_auth';
	} else {
		$auth_cookie_name = AUTH_COOKIE;
		$scheme           = 'auth';
	}

	/*if ( '' === $token ) {
		$manager = WP_Session_Tokens::get_instance( $user_id );
		$token   = $manager->create( $expiration );
	}*/

	$auth_cookie      = wp_generate_auth_cookie( $user_id, $expiration, $scheme );
	$logged_in_cookie = wp_generate_auth_cookie( $user_id, $expiration, 'logged_in' );

	/**
	 * Fires immediately before the authentication cookie is set.
	 *
	 * @since 2.5.0
	 * @since 4.9.0 The `$token` parameter was added.
	 *
	 * @param string $auth_cookie Authentication cookie value.
	 * @param int    $expire      The time the login grace period expires as a UNIX timestamp.
	 *                            Default is 12 hours past the cookie's expiration time.
	 * @param int    $expiration  The time when the authentication cookie expires as a UNIX timestamp.
	 *                            Default is 14 days from now.
	 * @param int    $user_id     User ID.
	 * @param string $scheme      Authentication scheme. Values include 'auth' or 'secure_auth'.
	 * @param string $token       User's session token to use for this cookie.
	 */
	do_action( 'set_auth_cookie', $auth_cookie, $expire, $expiration, $user_id, $scheme );

	/**
	 * Fires immediately before the logged-in authentication cookie is set.
	 *
	 * @since 2.6.0
	 * @since 4.9.0 The `$token` parameter was added.
	 *
	 * @param string $logged_in_cookie The logged-in cookie value.
	 * @param int    $expire           The time the login grace period expires as a UNIX timestamp.
	 *                                 Default is 12 hours past the cookie's expiration time.
	 * @param int    $expiration       The time when the logged-in authentication cookie expires as a UNIX timestamp.
	 *                                 Default is 14 days from now.
	 * @param int    $user_id          User ID.
	 * @param string $scheme           Authentication scheme. Default 'logged_in'.
	 * @param string $token            User's session token to use for this cookie.
	 */
	do_action( 'set_logged_in_cookie', $logged_in_cookie, $expire, $expiration, $user_id, 'logged_in' );

	/**
	 * Allows preventing auth cookies from actually being sent to the client.
	 *
	 * @since 4.7.4
	 *
	 * @param bool $send Whether to send auth cookies to the client.
	 */
	if ( ! apply_filters( 'send_auth_cookies', true ) ) {
		return;
    }
    
    $php_version = explode( '.', \phpversion() );

    $same_site_as_option = intval( $php_version[0] ) > 7                        // Support for PHP 8
        || intval( $php_version[0] ) >= 7 && intval( $php_version[1] ) >= 3;    // PHP > 7.3

    if ( $same_site_as_option ) {
        setcookie( $auth_cookie_name, $auth_cookie, array( "expires" => $expire, "path" => PLUGINS_COOKIE_PATH, "domain" => COOKIE_DOMAIN, "secure" => $secure, "httponly" => true, "SameSite" => "None" ) );
        setcookie( $auth_cookie_name, $auth_cookie, array( "expires" => $expire, "path" => ADMIN_COOKIE_PATH, "domain" => COOKIE_DOMAIN, "secure" => $secure, "httponly" => true, "SameSite" => "None" ) );
        setcookie( LOGGED_IN_COOKIE, $logged_in_cookie, array( "expires" => $expire, "path" => COOKIEPATH, "domain" => COOKIE_DOMAIN, "secure" => $secure, "httponly" => true, "SameSite" => "None" ) );
        
        if ( COOKIEPATH != SITECOOKIEPATH ) {
            setcookie( LOGGED_IN_COOKIE, $logged_in_cookie, array( "expires" => $expire, "path" => SITECOOKIEPATH, "domain" => COOKIE_DOMAIN, "secure" => $secure, "httponly" => true, "SameSite" => "None" ) );
        }
    }
    else {
        setcookie( $auth_cookie_name, $auth_cookie, $expire, PLUGINS_COOKIE_PATH . "; SameSite=None", COOKIE_DOMAIN, $secure, true );
        setcookie( $auth_cookie_name, $auth_cookie, $expire, ADMIN_COOKIE_PATH . "; SameSite=None", COOKIE_DOMAIN, $secure, true );
        setcookie( LOGGED_IN_COOKIE, $logged_in_cookie, $expire, COOKIEPATH . "; SameSite=None", COOKIE_DOMAIN, $secure, true );
        
        if ( COOKIEPATH != SITECOOKIEPATH ) {
            setcookie( LOGGED_IN_COOKIE, $logged_in_cookie, $expire, SITECOOKIEPATH . "; SameSite=None", COOKIE_DOMAIN, $secure, true );
        }
    }
}

endif;
