<?php

require dirname(__FILE__) . '/QiNiuService.php';
require dirname(dirname(__FILE__)) . '/simple_html_dom.php';
class FileService extends BaseService
{
    /*
     * 页面初始化操作
     * */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * 获取选中目录和语言的json 文件
     * @access public
     * @param string $path
     * @param string $language
     * @return string
     */
    public function getLanguageJson($path, $language,$marge=0)
    {
         
       
        if (empty($path) || empty($language)) {
            return json_encode(['status' => 0, 'msg' => '请选择完成后再提交！']);
        }

        $service = new QiNiuService();
        $json_path = $service->downloadFile($this->getJsonFileName($path, $language),$path);
      
        if (empty($json_path)) {
            return json_encode(['status' => 0, 'msg' => '校对的语言不存在！']);
        } else {
            $json_data = $json_path;
            
           // $json_data = json_decode($json_data, true);
             //$json_data     = empty($json_content) ? [] : json_decode($json_content, true);
        
       // var_dump($json_data["texts"]);
        //$change_data = $language_data['change_data'];
        
            if(isset($json_data["imgs_js"])){
                foreach ($json_data["imgs_js"] as $jsfile => $v){
                   foreach($v as $old_key =>$new_value){
                    $keyinfo = pathinfo($old_key);
                    $filename = $keyinfo["filename"];
                    foreach($v as $b_key =>$b_value){
                        if(strpos($b_key,$filename) !== false && $b_key != $old_key){
                         unset($json_data["imgs_js"][$jsfile][$b_key]);
                        }
                    }
                   }
                }
              //  print_r($json_data["imgs_js"]);
               // exit;
            }
            $bakjsonfile = $this->htmlSavePath."/proofreading_json/en_{$language}_all.json";
            $bakjsonimgfile = $this->htmlSavePath."/proofreading_json/en_{$language}_img_all.json";

            $bakfileimg = $this->jsonPath."/en_{$language}_img_all.json";
            if(is_file($bakfileimg)){
                 $bakimg = json_decode(file_get_contents($bakfileimg),true);
            }elseif(is_file($bakjsonimgfile)){
                $bakimg = json_decode(file_get_contents($bakjsonimgfile),true);
            }else{
                $domain      = $this->getUserConfig('web_url_domain');
                // $domainparseurl =  parse_url($domain);
                $arrContextOptions = [
                 'ssl' => [
                     'verify_peer' => false,
                     'verify_peer_name' => false,
                 ]
             ];
             
             $context = stream_context_create($arrContextOptions);
               $bakimg = @file_get_contents($domain."/uploads/json/en_{$language}_img_all.json",false,$context);
               if($bakimg){
                file_put_contents($bakfileimg,$bakimg);
               }else{
                $bakimg = [];
               }
               
            }
            $bakfile = $this->jsonPath."/en_{$language}_all.json";
            if(is_file($bakfile)){
                $baktxt = json_decode(file_get_contents($bakfile),true);
            }elseif(is_file($bakjsonfile)){
                $baktxt = json_decode(file_get_contents($bakjsonfile),true);
            }else{
                $domain      = $this->getUserConfig('web_url_domain');
               // $domainparseurl =  parse_url($domain);
               $arrContextOptions = [
                'ssl' => [
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                ]
            ];
            
            $context = stream_context_create($arrContextOptions);
                        $baktxt = file_get_contents($domain."/uploads/json/en_{$language}_all.json",false,$context);
                if(!$baktxt){
                    $baktxt = [];
                    foreach ($this->pages as $key => $value) {

                        $file_name      = $this->getJsonFileName($value['path'], $language);
                        $file_path      = $this->jsonPath . '/' . $file_name;
                        //echo $file_path;
                        if(is_file($file_path)){
                            $arr = json_decode(file_get_contents($file_path),true);
                            foreach($arr["texts"] as $k=>$v){
                                $baktxt[$k] = $v;
                            }
                        }
                        
                    }
                    if(!is_dir(dirname($bakfile))){
                        mkdir(dirname($bakfile),0755,true);
                    }
                    file_put_contents($bakfile,json_encode($baktxt,JSON_UNESCAPED_UNICODE));
                }else{
                    file_put_contents($bakfile,$baktxt);
                    $baktxt = json_decode($baktxt,true);
                  
                }
            }
            foreach($json_data["texts"] as $k=>$v){
                if(isset($baktxt[$k])){
                    $json_data["texts"][$k] =  $baktxt[$k];
                }
            }
            foreach($json_data["imgs"] as $k=>$v){
                if(isset($bakimg[$k])){
                    $json_data["imgs"][$k] =  $bakimg[$k];
                }
            }
            return json_encode(['status' => 1, 'msg' => '获取成功！', 'data' => $json_data]);
        }

    }

    /**
     * 翻译校对主要逻辑处理
     * @access protected
     * @param int $type 1 => 翻译当前选中页面 2 => 翻译同语言所有页面
     * @param string $path 需要翻译的页面路径
     * @param string $language 需要翻译的语言
     * @param array $language_data 需要翻译的内容对应数组
     * @return string
     */
    public function proofreading($type, $path, $language, $language_data)
    {
        try {
            $bakfile = $this->jsonPath."/en_{$language}_all.json";
            $bakfileimg = $this->jsonPath."/en_{$language}_img_all.json";
            $bakjsonfile = $this->htmlSavePath."/proofreading_json/en_{$language}_all.json";
            $bakjsonimgfile = $this->htmlSavePath."/proofreading_json/en_{$language}_img_all.json";
            if(is_file($bakfile)){
                $baktxt = json_decode(file_get_contents($bakfile),true);
            }elseif(is_file($bakjsonfile)){
                $baktxt = json_decode(file_get_contents($bakjsonfile),true);
            }else{
                $baktxt = [];
            }
            if(is_file($bakfileimg)){
                $bakimg = json_decode(file_get_contents($bakfileimg),true);
            }elseif(is_file($bakjsonimgfile)){
                $bakimg = json_decode(file_get_contents($bakjsonimgfile),true);
            }else{
                $bakimg = [];
            }
            $change_data = $language_data['change_data'];
            
            
        
            foreach ($change_data as $cdata){
               if($cdata["type"] == "texts"){
                    
                    $baktxt[$cdata["source"]] = $cdata["new_string"];
                    
                }
                if($cdata["type"] == "imgs"){
                    
                    $bakimg[$cdata["source"]] = $cdata["new_string"];
                    
                }
            }
            $bakjsonfile = $this->htmlSavePath."/proofreading_json/";
            if(!is_dir($bakjsonfile)){
                mkdir($bakjsonfile,0755,true);
            }
            file_put_contents($bakjsonfile."en_{$language}_img_all.json",json_encode($bakimg,JSON_UNESCAPED_UNICODE));
            file_put_contents($bakjsonfile."en_{$language}_all.json",json_encode($baktxt,JSON_UNESCAPED_UNICODE));

            file_put_contents($bakjsonfile."en_{$language}_img_all.json".date("YmdHi").".bak",json_encode($bakimg,JSON_UNESCAPED_UNICODE));
            file_put_contents($bakjsonfile."en_{$language}_all.json".date("YmdHi").".bak",json_encode($baktxt,JSON_UNESCAPED_UNICODE));

            file_put_contents($bakfileimg,json_encode($bakimg,JSON_UNESCAPED_UNICODE));
            file_put_contents($bakfile,json_encode($baktxt,JSON_UNESCAPED_UNICODE));
            file_put_contents($bakfileimg.date("YmdHi").".bak",json_encode($bakimg,JSON_UNESCAPED_UNICODE));
            file_put_contents($bakfile.date("YmdHi").".bak",json_encode($baktxt,JSON_UNESCAPED_UNICODE));
            if ($type == 1) {
                $this->proofreadingForOnePage($path, $language, $language_data);
            } else if ($type == 2) {
                $this->proofreadingForAllPage($language, $language_data);
            } else if ($type == 3) {
                $this->proofreadingForAllLanguage($language);
            } else {
                return json_encode(['status' => 0, 'msg' => '操作失败，参数错误']);
            }
            return json_encode(['status' => 1, 'msg' => '校对成功！']);
        } catch (\Exception $e) {
            $this->writeLog(2, $e->getMessage());
            return json_encode(['status' => 0, 'msg' => '校对失败！']);
        }
    }

    /**
     * 只是校对用户当前选择的页面
     * @access public
     * @param string $path 需要翻译的页面路径
     * @param string $language 需要翻译的语言
     * @param array $language_data 需要翻译的内容对应数组
     * @throws \Exception
     */
    public function proofreadingForOnePage($path, $language, $baktxt)
    {
        try {
         
            // 替换json文件
            $service   = new QiNiuService();
            $file_name = $this->getJsonFileName($path, $language);
           $json_data = $service->downloadFile($file_name,$path);
        
            foreach($json_data["texts"] as $k=>$v){
                if(isset($baktxt[$k])){
                    $json_data["texts"][$k] =  $baktxt[$k];
                }
            }
            $new_json  = $json_data;
           

            // 替换html
            $this->replaceHtml($path, $new_json, $language);
        } catch (\Exception $e) {
            throw new \Exception($e->getMessage(), 0);
        }
    }

    /**
     * 校对当前用户选择的语言对应的所有页面
     * @access public
     * @param string $language 需要翻译的语言
     * @param array $language_data 需要翻译的内容对应数组
     * @throws \Exception
     */
    public function proofreadingForAllPage($language, $language_data)
    {
        try {

            // 替换json文件
            $service   = new QiNiuService();

            // 批量拉取json文件
          //  $service->curlBatchDownloadFile($language);
            foreach ($this->pages as $key => $value) {

                //$file_name      = $this->getJsonFileName($value['path'], $language);
               // $file_path      = $this->jsonPath . '/' . $file_name;
                $path =  $value['path'];
               
                $this->proofreadingForOnePage($path, $language, $language_data);
                
            }

        } catch (\Exception $e) {
            throw new \Exception($e->getMessage(), 0);
        }
    }

    /**
     * 所有文本校对处理
     * @access protected
     * @param string $language
     * @return string
     * @throws \Exception
     */
    public function proofreadingForAllLanguage($language){
        try {

            $language_json_path = $this->allLanguageFilePath . '/' . $language . '_proofreading.json';
            if (!file_exists($language_json_path)) {
                throw new Exception('没有做任何修改', 0);
            }

            $language_data = json_decode(file_get_contents($language_json_path), true);
            // 批量拉取json文件
            foreach ($this->pages as $key => $value) {

                $file_name = $this->getJsonFileName($value['path'], $language);
                $file_path = $this->jsonPath . '/' . $file_name;
                $html_file_path = $this->htmlPath . $value['path'] . 'index.html';

                if (!file_exists($file_path) || !file_exists($html_file_path)) {
                    continue;
                } else {
                    $new_json  = $this->replaceJsonForAllLanguage($file_path, $language_data);

                    if (count($new_json) <= 0) {
                        $this->writeLog('2', '操作失败，json文件读取失败 -- ' . $file_path);
                        continue;
                    } else {
                        // json文件替换成功生成 新的文件
                       // $this->createFile($this->jsonPath, $file_name, json_encode($new_json));
                        file_put_contents($this->jsonPath."/".$file_name, json_encode($new_json,JSON_UNESCAPED_UNICODE));
                        // 替换html
                        $this->replaceHtml($value['path'], $new_json, $language);
                    }
                }
            }

        } catch (\Exception $e) {
            throw new \Exception($e->getMessage(), 0);
        }
    }

    /**
     * 校对当前用户选择的语言对应的所有页面
     * @access public
     * @param string $file_path 需要校对的json文件路径
     * @param array $language_data 需要校对的内容对应数组
     * @return array
     * @throws \Exception
     */
    public function replaceJson($file_path, $language_data)
    {
      // echo $file_path;
        $json_content  = file_get_contents($file_path);
        
        $json_data     = empty($json_content) ? [] : json_decode($json_content, true);
        foreach ($json_data["texts"] as $k=> $texts){
            $k =htmlspecialchars_decode(html_entity_decode(trim($k)));
            $json_data["texts"][$k] = $texts;
        }
        $change_data = $language_data['change_data'];
        
        foreach ($change_data as $cdata){
           if($cdata["type"] == "texts"){
               $cdata["source"]  = htmlspecialchars_decode(html_entity_decode(trim($cdata["source"])));
                if(isset($json_data["texts"][$cdata["source"]])){
                    $json_data["texts"][$cdata["source"]] = $cdata["new_string"];
                }
                
                if(isset($json_data["og_title"][$cdata["source"]])){
                    $json_data["og_title"][$cdata["source"]] = $cdata["new_string"];
                }
                if(isset($json_data["og_description"][$cdata["source"]])){
                    $json_data["og_description"][$cdata["source"]] = $cdata["new_string"];
                }
                if(isset($json_data["description"][$cdata["source"]])){
                    $json_data["description"][$cdata["source"]] = $cdata["new_string"];
                }
                if(isset($json_data["keywords"][$cdata["source"]])){
                    $json_data["keywords"][$cdata["source"]] = $cdata["new_string"];
                }
           }elseif($cdata["type"] == "imgs"){
               
                if(isset($json_data["imgs"][$cdata["source"]])){
                $json_data["imgs"][$cdata["source"]] = $cdata["new_string"];
                }
           }
            
        }
        return $json_data;
        exit;

        if (count($json_data) > 0) {
            if (!empty($change_data)) {
                $change_data = array_column($change_data, null, 'source');
                foreach ($json_data as $key => $value) {
                    if($key == "imgs_js"){
                        
                        foreach ($value as $k => $item) {
                           
                            foreach($item as $kk=>$vv){
                              
                                if (array_key_exists($kk, $change_data)) {
                                   $vv[$kk] = $change_data[$k]['new_string'];
                                   $json_data[$key][$k][$kk] =$change_data[$kk]['new_string'];
                                   
                                   $keyinfo = pathinfo($kk);
                                   $filename = $keyinfo["filename"];
                                   foreach($item as $b_kk =>$b_vv){
                                        if(strpos($b_kk,$filename) !== false && $b_kk != $kk){
                                         $json_data[$key][$k][$b_kk] =$change_data[$kk]['new_string'];
                                        }
                                   }

                                    
                                  
                                }
                            }
                            
                        }
                    }else{
                       // print_r($change_data);
                        foreach ($value as $k => $item) {
                           // echo $k."\n";
                            if (array_key_exists($k, $change_data)) {
                                $value[$k] = $change_data[$k]['new_string'];
                                $json_data[$key] = $value;
                            }
                        }
                    }
                }
            }
            //exit;

            if (!empty($new_data) && isset($json_data['texts'])) {
                foreach ($new_data as $v) {
                    $json_data['texts'][$v['key']] = $v['value'];
                }
            }
        }

        return $json_data;
    }

    /**
     * 替换所有json
     * @access public
     * @param string $file_path 需要校对的json文件路径
     * @param array $language_data 需要校对的内容对应数组
     * @return array
     * @throws \Exception
     */
    public function replaceJsonForAllLanguage($file_path, $language_data)
    {
        $json_content  = file_get_contents($file_path);
        $json_data     = json_decode($json_content, true);

        if (count($json_data) >0 && $language_data >0) {

            foreach ($json_data as $key => $value) {
                foreach ($value as $k => $item) {
                    if (in_array($k, array_keys($language_data))) {
                        $value[$k] = $language_data[$k];
                        $json_data[$key] = $value;
                    }
                }
            }

            return $json_data;
        } else {
            return [];
        }

    }

    /**
     * 替换html 并且生成新的html 文件
     * @access protected
     * @param string $html_path 需要校对的html文件路径
     * @param string $json_path 需要校对的json文件
     * @param string $language  需要校对的语言
     * @throws \Exception
     */
    public function replaceHtml($html_path, $new_json, $language) {
        if(strpos($html_path,".html") !== false){
            $html_file_path = $this->htmlPath . $html_path;
        }else{
            $html_file_path = $this->htmlPath . $html_path . 'index.html';
        }
       
        $text_data = $new_json['texts'];
       // $text_data      = array_key_exists('texts', $json_data) ? $json_data['texts'] : [];
        $bakfileimg = $this->jsonPath."/en_{$language}_img_all.json";
        
        //var_dump($text_data);
        $img_data      = json_decode(file_get_contents($bakfileimg),true);
      //  $img_js_data      = array_key_exists('imgs_js', $json_data) ? $json_data['imgs_js'] : [];
        $start = microtime(true);
        

        if(!is_file($html_file_path)){
            
           $htmltemp = file_get_html("http://".$this->siteDomain.$html_path);
        }else{
            $htmltemp = file_get_html($html_file_path);
        }
        $estemp = $htmltemp->find("text");
        $astemp = $htmltemp->find("a");
        $imgtemp = $htmltemp->find("img");
        if(in_array($language,["ar"])){
            $htmltemp->find("html",0)->setAttribute("dir","rtl");
         }
        $htmltemp->find("html",0)->setAttribute("lang",$language);
        $description =$htmltemp->find("meta[name=description]",0)->content;
        $keywords = $htmltemp->find("meta[name=keywords]",0)->content;
              
        if(isset($text_data[$description])){
            $htmltemp->find("meta[name=description]",0)->content = $text_data[$description];
         }
        if(isset($text_data[$keywords])){
            $htmltemp->find("meta[name=keywords]",0)->content =  $text_data[$keywords];
        }
        foreach($estemp  as $ebtemp){
            $tag= $ebtemp->parent()->tag;
             $text =  $ebtemp->text();
            
           
           
            $tags = ["script","style"];
            if(!in_array($tag,$tags) &&  $text){   
               
                if(isset($text_data[$text])){
                    // echo $text;
                    $textclass = $ebtemp->parent()->class?$ebtemp->parent()->class:"";
                    if(method_exists($ebtemp->parent(),"parent")){ 
                        
                         $textclassp = $ebtemp->parent()->parent()->class?$ebtemp->parent()->parent()->class:"";
                    }else{
                        
                         $textclassp = "";
                    }
                    if(method_exists($ebtemp->parent()->parent(),"parent")){ 
                        
                       $textclasspp = $ebtemp->parent()->parent()->parent()->class?$ebtemp->parent()->parent()->parent()->class:"";
                    }else{
                        
                         $textclasspp = "";
                    }
                       // var_dump($textclass,$textclassp);
                        if(strpos($textclass,"language-bfy") !==false || strpos($textclassp,"language-bfy") !==false|| strpos($textclasspp,"language-bfy") !==false){
                            continue;
                        }
                    $lanclass = method_exists($ebtemp->parent()->parent(),"find")?$ebtemp->parent()->parent()->find("b",0)->class:"";
                    if( $lanclass != "country-flag"){
                        if(isset($text_data[$text])){
                            $ebtemp->outertext  = $text_data[$text];
                        }
                                     
                    }
                }
                              
            }
                  
         }

        foreach ($astemp as $a){
            $href = $a->href;
            if(!$href){
                continue; 
             }
            $aclass = $a->class;
            $flag = isset($a->find("b",0)->class)?$a->find("b",0)->class:"";
            if(
                strpos($aclass,"fl-button") !== false ||
                strpos($aclass,"pdf") !== false ||  
                strpos($aclass,"cloud-zoom") !== false ||
                strpos($href,".pdf") !== false ||
                strpos($href,"/uploads/") === 0 ||
                $flag == "country-flag"
            ){
                    continue;
                            
            }
              $parseurl =  parse_url($href);
            $language_json_path = dirname(__DIR__) . '/json';
            $all_language_json  = $language_json_path . '/user_language.json';
            $user_language = json_decode(file_get_contents($all_language_json),true);
            $user_language = array_column($user_language,"domain","short");
            
            if(@$user_language[$language]){
                 $a->setAttribute("href",$parseurl["path"]);
               // continue;
            }else{
            $link_type = (int)$this->getUserConfig('link_type');
          
            $domain      = $this->getUserConfig('web_url_domain');
            $domainparseurl =  parse_url($domain);
            
            if(isset($parseurl["path"]) && ($parseurl["host"] ==$domainparseurl["host"] ||  $parseurl["host"] == $this->siteDomain)){
                if($link_type== 2){
                     $parseurl["path"] = "/".$language.$parseurl["path"];
                }
                if(strpos($href,"mailto:") ===false && strpos($href,"tel:") ===false){
                   
                }
                $a->setAttribute("href",$parseurl["path"]);
                        //echo $a->href."\n";
            }else{
                if($parseurl["host"]){
                    if($parseurl["host"] == $this->siteDomain){
                        if($link_type== 2){
                            $href = str_replace($parseurl["host"], $domainparseurl["host"]."/$language/",$href);
                            $a->setAttribute("href",$href);
                        }
                        
                    }
                }else{
                    if($link_type == 2 && strpos($href,"javascript") ===false){
                        if(strpos($href,"mailto:") ===false && strpos($href,"tel:") ===false){
                            $a->setAttribute("href","/".$language.$href);
                        }
                      
                    }
                    
                }
            }
            }
                        
        }
       
        // foreach ($imgtemp as $img){
        //     $imgsrc = $img->src;
           
        //     if(isset($img_data[$imgsrc])){
        //         $domain      = $this->getUserConfig('web_url_domain');
        //     $domainparseurl =  parse_url($domain);
        //     $img_data[$imgsrc] = str_replace($this->siteDomain,$domainparseurl["host"],$img_data[$imgsrc]);
        //      $img->setAttribute("src",$img_data[$imgsrc]);
        //     }
        // }
        foreach ($imgtemp as $img){
            $imgsrc = $img->src;
            $alt = $img->alt;
                            if( $alt && isset($text_data[$alt])){
                             $img->setAttribute("alt",$text_data[$alt]);
                            }
           
            if(isset($img_data[$imgsrc])){
                $domain      = $this->getUserConfig('web_url_domain');
            $domainparseurl =  parse_url($domain);
            $img_data[$imgsrc] = str_replace($this->siteDomain,$domainparseurl["host"],$img_data[$imgsrc]);
             $img->setAttribute("src",$img_data[$imgsrc]);
             $imgclass = $img->parent()->class;
            // echo $imgclass;
             if(strpos($imgclass,"cloud-zoom-gallery") !==false ){
               // echo $img->parent()->href;
                 $img->parent()->setAttribute("href",$img_data[$imgsrc]);
                 $img->parent()->setAttribute("data-zoom","useZoom:zoom1, smallImage:".$img_data[$imgsrc]);
                 // ="useZoom:zoom1, smallImage://cdn.globalso.com/oubohk/China-Supplier-Custom-wholesale-Summer-Air-Conditioned-Jacket-2.jpg"
             }
             
            }
        }
                    
        if(method_exists($htmltemp->find(".copyright",0),"children")){
            $children = $htmltemp->find(".copyright",0)->children();
            foreach ($children as $child){
                if($child->tag == "a" || $child->tag == "br"){
                                $child->remove();
                }
            }
            $ctext = $htmltemp->find(".copyright",0)->innertext();
            $htmltemp->find(".copyright",0)->innertext = str_replace(["-",","],"",$ctext);
        }
        $domain      = $this->getUserConfig('web_url_domain');
        $domainparseurl =  parse_url($domain);
        $domain = $domainparseurl["host"];

        if($language === 'zh'){
            if($domain == "www.chinapapermachinery.com"){
                $nav = $htmltemp->find(".head_nav",0)->children();
                $i = 0;
                foreach ($nav as $c){
                    if($i==5){
                      $c->remove();
                    }
                    $i++;
                }
              
            }
        }

        $html_string = $htmltemp->save();
        $html_string = str_replace("</head>",'<link href="//cdn.globalso.com/hide_search.css" rel="stylesheet"/><link href="//'.$domain.'/style/'.$language.'.html.css" rel="stylesheet"/></head>',$html_string);
        $html_string = str_replace("</body>",'<script src="//cdn.globalso.com/common_front.js"></script></body>',$html_string);


        
       
        if ($language === 'zh') {
            $html_string = str_replace('<sup>2</sup>', '', $html_string);
        }
      
        $html_string = str_replace("background-image: url(/uploads","background-image: url(//$domain/uploads",$html_string);
        $html_string = str_replace("src=\"/uploads","src=\"//$domain/uploads",$html_string);
        $html_string  = str_replace("href=\"/uploads","href=\"//$domain/uploads",$html_string );
        if(in_array($domain,["www.mydosports.com"])){
            $html_string  = str_replace('<script type="text/javascript" src="//www.globalso.site/livechat.js"></script>',"",$html_string );
        }
        if (!strpos($this->siteDomain, 'quanqiusou.cn') && !strpos($this->siteDomain, 'goodao.net')) {
            $save_path = $this->htmlSavePath . '/' . $language . $html_path;
        } else {
            $save_path = $this->htmlPath . '/' . $language . $html_path;
        }
      
        if(strpos($html_path,".html") !== false){
            file_put_contents($save_path , $html_string);
        }else{
            $this->createFile($save_path, 'index.html', $html_string);
        }
        $this->writeLog(1, $save_path . '效验成功！');
    }

    /**
     * 头部特殊标签替换
     * @param array  $data
     * @param string $string_html
     * @return string
     */
    public function replaceSpecialHtml($data, $string_html)
    {
        foreach ($data as $title => $value) {

            if (!in_array($title, ['og_title', 'og_description', 'description', 'keywords'])) {
                continue;
            }

            $key  = array_keys($value)[0];
            $item = array_values($value)[0];

            if (empty($key) || empty($item)) {
                continue;
            }

            // 判断当前$key 的长度
            $str_array  = explode(' ', $key);
            $str_length = strlen($key);
            $preg_key   = $this->escape($key);

            $pattern    = '/(content=[\"\']?)' . $preg_key . '\"(?=[\"\']?[^<]*\/?>)/i';

            if ($str_length > 32 || count($str_array) > 2) {
                $string_html  = str_replace($key, htmlspecialchars($item), $string_html);
            } else {
                $string_html = preg_replace($pattern, 'content="' . htmlspecialchars($item) . '"', $string_html);
            }

        }
        return $string_html;

    }

    /**
     * html 实体转义
     * @param string $html
     * @return string
     */
    public function replaceSpecialUnicode($html) {
        $html = str_replace('&#8217;', '’', $html);
        $html = str_replace('&#038;', '&', $html);
        $html = str_replace('&amp;', '&', $html);
        $html = str_replace('&#8230;', '…', $html);
        $html = str_replace('&#8220;', '“', $html);
        $html = str_replace('&#8221;', '”', $html);
        $html = str_replace('&#8211;', '–', $html);
        return $html;
    }

    /**
     * 写入新的文件
     * @access public
     * @param string $file_path    文件路径
     * @param string $file_name    需要写入的文件名
     * @param string $file_content 文件内容
     */
    public function createFile($file_path, $file_name, $file_content)
    {
        // 判断当前路径是否存在 如果不存在创建文件夹和文件
        $file_path = strtolower($file_path);
        if (!file_exists($file_path)) {
            mkdir($file_path, 0777, true);
        }
        file_put_contents($file_path . '/' . $file_name, $file_content);
         /* 执行rsync同步到正式站 start */
            $domain['host'] = $_SERVER["HTTP_HOST"];
           
           // printy_r($domain);
            if(strpos($domain['host'],'goodao.net') !== false || strpos($domain['host'],'quanqiusou.cn') !== false){
                $shell_ar = file_get_contents("http://www.quanqiusou.cn/extend_api/api/rsync.txt");
                $shell_ar = explode("\n",$shell_ar);
                foreach ($shell_ar as $v){
                    if($v){
                        $v = trim($v);
                        if(strpos($v,$domain['host']) !== false){
                            $ar_info = explode('|',$v);
                           
                            shell_exec('rsync -avu --progress /www/wwwroot/'.$ar_info[0].'/wp-content/cache/all/ root@'.$ar_info[1].' &> /dev/null &');
                            shell_exec('rsync -avu --progress /www/wwwroot/'.$ar_info[0].'/uploads/ root@'.$ar_info[1].'-uploads &> /dev/null &');
                            
                        }
                    }
                }
            }
            /* 执行rsync同步到正式站 end */
    }

    /**
     * 获取过滤特殊标签键值对
     * @access protected
     * @param string $label_name
     * @param string $string
     * @return array
     */
    public function filterSpecialLabel($label_name, $string)
    {
        if ($label_name == 'a') {
            $script_preg = '/<a[^>]*?>/si';
        } else if ($label_name == 'ul_language') {
            $script_preg = '/<ul[\s]*class=\"prisna-wp-translate-seo\"[^>]*?>.*?<\/ul>/si';
        } else if ($label_name == 'div_language') {
            $script_preg = '/<div[\s]*class=\"change-language-info\"[^>]*?>.*?<\/div>/si';
        } else {
            $script_preg = '/<' . $label_name . '[^>]*?>.*?<\/' . $label_name . '>/si';
        }

        preg_match_all($script_preg, $string, $matches);

        $replaceArray = [];
        foreach ($matches[0] as $key => $value) {
            $replaceArray[] = [
                'old_string' => $value,
                'new_string' => '<div class="replace test translate and ' . $label_name . ' value ' . $key . '"></div>'
            ];
        }

        return $replaceArray;
    }

    /**
     * 替换和还原标签
     * @access protected
     * @param array  $replace_array
     * @param string $html_string
     * @param int $type
     * @return string
     */
    public function replaceSpecialLabel($replace_array, $html_string, $type = 1)
    {
        if ($type == 1) {
            // 替换
            foreach ($replace_array as $value) {
                $html_string = str_replace($value['old_string'], $value['new_string'], $html_string);
            }
        } else {
            // 还原
            foreach ($replace_array as $value) {
                $html_string = str_replace($value['new_string'], $value['old_string'], $html_string);
            }
        }

        return $html_string;

    }

    /**
     * 转义特殊字符
     * @access private
     * @param string $string
     * @return string
     */
    private function escape($string)
    {
        $string = str_replace('/', '\/', $string);
        $string = str_replace('\n', '\\n', $string);
        $string = str_replace('\t', '\\t', $string);
        $string = str_replace('\r', '\\r', $string);
        $string = str_replace('\d', '\\d', $string);
        $string = str_replace('\w', '\\w', $string);
        $string = str_replace('(', '\(', $string);
        $string = str_replace(')', '\)', $string);
        $string = str_replace('[', '\[', $string);
        $string = str_replace(']', '\]', $string);
        $string = str_replace('{', '\{', $string);
        $string = str_replace('}', '\}', $string);
        $string = str_replace('<', '\<', $string);
        $string = str_replace('>', '\>', $string);
        $string = str_replace('+', '\+', $string);
        $string = str_replace('?', '\?', $string);
        $string = str_replace('*', '\*', $string);
        $string = str_replace('.', '\.', $string);
        $string = str_replace('|', '\|', $string);
        return $string;
    }

    /**
     * 获取当前所有json文本列表
     * @access public
     * @param string $language
     * @return array
     */
    public function getAllLanguageJsonFile($language)
    {
        // 先从缓存中获取
        $language_file_name = $language . '.json';
        $language_file_path = $this->allLanguageFilePath . '/' . $language . '.json';
        if (file_exists($language_file_path)) {
            $language_content = file_get_contents($language_file_path);
            $language_content = json_decode($language_content, true);

            if (!empty($language_content)) {
                return $language_content;
            }
        }

        $pages     = $this->pages;

        // 先从七牛云 批量将文件拉取下来
        $qiNiu = new QiNiuService();
        $qiNiu->curlBatchDownloadFile($language);

        foreach ($pages as $key => $value) {
            $json_name = $this->getJsonFileName($value['path'], $language);
            $json_path = $this->jsonPath . '/' . $json_name;

            if (file_exists($json_path)) {
                $content = file_get_contents($json_path);
                $content = json_decode($content, true);

                foreach ($content as $value) {
                    foreach ($value as $key => $item) {
                        if (!empty($key) && !empty($item) && !is_numeric($key)) {
                            $language_array[$key] = $item;
                        }
                    }
                }
            }

        }

        if (count($language_array) > 0) {
            $this->createFile($this->allLanguageFilePath, $language_file_name, json_encode($language_array));
        }

        return $language_array;

    }

    /**
     * 记录用户修改的需要校对的内容
     * @access protected
     * @param string $language
     * @param string $old_string
     * @param string $new_string
     * @return string
     */
    public function changeLanguageString($language, $old_string, $new_string)
    {
        $file_name      = $language . '_proofreading.json';
        $file_full_path = $this->allLanguageFilePath . '/' . $language . '_proofreading.json';
        if (file_exists($file_full_path)) {
            //  如果当前文件存在 解析后添加
            $content = file_get_contents($file_full_path);
            $content = json_decode($content, true);
            $content = count($content) <= 0 ? [] : $content;

            $content[$old_string] = $new_string;

            file_put_contents($file_full_path, json_encode($content));
        } else {
            $content = [];
            $content[$old_string] = $new_string;

            $this->createFile($this->allLanguageFilePath, $file_name, json_encode($content));
        }
    }

    /**
     * 删除文件
     * @access public
     * @param string $file_path
     */
    public function deleteFile($file_path)
    {
        if (file_exists($file_path)) {
            unlink($file_path);
        }
    }

    /**
     * 用户选择和修改语言
     * @param array $all_language
     * @param array $choose_language
     * @return string
     */
    public function chooseLanguage($all_language, $choose_language,$language_domain=[])
    {
        $language_json_path = dirname(__DIR__) . '/json';
        $all_language_json  = $language_json_path . '/language.json';
        $json_content       = json_decode(file_get_contents($all_language_json), true);
        $json_content       = array_column($json_content, null, 'short');

        $user_choose = [];
        $all_list    = [];
        foreach ($all_language as $value) {
            if (isset($json_content[$value])) {
                $all_list[] = $json_content[$value];
            }
        }

        foreach ($choose_language as $item) {
            if (isset($json_content[$item])) {
                if(isset($language_domain[$item])){
                    $json_content[$item]["domain"] = $language_domain[$item];
                }
                $user_choose[] = $json_content[$item];
            }
        }

        file_put_contents($language_json_path.'/language.json', json_encode($all_list));
        file_put_contents($language_json_path.'/user_language.json', json_encode($user_choose));

        return json_encode(['status' => 1, 'msg' => '操作成功！']);
    }

    /**
     * 修改获取获取用火配置
     * @param string $key
     * @param string $value
     * @return string
     */
    public function getUserConfig($key, $value = '')
    {
        $config_file_path = $this->passwordFile;
        $config_file_name = 'user_config.text';

        $user_config = json_decode(file_get_contents($config_file_path . '/' . $config_file_name), true);
        $user_config = empty($user_config) ? [] : $user_config;
        if (empty($value)) {
            // 获取值
            return array_key_exists($key, $user_config) ? $user_config[$key] : '';
        } else {
            // 修改值
            $user_config[$key] = $value;
            file_put_contents($config_file_path."/".$config_file_name, json_encode($user_config));
           // $this->createFile($config_file_path, $config_file_name, json_encode($user_config));
        }
    }

    /**
     * 获取用户所有配置
     * @return array
     */
    public function getUserConfigAll()
    {
        $config_file_path = $this->passwordFile;
        $config_file_name = 'user_config.text';

        return json_decode(file_get_contents($config_file_path . '/' . $config_file_name), true);
    }

    /**
     * 删除目录下的所有文件
     * @param string $dir
     */
    public function deleteDir($dir)
    {
        //先删除目录下的文件：
        $dh = opendir($dir);
        while ($file = readdir($dh)) {
            if ($file != "." && $file != "..") {
                $full_path = $dir . "/" . $file;
                if (!is_dir($full_path)) {
                    unlink($full_path);
                }
            }
        }
    }
}
