<?php

class BaseService
{
    /**
     * json 本地路径 和保存路径
     * @access public
     * @var string $jsonPath
     */
    public $jsonPath;

    /**
     * 本地html 缓存路径
     * @access public
     * @var string $htmlPath
     */
    public $htmlPath;

    /**
     * 生成记录log的路径
     * @access public
     * @var string $logPath
     */
    public $logPath;

    /**
     * 当前环境域名
     * @access public
     * @var string $siteDomain
     */
    public $siteDomain = '';

    /**
     * 当前站点所有翻译的页面
     * @access protected
     * @var array $pages
     */
    public $pages = [];

    /**
     * 翻译页面保存路径
     * @access protected
     * @var string $pagesFilePath
     */
    public $pagesFilePath = '';

    /**
     * 存放语言所有
     * @access protected
     * @var string $allLanguageFilePath
     */
    public $allLanguageFilePath = '';

    /**
     * 密码保存目录
     * @param string $oo
     * @return string
     */
    public $passwordFile = '';

    /**
     * 内容介绍
     * @param string $oo
     * @return string
     */
    public $htmlSavePath = '';

    public $uploadPath = "";
    /**
     * 数据初始化
     */
    public function __construct()
    {
        $parent_path    = dirname(dirname(dirname(__DIR__)));
        $this->htmlSavePath = $_SERVER['DOCUMENT_ROOT'];
        $this->jsonPath = $this->htmlSavePath . '/uploads/json';
        $this->htmlPath = $parent_path . '/cache/all';
        //$this->uploadPath = $parent_path . '/uploads/json';
        $this->logPath  = $parent_path . '/cache/log';
        $this->allLanguageFilePath  = $parent_path . '/cache/all_language';
        $this->passwordFile = $parent_path . '/cache';
        $this->siteDomain = $this->getSiteDomain();
        $this->pagesFilePath = $parent_path . '/cache/pages_list.json';
        $time = filemtime($this->pagesFilePath);
        if (file_exists($this->pagesFilePath) && (time()-$time) < 86400) {
            $content = file_get_contents($this->pagesFilePath);
            $content = json_decode($content, true);
            if (count($content) > 0) {
                $this->pages = $content;
            }
        }

        if (empty($this->pages)) {
            $this->pages = $this->getPageList();
        }
    }



    

    /**
     * 记录日志
     * @access protected
     * @param int $type    log 信息的表示 1: 成功 2: 失败
     * @param int $content log 日志内容
     */
    public function writeLog($type, $content)
    {

        switch ($type) {
            case 2:
                $tips = 'error';
                break;
            case 3:
                $tips = 'backend';
                break;
            default:
                $tips = 'success';
                break;
        }

        $file_path = $this->logPath . '/' . date('Y-m-d');
        $file_name = $tips . '.text';

        // 判断当前路径是否存在 如果不存在创建文件夹和文件
        if (!file_exists($file_path)) {
            mkdir($file_path, 0777, true);
        }

        file_put_contents($file_path . '/' . $file_name, date('H:i:s') . '--' . $content . PHP_EOL, FILE_APPEND);
    }

    /**
     * 获取json文件路径
     * @access protected
     * @param string $path
     * @param string $language
     * @return string
     */
    public function getJsonFileName($path, $language)
    {
        return 'en_' . $language . '_' . md5($path) . '.json';
    }

    /**
     * 获取当前需要校对的所有页面
     * @access public
     * @return array
     */
    public function getPageList()
    {
        require_once(dirname(dirname(dirname(dirname(__DIR__)))) . '/wp-load.php');
        global $wpdb;
        $except_post_type = ['3code','acf','admin','ad_img','attachment','banner','banner-sidebar','banner_sidebar','cf7_entry','dw_license','fl-builder-template','gd-admin','helppage','home','import_users','lianxi','nav_menu_item','p','pro','pro_detail','pro_shuxing','skype','sns','title','transall','v','wpcf7_contact_form','ww','post','page','revision','vs','wp_automatic'];
        $post_types_res = $wpdb->get_results('select post_type from wp_posts group by post_type',ARRAY_A);
        $post_types = [];
        foreach ($post_types_res as $v){
            if(!in_array($v['post_type'],$except_post_type)){
                $post_types[] = $v['post_type'];
            }
        }
        $ar_url = array();
        $ar_url[] = home_url('/');
        $args = array(
            'hide_empty'  => 0
        );
        $categories = get_categories( $args );
        $per_page_num = get_option('posts_per_page');
        $cat_ids = array();
        foreach($categories as $category){
            if($category->name != 'Featured' && $category->name != 'Featured Products'){
                $cat_ids[] = $category->term_id;
                $categoryid = $category->term_id;
                $category_link = get_category_link( $categoryid );
                $ar_url[] = $category_link;
                if($category->count > $per_page_num){
                    $page_count = ceil($category->count/$per_page_num);
                    for($i=2;$i<=$page_count;$i++){
                        $ar_url[] = $category_link . 'page/' . $i .'/';
                    }
                }
            }
        }
        if($post_types){
            foreach ($post_types as $v){
                $gallery_url = $this->get_cate_zdy_url($v,$per_page_num);
                if($gallery_url){
                    $ar_url = array_merge($ar_url,$gallery_url);
                }
                $ar_url[] = home_url("/").$v.'/';
    		    $news_num = count(query_posts(array( 'post_type' => $v,'posts_per_page'=>-1)));
        		if($news_num>$per_page_num){
        		    $page_count = ceil($news_num/$per_page_num);
					for($i=2;$i<=$page_count;$i++){
						$ar_url[] = home_url("/").$v.'/'.'page/'.$i.'/';
					}
        		}
                query_posts(array( 'post_type' => $v,'showposts' => 5000) ); while (have_posts()) : the_post();
                    $ar_url[] = get_permalink($post->ID);
                endwhile; wp_reset_query();
            }
        }
        query_posts(array( 'post_type' => 'page','showposts' => 5000) ); while (have_posts()) : the_post();
        $ar_url[] = get_permalink($post->ID);
    endwhile; wp_reset_query();
        $ar_url_cnt = count($ar_url);
        $posts = $wpdb->get_results("select ID from wp_posts where post_date_gmt!='2016-01-08 00:00:00' and post_type='post' and post_status='publish'");
		if($posts){
          foreach($posts as $post){
            $ar_url[] = get_permalink($post->ID);
          }
        }   
        $ar_url = array_unique($ar_url);
        $return_array = [];
        foreach ($ar_url as $item) {
            $return_array[] = [
                'path' => str_replace(home_url(), '', $item),
                'link' => $item
            ];
        }

        if (count($return_array) > 0) {
            file_put_contents($this->pagesFilePath, json_encode($return_array));
        }

        return $return_array;
    }

    /**
     * 获取当前站点域名
     * @access public
     * @return string
     */
    public function getSiteDomain()
    {
         //return 'x1881.quanqiusou.cn';
        return $_SERVER['HTTP_HOST'];
    }

    /**
     * 获取自定义URL
     * @access public
     * @param string $cat_type
     * @param int $per_page_num
     * @param int $has_parent
     * @return array
     */
    function get_cate_zdy_url($cat_type = 'news',$per_page_num = 0,$has_parent = 1){
        $count_g = 0;
		$taxnomy = $cat_type.'_catalog';
        $arg = array(
            'taxonomy' => $taxnomy,
            'orderby' => 'name',
            'show_count' => 1,
            'pad_counts' => 0,
            'hierarchical' => 0
        );
        $ar_url = array();
        $categories = get_categories( $arg );
        if(isset($categories['errors'])){
            return $ar_url;
        }
        foreach($categories as $category){
			$category_link = home_url("/").$cat_type.'_catalog/'.$category->slug.'/';
            $ar_url[] = $category_link;
            if($category->count > $per_page_num){
                $page_count = ceil($category->count/$per_page_num);
                for($i=2;$i<=$page_count;$i++){
                    $ar_url[] = $category_link.'page/'.$i.'/';
                }
            }
            if($has_parent == 0){
                $count_g += $category->count;
            }
        }
        if($has_parent == 0){
            $ar_url[] = home_url("/").$cat_type.'/';
            $g_page_count = ceil($count_g/$per_page_num);
            for($i=2;$i<=$g_page_count;$i++){
                $ar_url[] = home_url("/").$cat_type.'/page/'.$i.'/';
            }

        }
        return $ar_url;
    }
}