<?php
/**
 * Plugin Name: 翻译校对
 * Plugin URI: #
 * Description: 翻译校对
 * Version: 2.0.00
 * Author: zhang chao
 * Author URI: #
 */

add_action('admin_menu', 'proofreading');

function proofreading() {
    add_menu_page('翻译校对', '翻译校对', 7, 'proofreading');
    add_submenu_page('proofreading', '翻译校对', '翻译校对', 7, 'proofreading', 'proofreading_data');
}

function proofreading_data () {

    require_once dirname(__FILE__) . '/services/FileService.php';
    $service  = new FileService();
    $pages    = $service->pages;
    $language = file_get_contents(dirname(__FILE__) . '/json/language.json');
    $language = json_decode($language, true);

    file_put_contents(dirname(__FILE__) . '/json/language.json',json_encode($language,JSON_UNESCAPED_UNICODE));

    // 缓存平台域名
    $cdn_setting = get_option("gd_cdn_setting");
    $domain      = isset($cdn_setting['weburl']) && !empty($cdn_setting['weburl']) ? $cdn_setting['weburl'] : '';
    $wsdomain = parse_url($domain);
    $testdomain = $_SERVER["HTTP_HOST"];
    $service->getUserConfig('web_url_domain', $domain);
    $service->getUserConfig('home_url_no', home_url());
    $service->getUserConfig('home_url', home_url("/"));
    $link_type = (int)$service->getUserConfig('link_type');
    $link_type = $link_type > 0 ? $link_type : 1;
    $link_select1 = $link_type == 1 ? 'selected' : '';
    $link_select2 = $link_type == 2 ? 'selected' : '';

    $user_language_path = dirname(__FILE__) . '/json/user_language.json';
    if (file_exists($user_language_path)) {
        $user_language = file_get_contents(dirname(__FILE__) . '/json/user_language.json');
        $user_language = json_decode($user_language, true);
        $user_language_keys = !empty($user_language) || !is_null($user_language) ? array_column($user_language, 'short') : [];
    } else {
        $user_language      = [];
        $user_language_keys = [];
    }

    // 选择页面 语种选择组装
    $choose_language_list = count($user_language) > 0 ? $user_language : $language;
    $pr_language_html   = '';
    foreach ($choose_language_list as $ll) {
        if($ll['short'] == $_GET["language"]){
            $pr_language_html .= '<option value="' . $ll['short'] . '" selected>' . $ll['chinese'] . '</option>';
        }else{
            $pr_language_html .= '<option value="' . $ll['short'] . '">' . $ll['chinese'] . '</option>';
        }
    }

    // 获取用户所有配置
    $user_config      = $service->getUserConfigAll();
    $is_start         = isset($user_config['is_start']) ? (int)$user_config['is_start'] : 2;
    $is_start_checked = $is_start == 1 ? 'checked' : '';

    $is_open_customer_proofreading = isset($user_config['is_open_customer_proofreading']) ? (int)$user_config['is_open_customer_proofreading'] : 2;
    $is_open_customer_proofreading_checked = $is_open_customer_proofreading == 1 ? 'checked' : '';
    $open_customer_proofreading_html = $is_open_customer_proofreading == 1 ? '<div class="form-button form-waring" id="addText">添加校对文本</div>' : '';

    $user_password    = isset($user_config['password']) ? $user_config['password'] : '';

    // 页面选择列表
    $pages_html = '';
    foreach ($pages as $value) {
        $path = parse_url($_GET["jump_url"]);
        if($value['path'] == $path['path']){
            $pages_html .= '<option value="' . $value['path'] . '" selected>' . $value['path'] . '</option>';
        }else{
            $pages_html .= '<option value="' . $value['path'] . '">' . $value['path'] . '</option>';
        }
       
    }

    // 所有语言和一选择的语言列表
    $language_string = '<ul class="prisna-wp-translate-seo prisna-wp-translate-seo-test" id="prisna-translator-seo">';
    foreach ($language as $item) {

        $is_checked = in_array($item['short'], $user_language_keys) ? 'checked' : '';
        $language_string .= '<li class="language-flag language-flag-' . $item['short'] . '" data-value="' . $item['short'] . '">
            <label><input type="checkbox" name="check_box_choose" class="check-box check-language" ' . $is_checked . '>
            <a href="javascript:;">
                <b class="country-flag"></b>
                <span>' . $item['chinese'] . '</span>
            </a>
            </label>
        </li>';
    }
    $language_string .= '</ul>';

    // 所有语言和一选择的语言列表
    $trans_language_string = '<ul class="prisna-wp-translate-seo prisna-wp-translate-seo-test" id="prisna-translator-seo">';
    foreach ($language as $item) {

        $is_checked = in_array($item['short'], $user_language_keys) ? 'checked' : '';
        $trans_language_string .= '<li class="language-flag language-flag-' . $item['short'] . '" data-value="' . $item['short'] . '">
            <label><input type="checkbox" name="trans_box_choose" class="check-box check-language" ' . $is_checked . '>
            <a href="javascript:;">
                <b class="country-flag"></b>
                <span>' . $item['chinese'] . '</span>
            </a>
            </label>
        </li>';
    }
    $trans_language_string .= '</ul>';

    // 多语言校对连接
    $more_language_url = home_url() . '/admin/plugins/proofreading/index.php';

    echo '<!DOCTYPE html>
        <html lang="zh-cmn-Hans">
        <head>
            <meta charset="UTF-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
            <meta name="renderer" content="webkit|ie-comp|ie-stand">
            <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
            <title></title>
            <link rel="stylesheet" type="text/css" href="/wp-content/plugins/proofreading/resource/css/global.css">
            <link rel="stylesheet" type="text/css" href="/wp-content/plugins/proofreading/resource/css/pages.css?v=10">
            <link rel="stylesheet" type="text/css" href="/wp-content/plugins/proofreading/resource/css/language.css">
            <link rel="stylesheet" type="text/css" href="/wp-content/plugins/proofreading/resource/select2/select2.min.css">
            <style>
            .nav_information_items_wrap > li .form-group .form-item.radio_item,.table-language-list{display:none;}
            .radio_label{margin-right:20px;}
            .radio_label input[name=source_type]{ margin-right:6px}
            .content_image{width:80px;cursor: pointer;}
            .content_text{width:80px;cursor: pointer;}
            .content_lable{display:flex;text-align:center;border-bottom:1px solid #e9efff;margin-bottom:10px}
            .content_lable .active{
                background:#e9efff
            }
            .src-img{
                height:200px
            }
            .json_img_tr{
                border-bottom:1px solid #e9efff;
            }
            .json_img_td{
                text-align:center;
                padding:5px;
                width:49%
            }
            .layui-progress{
                position: relative;
                border-radius: 20px;
                background-color: #eee;
                height: 18px;
                line-height: 18px;
            }
            .layui-progress-bar{
                position: absolute;
                left: 0;
                top: 0;
                width: 0;
                max-width: 100%;
                height: 18px;
                border-radius: 20px;
                text-align: right;
                background-color: #5FB878;
                transition: all .3s;
                -webkit-transition: all .3s;
            }
            .layui-progress-text{
                position: static;
                padding: 0 10px;
                color: #fff;
                line-height: 18px;
                font-size: 12px;
                word-break: normal;
                
            }
        </style> 
        </head>
        
        <body>
        <div class="sys-page">
            <div class="ai-biz-panel ai-biz-top">
                <div class="panel-body">
                    <div class="d-table d-table-middle">
                        <div class="fee-tips tb-cell">
                            <p class="fee-tips-msg"><b>翻译校对：</b>翻译校对已正式上线
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ai-biz-panel ai-biz-list ">
                <div class="ai-trade-panel add_ai_content">
                    <div class="add_ai_content_left full-left">
                        <div class="add_ai_content_left_title pages-title-style">
                            <ul class="pages-title-tab">
                                <li class="tab-item active"><span>翻译校对</span></li>
                                <li class="tab-item"><span>校对配置</span></li>
                                <li class="tab-item"><span>专业校对</span></li>
                                <li class="tab-item" id="clear-cache"><span>清除翻译缓存</span></li>

                               <!-- <li class="tab-item"  id="trans" domain="'.$wsdomain["host"].'"><span>翻译全部</span></li> -->
                            </ul>
                        </div>
                        <div class="information_items nav_information_items">
                            <ul class="nav_information_items_wrap loading">
                                <li class="active">
                                    <div class="form-group">
                                        <div class="form-item">
                                            <p class="form-title">选择页面：</p>
                                            <div class="form-input">
                                                <select class="form-control" name="path" id="id_select2_demo1" style="width: 280px">
                                                    <option value="">请选择需要校对的页面</option>
                                                    ' . $pages_html . '
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-item">
                                            <p class="form-title">选择语种：</p>
                                            <div class="form-input">
                                                <select class="form-control" name="language" id="id_select2_demo2" style="width: 280px">
                                                    <option value="">请选择需要校对的语种</option>
                                                    '. $pr_language_html .'
                                                </select>
                                            </div>
                                            <div data-t="0" class="form-button getJson" >
                                                确认
                                            </div>
                                            <div data-t="1" class="form-button getJson">
                                                同步翻译
                                            </div>
                                            ' .  $open_customer_proofreading_html . '
                                        </div>
                                    </div>
                                    <div class="table-language-list">
                                    <div class="content_lable">
                                        <div class="content_text active">文本</div>
                                        <div class="content_image">图片</div>
                                       
                                    </div>
                                        <table id="json-table"></table>
                                        <table id="json-table-img" wpnonce = '.wp_create_nonce('media-form').'>
                                            <tr>
                                                <td>还没有图片数据<td>
                                            </tr>
                                            
                                        </table>
                                    </div>
                                </li>
                                <li>
                                    <div class="all-choose-box" style="margin: 20px 0;">
                                        <label class="ipt-addon-group">
                                            <input type="checkbox" class="check-box check-all">
                                            <span class="mb-show-only" style="display: inline;">全选</span>
                                        </label>
                                    </div>
                                    <div class="language-list">
                                        ' . $language_string . '
                                    </div>
                                </li>
                                <li>
                                    <div class="form-group">
                                        <div class="form-item">
                                            <p class="form-title">设置校对密码：</p>
                                            <div class="form-input">
                                                <input type="text" name="password" placeholder="请设置密码" value="' . $user_password . '">
                                            </div>
                                            <div class="form-button" id="confirm">
                                                确认
                                            </div>
                                        </div>
                                        <div class="form-item">
                                            <p class="form-title">
                                                <a href="' . $more_language_url . '" target="_blank" style="color: #4680fe">专业校对链接: ' . $more_language_url . ' </a>
                                            </p>
                                        </div>
                                    </div>
                                    <div class="table-language-list">
                                        <table id="json-table"></table>
                                       
                                    </div>
                                </li>
                                <li></li>
                                <li>
                                    <div class="all-choose-box" style="margin: 20px 0;">
                                        <label class="ipt-addon-group">
                                            <input type="checkbox" class="check-box check-all">
                                            <span class="mb-show-only" style="display: inline;">全选</span>
                                        </label>
                                    </div>
                                    <div class="language-list">
                                        ' . $trans_language_string . '
                                    </div>
                                </li>
                            </ul>
        


                            <div id="page" class="page_btn tab-button-list">
                                <ul>
                                    <li class="active">
                                        <div class="button-list">
                                            <button class="button button-pri change-button" data-type="1">修改当前页面</button>
                                            <button class="button button-war change-button" data-type="2">修改所有页面</button>
                                            <!--<button class="button button-war "  style="background: #e2a818;" id="clear-bakfile">清除较对备份</button>-->
                                            
                                        </div>
                                    </li>
                                    <li>
                                        <div class="choose_language_button">
                                            <div class="choose_all_box">
                                                <label>选择链接格式:</label> <select name="link_type" style="width: 180px;">
                                                    <option value="1" ' . $link_select1 .'>二级域名</option>
                                                    <option value="2" ' . $link_select2 .'>二级目录</option>
                                                </select>　　　
                                                <label class="ipt-addon-group">
                                                    <input type="checkbox" class="check-box is_start" ' . $is_start_checked . '>
                                                    <span class="mb-show-only" style="display: inline;">是否启用</span>
                                                </label>
                                                <label class="ipt-addon-group">
                                                    <input type="checkbox" class="check-box is_open_customer_proofreading" ' . $is_open_customer_proofreading_checked . '>
                                                    <span class="mb-show-only" style="display: inline;">是否开启自定义校对文本</span>
                                                </label>
                                            </div>
                                            <div class="choose_true_button">
                                                 <button class="button button-pri save-language">确认</button>
                                            </div>
                                        </div>
                                    </li>
                                    <li></li>
                                    <li></li>
                                    <li>
                                    <div class="choose_true_button">
                                                 <button class="button button-pri save-trans" domain="'.$wsdomain["host"].'">确认</button>
                                            </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
 
        </body>
        <script src="/wp-content/plugins/proofreading/resource/js/jquery-2.1.4.min.js"></script>
        <script src="/wp-content/plugins/proofreading/resource/select2/select2.min.js"></script>
        <script src="/wp-content/plugins/proofreading/resource/layer/layer.js"></script>
        <script src="/wp-content/plugins/proofreading/resource/sortable/sortable.min.js"></script>
        <script src="/wp-content/plugins/proofreading/resource/js/ajaxupload.3.9.js?v=54"></script>
        <script src="/wp-content/plugins/proofreading/resource/js/jquery.base64.js"></script>
        <script src="/wp-content/plugins/proofreading/resource/js/jquery.websocket.js?12345"></script>
        <script src="/wp-content/plugins/proofreading/resource/js/pages.js?v=20"></script>
        
        </html>';
}

add_action( 'wp_footer', 'add_language' );

function add_language() {

    // 获取用户设置的链接方式
    require_once dirname(__FILE__) . '/services/FileService.php';
    $service   = new FileService();

    // 判断语言模板是否启用
    $user_config      = $service->getUserConfigAll();
    $is_start         = isset($user_config['is_start']) ? (int)$user_config['is_start'] : 2;

    $pages    = array_column($service->pages, 'path');
    $newPages = [];
    foreach ($pages as $value) {
        if (strrpos($value, '/') === strlen($value) - 1 && strlen($value) > 1) {
            $value = substr($value,0,strlen($value)-1);
        }
        $newPages[] = $value;
    }

    $service_uri = $_SERVER['REQUEST_URI'];
    if (strrpos($service_uri, '/') === strlen($service_uri) - 1 && strlen($service_uri) > 1) {
        $service_uri = substr($service_uri,0,strlen($service_uri)-1);
    }

    if ($is_start != 1 || !in_array($service_uri, $newPages)) {
        echo '';
    } else {
        // 获取用户选择的链接方式
        $link_type = (int)$service->getUserConfig('link_type');
        $link_type = $link_type > 0 ? $link_type : 1;

        $user_language_path = dirname(__FILE__) . '/json/user_language.json';
        if (file_exists($user_language_path)) {
            $language = json_decode(file_get_contents($user_language_path), true);
        } else {
            $language = [];
        }

        if (empty($language)) {
            $language      = file_get_contents(dirname(__FILE__) . '/json/language.json');
            $language      = json_decode($language, true);
        }

        $cdn_setting = get_option("gd_cdn_setting");
        $domain   = isset($cdn_setting['weburl']) && !empty($cdn_setting['weburl']) ? $cdn_setting['weburl'] : '';



        if (!empty($domain)) {

            // 循环正式域名 获取语种正确的域名
            $domains         = explode('.', $domain);
            $language_domain = 'language_url';

            foreach ($domains as $key => $vo) {
                if ($key > 0) {

                    if ($vo === end($domains)) {
                        $vo = str_replace('/', '', $vo);
                    }

                    $language_domain .= '.' . $vo;
                }

            }

            $language_html  = '';
            $domain_slash = explode('/', $domain);
            $english_domain = str_replace('language_url', $domain_slash[0] . '//www', $language_domain) . $_SERVER['REQUEST_URI'];

            if ($link_type == 1) {
                $english_href = '<a href="' . $english_domain . '" title="English" target="_blank"><b class="country-flag"></b><span>English</span></a>';
            } else {
                $english_href = '<a href="' . $english_domain . '" title="English"><b class="country-flag"></b><span>English</span></a>';
            }

            $language_html .= '<li class="language-flag language-flag-en">' . $english_href . '</li>';
            foreach ($language as $value) {
                $link_href = '';
                if ($link_type == 1) {
                    $href = str_replace('language_url', 'http://' . $value['short'], $language_domain) . $_SERVER['REQUEST_URI'];
                    $link_href = '<a href="' . $href . '" title="' . $value['english'] . '" target="_blank"><b class="country-flag"></b><span>' . $value['english'] . '</span></a>';
                } else {
                    $href = $domain . $value['short'] . $_SERVER['REQUEST_URI'];
                    $link_href = '<a href="' . $href . '" title="' . $value['english'] . '"><b class="country-flag"></b><span>' . $value['english'] . '</span></a>';
                }
                $language_html .= '<li class="language-flag language-flag-' . $value['short'] . '">' . $link_href . '</li>';
            }

            echo '<ul class="prisna-wp-translate-seo" id="prisna-translator-seo">' . $language_html . '</ul>';
        }
    }
}
