<?php

require dirname(__FILE__) . '/services/FileService.php';

$service = new FileService();
$method  = $_GET['type'];

function unescape ($source){ 
    $decodedStr = ""; 
    $pos = 0; 
    $len = strlen ($source); 
    while ($pos < $len){ 
       $charAt = substr ($source, $pos, 1); 
             if ($charAt == '%'){ 
        $pos++; 
        $charAt = substr ($source, $pos, 1); 
                 if ($charAt == 'u'){ 
         // we got a unicode character 
         $pos++; 
         $unicodeHexVal = substr ($source, $pos, 4); 
         $unicode = hexdec ($unicodeHexVal); 
         $entity = "&#". $unicode . ';'; 
         $decodedStr .= utf8_encode ($entity); 
         $pos += 4; 
                 }else{ 
         // we have an escaped ascii character 
         $hexVal = substr ($source, $pos, 2); 
         $decodedStr .= chr (hexdec ($hexVal)); 
         $pos += 2; 
        } 
       }else{ 
        $decodedStr .= $charAt; 
        $pos++; 
       } 
    } 
    return $decodedStr; 
    }
// 获取当前需要翻译的文件的数据 返回到前端
if ($method == 'get_json') {
    $param  = $_POST;
    $result = $service->getLanguageJson($param['path'], $param['language'],$param['t']);
    echo $result;
}

if($method == "get_user_language"){
    $user_language_path = dirname(__FILE__) . '/json/user_language.json';
    if (file_exists($user_language_path)) {
        $user_language = file_get_contents(dirname(__FILE__) . '/json/user_language.json');
    } else {
        $user_language      ="[]";
    }
    echo $user_language;
}



// 提交校对
if ($method == 'proofreading') {
    $param    = $_POST;
    $type     = isset($param['status']) ? intval($param['status']) : 1;
    $path     = isset($param['path']) ? $param['path'] : '';
    $language = isset($param['language']) ? $param['language'] : '';
    $language_data = isset($param['language_data']) ? $param['language_data'] : [];
    if (empty($path) || empty($language) || count($language_data) <= 0) {
        echo json_encode(['status' => 0, 'msg' => '操作失败，参数错误！']);
        exit();
    }
    foreach($language_data['change_data'] as $k=>&$v){
        if($v["type"] == "texts"){
            $v['source'] = base64_decode($v['source']);
            $v['new_string'] = stripslashes($v['new_string']);
        }
    }
    $result   = $service->proofreading($type, $path, $language, $language_data);
    echo $result;
}

// 校对成功过后 在后台执行文件上传 用户无感知
if ($method == 'proofreading_success') {
    // 校对成功后 后台上传校对后的json 文件
    ignore_user_abort();
    set_time_limit(0);

    $qiNiuService = new QiNiuService();
    $pages        = $qiNiuService->pages;
    $param        = $_POST;
    $language     = isset($param['language']) ? $param['language'] : '';
    foreach ($pages as $key => $value) {
        $json_file_name  = $service->getJsonFileName($value['path'], $language);
        $local_file_path = $qiNiuService->jsonPath . '/' . $json_file_name;
        if (file_exists($local_file_path)) {
            $content = file_get_contents($local_file_path);
            if ($content != null || !empty($content)) {
                $load_result    = $qiNiuService->uploadFile($local_file_path);
                if ($load_result) {
                    $qiNiuService->writeLog(3, '文件上传成功: ' . $local_file_path);
                } else {
                    $qiNiuService->writeLog(3, '文件上传失败: ' . $local_file_path);
                }
            }
        } else {
            $qiNiuService->writeLog(3, '文件上传失败，找不到文件 == ' . $local_file_path);
        }
    }
}

// 用户选择语言操作
if ($method == 'chooseLanguage') {
    $param = $_POST;
    $language_all    = isset($param['language_all']) ? $param['language_all'] : [];
    $language_choose = isset($param['language_choose']) ? $param['language_choose'] : [];
    $link_type       = isset($param['link_type']) ? $param['link_type'] : 1;
    $is_start        = isset($param['is_start']) ? (int)$param['is_start'] : 2;
    $is_open_customer_proofreading = isset($param['is_open_customer_proofreading']) ? (int)$param['is_open_customer_proofreading'] : 2;

    $service->getUserConfig('link_type', $link_type);
    $service->getUserConfig('is_start', $is_start);
    $service->getUserConfig('is_open_customer_proofreading', $is_open_customer_proofreading);

    if (empty($language_all)) {
        echo json_encode(['status' => 0, 'msg' => '操作失败!']);
    }

    $result = $service->chooseLanguage($language_all, $language_choose);
    echo $result;
}

// 修改或者编辑校对页面登录米面
if ($method == 'changePassword') {
    $param = $_POST;
    $password = isset($param['password']) ? $param['password'] : '';

    if (empty($password) || strlen($password) < 6) {
        echo json_encode(['status' => 1, 'msg' => '密码长度必须大于登录6位！']);
    }

    $service->getUserConfig('password', $password);
    echo json_encode(['status' => 1, 'msg' => '密码修改成功！']);

}

// 清除page缓存
if ($method === 'clearPagesCache') {
    $page_path = $service->pagesFilePath;
    $service->deleteDir($service->allLanguageFilePath);
    unlink($page_path);
    echo json_encode(['status' => 1, 'msg' => '缓存清除成功！']);
}

// 清除page备份
if ($method === 'clearPFilebak') {
    $param = $_POST;
    if(!$param['path']){
       
        die(json_encode(['status' => 1, 'msg' => '选择一个页面']));
    }
    if($param["language"]){
        $json_file_name  = $service->getJsonFileName($param['path'], $param["language"]);
       // echo $json_file_name;
        $local_file_path = $qiNiuService->jsonPath . '/' . $json_file_name;
        $qiNiuService = new QiNiuService();
        $qiNiuService->deleteFile($local_file_path);

        echo json_encode(['status' => 1, 'msg' => '缓存清除成功！']);
    }else{
        $user_language_path = dirname(__FILE__) . '/json/user_language.json';
        if (file_exists($user_language_path)) {
            $user_language = json_decode(file_get_contents(dirname(__FILE__) . '/json/user_language.json'));
        } else {
            $user_language      =[];
        }
        foreach($user_language as $k=>$v){
                    
            $json_file_name  = $service->getJsonFileName($param['path'], $v->short);
            $local_file_path = $qiNiuService->jsonPath . '/' . $json_file_name;
            $qiNiuService = new QiNiuService();
            $qiNiuService->deleteFile($local_file_path);

       
        }
        echo json_encode(['status' => 1, 'msg' => '备份清除成功！']);
    }
}
    