<?php

include "simple_html_dom.php";
//include "Bt.php";

class Translate 
{

    private $redis;
    private $bt;
    private $fd;
    public function __construct()
    {
     //  $this->bt = new Bt();
        $this->redis = new Redis();
        $this->redis->connect('161.8.184.24', 6388);
        $this->redis->auth('globalso@2020');
        $this->serv = new swoole_server('0.0.0.0', 9502);
        
        $this->serv->set([
        
        'worker_num' => 2, //开启2个worker进程
        
        'max_request' => 4, //每个worker进程 max_request设置为4次
        
        'task_worker_num' => 4, //开启4个task进程
        
        'dispatch_mode' => 2, //数据包分发策略 - 固定模式
        'daemonize' => 1,
        
        ]);
        
        
        $this->serv->on('Start', [$this, 'onStart']);
        
        $this->serv->on('Connect', [$this, 'onConnect']);
        
        $this->serv->on("Receive", [$this, 'onReceive']);
        
        $this->serv->on("Close", [$this, 'onClose']);
        
        $this->serv->on("Task", [$this, 'onTask']);
        
        $this->serv->on("Finish", [$this, 'onFinish']);
        
        
        
        $this->serv->start();
    }
    public function onConnect($serv, $fd) {
    
        echo "#### onConnect ####".PHP_EOL;
        
        echo "客户端:".$fd." 已连接".PHP_EOL;
        
        echo "########".PHP_EOL.PHP_EOL;
        
        }
        public function onStart($serv) {
    
            echo "#### onStart ####".PHP_EOL;
            
            echo "SWOOLE ".SWOOLE_VERSION . " 服务已启动".PHP_EOL;
            
            echo "master_pid: {$serv->master_pid}".PHP_EOL;
            
            echo "manager_pid: {$serv->manager_pid}".PHP_EOL;
            
            echo "########".PHP_EOL.PHP_EOL;
            
            }

    public function onReceive($serv, $fd, $from_id, $data) {
    
        echo "#### onReceive ####".PHP_EOL;
        
        echo "worker_pid: {$serv->worker_pid}".PHP_EOL;
       // var_dump($data);
        $data = json_decode($data);
       
       
        $rediskey =  "globalso_trans:$data->domain";

        while($page = $this->redis->rpop($rediskey)){
            $page = json_decode($page,true);
            $page["domain"] = $data->domain;
            $page["docmentRoot"] = $data->docmentRoot;
            $rs = $serv->task($page);
        }
       //
        
        if ($rs === false) {
        
        echo "任务分配失败 Task ".$rs.PHP_EOL;
        
        } else {
        
        echo "任务分配成功 Task ".$rs.PHP_EOL;
        
        }
        
        
        echo "########".PHP_EOL.PHP_EOL;
        
        }


        public function onTask($serv, $task_id, $from_id, $s_data) {

            $data = [
                "data"=>$s_data,
                "docmentRoot"=>$s_data["docmentRoot"]
            ];

            $this->poptrans($data,$s_data["domain"]);

            $serv->finish($s_data);
        }

        public function onFinish($serv,$task_id, $data) {
    
            echo "#### onFinish ####".PHP_EOL;
            
            echo "Task {$task_id} 已完成".PHP_EOL;
            
            echo "########".PHP_EOL.PHP_EOL;
            
            }
            
            
            
            public function onClose($serv, $fd) {
            
            echo "Client Close.".PHP_EOL;
            
            }
            
    

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle($domain)
    {
       
       set_time_limit(0);

        $starttimie = microtime(true);
        //$info = $this->bt->GetSystemTotal();

      

     
           
            $fockNunber = 6;
           
            $rediskey =  "globalso_trans:$domain";
           
            $execute = 0;
            while($page = $this->redis->rpop($rediskey)){
               
                    $pids = pcntl_fork();
                    if($pids == 0){
                   
                    
                    // $page = $this->redis->rpop($rediskey);
                    // var_dump($page);
                try{
                            $data = [
                                "data"=>json_decode($page,true),
                                "docmentRoot"=>dirname(dirname(__FILE__))
                            ];

                            $this->poptrans($data,$domain);
                    }catch(\Exception $e){
             
        }
error_reporting(0);
 $error = error_get_last ();
 var_dump($error);
                        
                        exit;
                    }elseif($pids >0){
                        $execute++;
                        if ($execute>=$fockNunber){
                            pcntl_wait($status);
                            $execute--;
                        }
                    }
                
            }
      
           
      
        //exit;
    }

    public function getJsonFileName($path, $language)
    {
        return 'en_' . $language . '_' . md5($path) . '.json';
    }

    public function poptrans($data,$domain){
        $start = microtime(true);
        foreach($data["data"] as $res){
           
            $start = microtime(true);
            $parent_path   = $data["docmentRoot"];
            $path = $res["path"]["path"];
            if( !$path){
                return ;
            }
            $htmlPath = $parent_path;
            $html_file_path = $parent_path."/" . $res["path"]["path"] . 'index.html';
            if(!is_file($html_file_path )){
                return; 
            }

            $jsonfile = $parent_path.'/uploads/json/'.$this->getJsonFileName($res["path"]["path"],$res["tl"]);
            if(is_file($jsonfile)){
                $bak = json_decode(file_get_contents($jsonfile),true);
                $baktxt = $bak["texts"];
            }

            if(isset($res["code"]) && $res["code"] == 200){
                $html = file_get_html($html_file_path);
          
                $es = $html->find("text");
                
                $as = $html->find("a");
                if(in_array($res["tl"],["ar"])){
                    $html->find("html",0)->setAttribute("dir","rtl");
                }
                
                $html->find("html",0)->setAttribute("lang",$res["tl"]);
               foreach($es  as $eb){
                  $cz = microtime(true);
                $tag= $eb->parent()->tag;
                
                
               $text = htmlspecialchars_decode(html_entity_decode(trim($eb->text())));
                $tags = ["script","style"];
                if(!in_array($tag,$tags) &&  $text){
                    
                        $description =$html->find("meta[name=description]",0);
                        $keywords = $html->find("meta[name=keywords]",0);
                       // foreach( $res["data"] as $k=>$v){
                           // echo $k."\n";
                         //  var_dump($v);
                            if(isset($res["data"][@$description->content]) && $res["data"][@$description->content]){
                                $html->find("meta[name=description]",0)->content =$res["data"][$description->content];
                            }
                            if(isset($res["data"][@$keywords->content]) && $res["data"][@$keywords->content]){

                                $html->find("meta[name=keywords]",0)->content = $res["data"][$keywords->content];
                            }
                           if(isset($res["data"][$text])){
                               $lanclass = isset($eb->parent()->parent()->find("b",0)->class)?$eb->parent()->parent()->find("b",0)->class:"";
                               if( $lanclass != "country-flag"){
                                   if(isset($baktxt[$text])){
                                    $eb->outertext  = $baktxt[$text];
                                   }else{
                                    $eb->outertext = $res["data"][$text];
                                   }
                               
                               }
                            }
                        //}
                }
            }
            foreach ($as as $a){
                    $href = $a->href;
                    
                    $aclass = $a->class;
                    $flag = isset($a->find("b",0)->class)?$a->find("b",0)->class:"";
                    if(
                        strpos($aclass,"fl-button") !== false ||
                        strpos($aclass,"pdf") !== false ||  
                        strpos($aclass,"cloud-zoom") !== false ||
                        strpos($href,".pdf") !== false ||
                        strpos($href,"/uploads/") === 0 ||
                        $flag == "country-flag"
                        ){
                            continue;
                        
                    }
                   $parseurl =  parse_url($href);
                   if(isset($parseurl["path"])){
                       if($res["path"]["link_type"] == 2){
                           $parseurl["path"] = "/".$res["tl"].$parseurl["path"];
                       }
                    $a->setAttribute("href",$parseurl["path"]);
                    //echo $a->href."\n";
                   }
                    
                }
                
               
                $children = $html->find(".copyright",0)->children();
                foreach ($children as $child){
                   
                    if($child->tag == "a" || $child->tag == "br"){
                        $child->remove();
                    }
                }
                $ctext = $html->find(".copyright",0)->innertext();
               $html->find(".copyright",0)->innertext = str_replace(["-",","],"",$ctext);
            $html_string = $html->save();
            $html->clear();
            
             $html_string = str_replace("</head>",'<link href="//cdn.globalso.com/hide_search.css" rel="stylesheet"/></head>',$html_string);
             if ($res["tl"] === 'zh') {
                $html_string = str_replace('<sup>2</sup>', '', $html_string);
            }
            $html_string = str_replace("background-image: url(/uploads","background-image: url(//$domain/uploads",$html_string);
            $html_string = str_replace("src=\"/uploads","src=\"//$domain/uploads",$html_string);
 
            $file_save_path = $htmlPath."/".$res["tl"].$path;
                 if(!is_dir($file_save_path)){
                    mkdir($file_save_path,0777,true);
                 }

                 // 下载保存文件名
                 $file_save_name = $file_save_path . 'index.html';
                 echo $file_save_name."\n";
                 
                  
                 file_put_contents($file_save_name,$html_string);

            }

            echo (microtime(true) - $start)."\n";
 
        }
        $respath = $parent_path."/trans/result/";
        if(!is_dir($respath)){
            mkdir($respath,0777,true);
        }
        $respath .= "page_".date("Y-m-d").".txt";
        $fp = fopen($respath,"a+");
        fwrite($fp,"$html_file_path ok \n");
        fclose($fp);

    }

}
// $domain ="www.allhosesandfittings.com";
// $token = md5($domain.date("Y-m-d"));
// $url = "https://form.globalso.com/api/external-domain/add/15243d63ed5a5738?domain=$domain&token=".$token;
// echo $token."\n";
// $a = file_get_contents($url);
// var_dump($a);
//fastcgi_finish_request();

//$trans = new Translate();
//$trans->handle($argv[1]);
new Translate();

?>