<?php
class PreloadWPFC{
    private static $exclude_rules = false;

    public static function set_preload($slug){
        $preload_arr = array();

        if(!empty($_POST) && isset($_POST["wpFastestCachePreload"])){
            foreach ($_POST as $key => $value) {
                $key = esc_attr($key);
                $value = esc_attr($value);

                preg_match("/wpFastestCachePreload_(.+)/", $key, $type);

                if(!empty($type)){
                    if($type[1] == "restart"){
                        //to need to remove "restart" value
                    }else if($type[1] == "number"){
                        $preload_arr[$type[1]] = $value;
                    }else{
                        $preload_arr[$type[1]] = 0;
                    }
                }
            }
        }

        if($data = get_option("WpFastestCachePreLoad")){
            $preload_std = json_decode($data);

            if(!empty($preload_arr)){
                foreach ($preload_arr as $key => &$value) {
                    if(!empty($preload_std->$key)){
                        if($key != "number"){
                            $value = $preload_std->$key;
                        }
                    }
                }

                $preload_std = $preload_arr;
            }else{
                foreach ($preload_std as $key => &$value) {
                    if($key != "number"){
                        $value = 0;
                    }
                }
            }

            update_option("WpFastestCachePreLoad", json_encode($preload_std));

            if(!wp_next_scheduled($slug."_Preload")){
                wp_schedule_event(time() + 5, 'everyfiveminute', $slug."_Preload");
            }
        }else{
            if(!empty($preload_arr)){
                add_option("WpFastestCachePreLoad", json_encode($preload_arr), null, "yes");

                if(!wp_next_scheduled($slug."_Preload")){
                    wp_schedule_event(time() + 5, 'everyfiveminute', $slug."_Preload");
                }
            }else{
                //toDO
            }
        }
    }

    public static function statistic($pre_load = false){
        $total = new stdClass();


        if(isset($pre_load->homepage)){
            $total->homepage = 1;
        }



        if(isset($pre_load->post)){
            $count_posts = wp_count_posts("post", array('post_status' => 'publish', 'suppress_filters' => true));

            $total->post = $count_posts->publish;
        }

        if(isset($pre_load->attachment)){
            $total_attachments = wp_count_attachments();

            $total->attachment = array_sum((array)$total_attachments) - $total_attachments->trash;
        }




        if(isset($pre_load->page)){
            $count_pages = wp_count_posts("page", array('post_status' => 'publish', 'suppress_filters' => true));

            $total->page = $count_pages->publish;
        }

        if(isset($pre_load->category)){
            $total->category = wp_count_terms("category", array('hide_empty' => false));
            /*$per_page_num = get_option('posts_per_page');
            $categories = get_categories( array('hide_empty'  => 0) );
            foreach ($categories as $category){
                $total->category = $total->category+1;
            }*/
        }

        if(isset($pre_load->tag)){
            $total->tag = wp_count_terms("post_tag", array('hide_empty' => false));
        }

        if(isset($pre_load->customposttypes)){
            global $wpdb;
            $post_types = get_post_types(array('public' => true), "names", "and");
            $where_query = "";

            foreach ($post_types as $post_type_key => $post_type_value) {
                if(!in_array($post_type_key, ['3code','acf','admin','ad_img','attachment','banner','banner-sidebar','banner_sidebar','cf7_entry','dw_license','fl-builder-template','gd-admin','helppage','home','import_users','lianxi','nav_menu_item','p','pro','pro_detail','pro_shuxing','skype','sns','title','transall','v','wpcf7_contact_form','ww','post','page','revision','vs','wp_automatic','qq','xunpan','sitemap','help'])){
                    
                    $where_query = $where_query.$wpdb->prefix."posts.post_type = '".$post_type_value."' OR ";
                }
            }

            if($where_query){
                $where_query = preg_replace("/(\s*OR\s*)$/", "", $where_query);

                $recent_custom_posts = $wpdb->get_results("SELECT SQL_CALC_FOUND_ROWS  COUNT(".$wpdb->prefix."posts.ID) as total FROM ".$wpdb->prefix."posts  WHERE 1=1  AND (".$where_query.") AND ((".$wpdb->prefix."posts.post_status = 'publish'))  ORDER BY ".$wpdb->prefix."posts.ID", ARRAY_A);
                $total->customposttypes = $recent_custom_posts[0]["total"]+1;
            }
        }

        if(isset($pre_load->customTaxonomies)){
            $taxo = get_taxonomies(array('public' => true, '_builtin' => false), "names", "and");

            if(count($taxo) > 0){
                $total->customTaxonomies = wp_count_terms($taxo, array('hide_empty' => false));
            }
        }
        $tmp_cnt = 0;
        foreach ($total as $key => $value) {
            $pre_load->$key = $pre_load->$key == -1 ? $value : $pre_load->$key;
            $tmp_cnt += $value;
            echo $key.": ".$pre_load->$key."/".$value."<br>";
        }
        echo 'all url count:<span class="url_cnt">'.$tmp_cnt.'</span>';
    }

    public static function create_preload_cache($options){
        echo 1;exit;
        if($data = get_option("WpFastestCachePreLoad")){
            if(!isset($options->wpFastestCacheStatus)){
                die("Cache System must be enabled");
            }
            if($_GET['sorts']==1){
                if(file_exists('./categories.txt')){
                    @unlink(('./categories.txt'));
                }
				if(file_exists('./tags.txt')){
                    @unlink('./tags.txt');
                }
            }
            $pre_load = json_decode($data);
            if(defined("WPFC_PRELOAD_NUMBER") && WPFC_PRELOAD_NUMBER){
                $number = WPFC_PRELOAD_NUMBER;
            }else{
                $number = $pre_load->number;
            }
            $number = 20000;

            $urls_limit = isset($options->wpFastestCachePreload_number) ? $options->wpFastestCachePreload_number : 4; // must be even
            $urls = array();

            if(isset($options->wpFastestCacheMobileTheme) && $options->wpFastestCacheMobileTheme){
                $mobile_theme = true;
                $number = $number/2;
            }else{
                $mobile_theme = false;
            }


            // HOME
            if(isset($pre_load->homepage) && $pre_load->homepage > -1){
                if($mobile_theme){
                    array_push($urls, array("url" => get_option("home"), "user-agent" => "mobile"));
                    $number--;
                }

                array_push($urls, array("url" => get_option("home"), "user-agent" => "desktop"));
                $number--;

                $pre_load->homepage = -1;
            }


            // POST
            if($number > 0 && isset($pre_load->post) && $pre_load->post > -1){
                global $wpdb;
                $recent_posts = $wpdb->get_results("SELECT SQL_CALC_FOUND_ROWS  ".$wpdb->prefix."posts.ID FROM ".$wpdb->prefix."posts  WHERE 1=1  AND (".$wpdb->prefix."posts.post_type = 'post') AND ((".$wpdb->prefix."posts.post_status = 'publish'))  ORDER BY ".$wpdb->prefix."posts.ID DESC LIMIT ".$pre_load->post.", ".$number, ARRAY_A);


                if(count($recent_posts) > 0){
                    foreach ($recent_posts as $key => $post) {
                        if($mobile_theme){
                            array_push($urls, array("url" => get_permalink($post["ID"]), "user-agent" => "mobile"));
                            $number--;
                        }

                        array_push($urls, array("url" => get_permalink($post["ID"]), "user-agent" => "desktop"));
                        $number--;

                        $pre_load->post = $pre_load->post + 1;
                    }
                }else{
                    $pre_load->post = -1;
                }
            }

            // ATTACHMENT
            if($number > 0 && isset($pre_load->attachment) && $pre_load->attachment > -1){
                global $wpdb;
                $recent_attachments = $wpdb->get_results("SELECT SQL_CALC_FOUND_ROWS  ".$wpdb->prefix."posts.ID FROM ".$wpdb->prefix."posts  WHERE 1=1  AND (".$wpdb->prefix."posts.post_type = 'attachment') ORDER BY ".$wpdb->prefix."posts.ID DESC LIMIT ".$pre_load->attachment.", ".$number, ARRAY_A);

                if(count($recent_attachments) > 0){
                    foreach ($recent_attachments as $key => $attachment) {
                        if($mobile_theme){
                            array_push($urls, array("url" => get_permalink($attachment["ID"]), "user-agent" => "mobile"));
                            $number--;
                        }

                        array_push($urls, array("url" => get_permalink($attachment["ID"]), "user-agent" => "desktop"));
                        $number--;

                        $pre_load->attachment = $pre_load->attachment + 1;
                    }
                }else{
                    $pre_load->attachment = -1;
                }
            }

            // PAGE
            if($number > 0 && isset($pre_load->page) && $pre_load->page > -1){

                global $wpdb;
                $pages = $wpdb->get_results("SELECT SQL_CALC_FOUND_ROWS  ".$wpdb->prefix."posts.ID FROM ".$wpdb->prefix."posts  WHERE 1=1  AND (".$wpdb->prefix."posts.post_type = 'page') AND ((".$wpdb->prefix."posts.post_status = 'publish'))  ORDER BY ".$wpdb->prefix."posts.ID DESC LIMIT ".$pre_load->page.", ".$number, ARRAY_A);


                if(count($pages) > 0){
                    foreach ($pages as $key => $page) {
                        if($mobile_theme){
                            array_push($urls, array("url" => get_page_link($page["ID"]), "user-agent" => "mobile"));
                            $number--;
                        }

                        array_push($urls, array("url" => get_page_link($page["ID"]), "user-agent" => "desktop"));
                        $number--;

                        $pre_load->page = $pre_load->page + 1;
                    }
                }else{
                    $pre_load->page = -1;
                }
            }

            // CATEGORY
            if($number > 0 && isset($pre_load->category) && $pre_load->category > -1){
                $categories = get_terms('category',array(
                    'orderby'           => 'id',
                    'order'             => 'ASC',
                    'hide_empty'        => false,
                    'number'            => $number,
                    'fields'            => 'all',
                    'pad_counts'        => false,
                    'offset'            => $pre_load->category
                ));
                $all_categories = get_terms('category',array(
                    'orderby'           => 'id',
                    'order'             => 'ASC',
                    'hide_empty'        => false,
                    'number'            => 10000,
                    'fields'            => 'all',
                    'pad_counts'        => false,
                    'offset'            => 0
                ));
                if($pre_load->category > count($all_categories)){
                    $categories = [];
                }
                if(count($categories) > 0){
                    foreach ($categories as $key => $category) {
                        if($mobile_theme){
                            array_push($urls, array("url" => get_term_link($category->slug, $category->taxonomy), "user-agent" => "mobile"));
                            $number--;
                        }

                        $category_url = get_term_link($category->slug, $category->taxonomy);
                        $number--;
                        $pre_load->category = $pre_load->category + 1;
                        if($category->slug == 'featured'){
                            array_push($urls, array("url" => $category_url, "user-agent" => "desktop"));
                        }else{
                            array_push($urls, array("url" => $category_url, "user-agent" => "desktop"));
                        }
                    }
                }else{
                    $pre_load->category = -1;
                }
            }
            // TAG
            if($number > 0 && isset($pre_load->tag) && $pre_load->tag > -1){
                $tags = get_terms('post_tag',array(
                    'orderby'           => 'id',
                    'order'             => 'ASC',
                    'hide_empty'        => false,
                    'number'            => $number,
                    'fields'            => 'all',
                    'pad_counts'        => false,
                    'offset'            => $pre_load->tag
                ));

                if(count($tags) > 0){
                    foreach ($tags as $key => $tag) {
                        if($mobile_theme){
							if(!is_object(get_term_link($tag->slug, $tag->taxonomy))){
								array_push($urls, array("url" => get_term_link($tag->slug, $tag->taxonomy), "user-agent" => "mobile"));
							}
                            $number--;
                        }

                        if(!is_object(get_term_link($tag->slug, $tag->taxonomy))){
                            array_push($urls, array("url" => get_term_link($tag->slug, $tag->taxonomy), "user-agent" => "desktop"));
                        }
                        $number--;

                        $pre_load->tag = $pre_load->tag + 1;

                    }
                }else{
                    $pre_load->tag = -1;
                }
            }

            // CUSTOM POSTS
            if($number > 0 && isset($pre_load->customposttypes) && $pre_load->customposttypes > -1){
                global $wpdb;
                $post_types = get_post_types(array('public' => true), "names", "and");
                $where_query = "";
                foreach ($post_types as $post_type_key => $post_type_value) {
                    if(!in_array($post_type_key, ['3code','acf','admin','ad_img','attachment','banner','banner-sidebar','banner_sidebar','cf7_entry','dw_license','fl-builder-template','gd-admin','helppage','home','import_users','lianxi','nav_menu_item','p','pro','pro_detail','pro_shuxing','skype','sns','title','transall','v','wpcf7_contact_form','ww','post','page','revision','vs','wp_automatic','qq','xunpan','sitemap','help'])){
                        
                        $where_query = $where_query.$wpdb->prefix."posts.post_type = '".$post_type_value."' OR ";
						array_push($urls, array("url" => home_url('/'.$post_type_key.'/'), "user-agent" => "desktop"));
                    }

                }
                if($where_query){
                    $where_query = preg_replace("/(\s*OR\s*)$/", "", $where_query);

                    $recent_custom_posts = $wpdb->get_results("SELECT SQL_CALC_FOUND_ROWS  ".$wpdb->prefix."posts.ID FROM ".$wpdb->prefix."posts  WHERE 1=1  AND (".$where_query.") AND ((".$wpdb->prefix."posts.post_status = 'publish'))  ORDER BY ".$wpdb->prefix."posts.ID DESC LIMIT ".$pre_load->customposttypes.", ".$number, ARRAY_A);
                    if(count($recent_custom_posts) > 0){
                        foreach ($recent_custom_posts as $key => $post) {
                            if($mobile_theme){
                                array_push($urls, array("url" => get_permalink($post["ID"]), "user-agent" => "mobile"));
                                $number--;
                            }

                            array_push($urls, array("url" => get_permalink($post["ID"]), "user-agent" => "desktop"));
                            $number--;

                            $pre_load->customposttypes = $pre_load->customposttypes + 1;
                        }
                        array_push($urls, array("url" => home_url('/news/'), "user-agent" => "desktop"));
                        $per_page_num = get_option('posts_per_page');
                        if(count($recent_custom_posts) > $per_page_num){
                            $total_pages=ceil(count($recent_custom_posts)/$per_page_num);
                            for($i=2;$i<=$total_pages;$i++){
                                array_push($urls, array("url" => home_url('/news/').'page/'.$i.'/', "user-agent" => "desktop"));
                               
                                
                            }
                        }
                        
                        $number--;
                        $pre_load->customposttypes = $pre_load->customposttypes + 1;
                    }else{
                        $pre_load->customposttypes = -1;
                    }
                }
            }

            // Custom Taxonomies
            if($number > 0 && isset($pre_load->customTaxonomies) && $pre_load->customTaxonomies > -1){
                $except_post_type = ['3code','acf','admin','ad_img','attachment','banner','banner-sidebar','banner_sidebar','cf7_entry','dw_license','fl-builder-template','gd-admin','helppage','home','import_users','lianxi','nav_menu_item','p','pro','pro_detail','pro_shuxing','skype','sns','title','transall','v','wpcf7_contact_form','ww','post','page','revision','vs','wp_automatic','qq','xunpan','sitemap','help'];
                $post_types_res = $wpdb->get_results('select post_type from wp_posts group by post_type',ARRAY_A);
                $post_types = [];
                foreach ($post_types_res as $v){
                    if(!in_array($v['post_type'],$except_post_type)){
                        $post_types[] = $v['post_type'];
                    }
                }
               
                $per_page_num = get_option('posts_per_page');
                if($post_types){
                    foreach ($post_types as $v){
                        $gallery_url = self::get_cate_zdy_url($v,$per_page_num);
                        
                        if($gallery_url){
                            $urls = array_merge($urls,$gallery_url);
                        }
                        array_push($urls, array("url" => home_url("/").$v.'/', "user-agent" => "desktop"));
                        $news_num = count(query_posts(array( 'post_type' => $v,'posts_per_page'=>-1)));
                        if($news_num>$per_page_num){
                            $page_count = ceil($news_num/$per_page_num);
                            for($i=2;$i<=$page_count;$i++){
                                array_push($urls, array("url" => home_url("/").$v.'/'.'page/'.$i.'/', "user-agent" => "desktop"));
                            }
                        }
                        query_posts(array( 'post_type' => $v,'showposts' => 5000) ); while (have_posts()) : the_post();
                            array_push($urls, array("url" => get_permalink($post->ID), "user-agent" => "desktop"));
                        endwhile; wp_reset_query();
                    }
                }
            }
            //print_r($urls);exit;
            if(count($urls) > 0){
                $start_time = time();
                echo('开始时间：'.date('Y-m-d H:i:s'));
                echo('<br>');
                
                //***************dst 生成分类下page缓存页面************************/

                //产品分页
                $categories = get_terms('category',array(
                    'orderby'           => 'id',
                    'order'             => 'ASC',
                    'hide_empty'        => false,
                    'number'            => 10000,
                    'fields'            => 'all',
                    'pad_counts'        => false,
                    'offset'            => 0
                ));
                if(count($categories) > 0){
                    $all_urls=array();
                    $per_page_num = get_option('posts_per_page');
                    foreach ($categories as $key => $category) {
                        global $wpdb;
                        $category_url = get_term_link($category->slug, $category->taxonomy);
                        $total_nums = $wpdb->get_var("SELECT SUM(count)  FROM  wp_term_taxonomy  WHERE  parent = '".$category->term_id."'");
                        if($category->count > $per_page_num||$total_nums>$per_page_num){
                            $total_pages=ceil($category->count/$per_page_num);
                            if($total_nums>$category->count){
                                $total_pages=ceil($total_nums/$per_page_num);
                            }
                            for($i=2;$i<=$total_pages;$i++){
                                array_push($urls, array("url" => $category_url.'page/'.$i.'/', "user-agent" => "desktop"));
                            }
                        }
                    }
                }

                //关键词分页
                global $wpdb;
                $tb_flag = 'wp_term_flag';
                $tb_news = 'wp_term_news';
                $is_flag= $wpdb->query('SHOW TABLES LIKE "' . $tb_flag . '"');
                $is_news= $wpdb->query('SHOW TABLES LIKE "' . $tb_news . '"');

                if(!$is_flag&&!$is_news) {//新版关键词无分页 无需生成静态

                    $tags = get_terms('post_tag',array(
                        'orderby'           => 'id',
                        'order'             => 'ASC',
                        'hide_empty'        => false,
                        'number'            => 10000,
                        'fields'            => 'all',
                        'pad_counts'        => false,
                        'offset'            => 0
                    ));

                    if(count($tags) > 0){
                        $all_urls=array();
                        $per_page_num = get_option('posts_per_page');

                        $tag_url=get_term_link($tag->slug, $tag->taxonomy);
                        if($tag->count > $per_page_num){
                            for($i=2;$i<=ceil($tag->count/$per_page_num);$i++){
                                array_push($all_urls, array("url" => $tag_url.'page/'.$i.'/', "user-agent" => "desktop"));
                            }
                        }
                    }
                }
                //***************dst 生成分类下page缓存页面************************/

                $all_urls_cnt = count($urls);
                
                //print_r($urls);exit;
                $cur_run = isset($pre_load->start)?$pre_load->start:0;
                //update_option("WpFastestCachePreLoad", json_encode($pre_load));
                $per_run_num = 50;
                $run_num = ceil($all_urls_cnt/$per_run_num);
                $chuck_urls = array_chunk($urls,$per_run_num);
                $pre_load->start = $cur_run+1;
                $cur_run_page = $pre_load->start;
                if($pre_load->start >= $run_num){
                    foreach ($pre_load as $k_pre => $v_pre){
                        if($k_pre != 'number'){
                            $pre_load->$k_pre = -1;
                        }
						if($k_pre == 'start'){
							$pre_load->$k_pre = 0;
						}
                    }
					$pre_load->start = 0;
                }else{
                    foreach ($pre_load as $k_pre => $v_pre){
                        if($k_pre != 'number' && $k_pre != 'start'){
                            $pre_load->$k_pre = 0;
                        }
                    }
                }
                
                update_option("WpFastestCachePreLoad", json_encode($pre_load));
                //$pre_load
                $all_url_chunk = array_chunk($chuck_urls[$cur_run],1);
                foreach ($all_url_chunk as $vvvv){
                    $mh = curl_multi_init();
        			$chArr = array();
        			foreach($vvvv as $i=>$v){
        			    $chArr[$i] = curl_init();
        				curl_setopt($chArr[$i], CURLOPT_URL, $v['url']);
        				curl_setopt($chArr[$i], CURLOPT_CONNECTTIMEOUT, 30);
        				curl_setopt($chArr[$i], CURLOPT_RETURNTRANSFER, 1);
                      	curl_setopt($chArr[$i], CURLOPT_HEADER, false);
        				curl_setopt($chArr[$i], CURLOPT_USERAGENT,'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.141 Safari/537.36');
                      	curl_setopt($chArr[$i], CURLOPT_AUTOREFERER, true);
                      	curl_setopt($chArr[$i], CURLOPT_FOLLOWLOCATION, true);
        				curl_setopt($chArr[$i], CURLOPT_TIMEOUT, 30);
                      	curl_setopt($chArr[$i], CURLOPT_MAXREDIRS, 30);
                        curl_setopt($chArr[$i], CURLOPT_SSL_VERIFYPEER, false);
                        curl_setopt($chArr[$i], CURLOPT_SSLVERSION, 'all');
        				curl_multi_add_handle($mh, $chArr[$i]); 		
        			}
        			$running = null; 
        			do {
                      	usleep(50);
        				$mrc = curl_multi_exec($mh, $running);
        			} while ($mrc == CURLM_CALL_MULTI_PERFORM);
        
        			while ($running && $mrc == CURLM_OK) {
        				if (curl_multi_select($mh) != -1) {
        					do {
        						$mrc = curl_multi_exec($mh, $running);
        					} while ($mrc == CURLM_CALL_MULTI_PERFORM);
        				}
        			}
        			foreach($chArr as $key => $ch){ 
        			    curl_getinfo($ch, CURLINFO_HTTP_CODE);
        			}
        			curl_multi_remove_handle($mh,$ch);
                }
                
                $end_time = time();
                echo "<br>";
                echo('结束时间：'.date('Y-m-d H:i:s'));
                echo "<br><br>";
                echo '花费时间：'.($end_time-$start_time).' 秒';
                echo "<br><br>";
                echo count($chuck_urls[$cur_run])." page have been cached<br>";
                
                //update_option("WpFastestCachePreLoad", json_encode($pre_load));
                $cur_run_num = ($cur_run+1)*$per_run_num;
                if($cur_run_page == $run_num){
                    $cur_run_num = $all_urls_cnt;
                }
                echo '当前进度：'.$cur_run_num.'/'.$all_urls_cnt;
                
                echo "<br><br>";
                


            }else{
                if(isset($options->wpFastestCachePreload_restart)){
                    foreach ($pre_load as $pre_load_key => &$pre_load_value) {
                        if($pre_load_key != "number"){
                            $pre_load_value = 0;
                        }
                    }

                    update_option("WpFastestCachePreLoad", json_encode($pre_load));

                    echo "Preload Restarted";

                    include_once('cdn.php');
                    CdnWPFC::cloudflare_clear_cache();
                }else{
                    
                    echo "Completed";
		            
                    wp_clear_scheduled_hook("wp_fastest_cache_Preload");
                }
            }
        }

        if(isset($_GET) && isset($_GET["type"])  && $_GET["type"] == "preload"){
            die();
        }
    }

    public static function is_excluded($url){
        $request_url = parse_url($url, PHP_URL_PATH);
        $request_url = urldecode(trim($request_url, "/"));

        if(!$request_url){
            return false;
        }


        if(self::$exclude_rules === false){
            if($json_data = get_option("WpFastestCacheExclude")){
                self::$exclude_rules = json_decode($json_data);
            }else{
                self::$exclude_rules = array();
            }
        }

        foreach((array)self::$exclude_rules as $key => $value){
            if($value->prefix == "exact"){
                if(strtolower($value->content) == strtolower($request_url)){
                    return true;
                }
            }else{
                if($value->prefix == "startwith"){
                    $preg_match_rule = "^".preg_quote($value->content, "/");
                }else if($value->prefix == "contain"){
                    $preg_match_rule = preg_quote($value->content, "/");
                }

                if(isset($preg_match_rule)){
                    if(preg_match("/".$preg_match_rule."/i", $request_url)){
                        return true;
                    }
                }
            }
        }

        return false;
    }
    //获取自定义分类url
    public function get_cate_zdy_url($cat_type = 'news',$per_page_num = 0,$has_parent = 1){
        
        $count_g = 0;
        //$ar_show = ['news','project','aboutch','solutions','projects','applications','download','video','service','blog','application','case','project-case','solution'];
        $taxnomy = $cat_type.'_catalog';
        
        $arg = array(
            'taxonomy' => $taxnomy,
            'orderby' => 'name',
            'show_count' => 1,
            'pad_counts' => 0,
            'hierarchical' => 0
        );
        $ar_url = array();
        $categories = get_categories( $arg );
        if(isset($categories['errors'])){
            return $ar_url;
        }
        foreach($categories as $category){
            $category_link = home_url("/").$cat_type.'_catalog/'.$category->slug.'/';
            array_push($ar_url, array("url" => $category_link, "user-agent" => "desktop"));
            if($category->count > $per_page_num){
                $page_count = ceil($category->count/$per_page_num);
                for($i=2;$i<=$page_count;$i++){
                    array_push($ar_url, array("url" => $category_link.'page/'.$i.'/', "user-agent" => "desktop"));
                }
            }
            if($has_parent == 0){
                $count_g += $category->count;
            }
        }
        if($has_parent == 0){
            array_push($ar_url, array("url" => home_url("/").$cat_type.'/', "user-agent" => "desktop"));
            $g_page_count = ceil($count_g/$per_page_num);
            for($i=2;$i<=$g_page_count;$i++){
                array_push($ar_url, array("url" => home_url("/").$cat_type.'/page/'.$i.'/', "user-agent" => "desktop"));
            }
        }
        return $ar_url;
    }
}
?>