


function getMonthfirstDay(iDate){  
    var dateArr=iDate.split('-');
     return iDate+'-'+1;  
}

// 当月最后一天
function getMonthLastDay(iDate){  
    var dateArr=iDate.split('-');
    var year =dateArr[0];
    var month=dateArr[1];
    var d= new Date(year, month, 0); 
    return iDate+''+d.getDate();  
}





$(function () {
	var months = $('#month_str').val();
    var month_arr = months.split(',');
	$.each(month_arr, function(k,item_month){
		$.get("/wp-admin/admin-ajax.php", { "action": "stats_data_uvhz", month :item_month},
		   function(data){
			   $('.moth_'+item_month+'_moth').html(data.moth_moth);	   
			   $('#moth_'+item_month+'_pv').html(data.moth_pv);
			   $('#moth_'+item_month+'_ip').html(data.moth_ip);
			   $('#cf_count_'+item_month).html(data.cf_count);
			   $('#cf_f_count_'+item_month).html(data.cf_f_count);
			   
			   var country_top10_html = '';
			   $.each(data.country_top10, function(i,item){
					country_top10_html +="<li>"+item['show_area']+"</li>"
				});
			   $('#country_top10_'+item_month).html(country_top10_html);
			   var data_pv = new Array();
			   var data_ip = new Array();
			   var k=0;
			   $.each(data.moth['data'], function(i,item){
					data_pv[k] = parseInt(item.pv);
					data_ip[k] = parseInt(item.ip);
					k++;
				});

				// 各月份数据
				Highcharts.chart('view-chart-'+item_month,
					{


					xAxis: {
						type: 'datetime',
						dateTimeLabelFormats: {
							day: '%m-%d'
						},
						tickWidth:0,
						lineWidth: 0,
						labels:{
							style:{
								color:'#999'
							}
						}
					},
					tooltip: {
						useHTML: true,
                        formatter : function() {
                                var d = new Date(this.x);
                                var content = '<div style="background:#fff;overflow:hidden;padding:10px; border:1px solid #ddd;font-size:10px;"><span >' + d.getFullYear() + '年' + (d.getMonth() + 1) + '月' + d.getDate() + '日' + '</span><div >';
                                for (var i = 0; i < this.points.length; i++) {
                                    content += '<p class="chartToolIco" style="color:#4d79f6;padding:0;margin:0;"><span class="chartToolIco01" style="color:#ECECEC;padding-right:3px;">\u25CF</span> <span style="color:#666">'+this.points[i].series.name+'：</span><b style="color:#333">'+this.points[i].y+'</b></p>';
                                };
                                content+='</div></div>';
                                return content;
                            },
                        shared: true,
                        shadow: false,
                        crosshairs: true,
                        borderColor: 'transparent',
                        backgroundColor: 'none'
			   		},
					colors: ['#ececec','#7cb0d8'],
					chart:{type:'areaspline'},
					plotOptions: {
						series: {
			            	lineWidth:1,
			                marker: {
			                    enabled: true
			                },

							// pointStart: 1, // 开始时间
							// pointEnd: 31, // 结束时间
							// pointInterval: 1

							pointStart: Date.parse(getMonthfirstDay(item_month)), // 开始时间
							pointEnd: Date.parse(getMonthLastDay(item_month)), // 结束时间
							pointInterval: 24 * 3600 * 1000

						}
					},
					series:[
						{
							name:'访客次数(PV)',lineColor:'#aaaaaa',marker: {symbol: 'circle',lineWidth: 1,lineColor: '#ffffff',fillColor: '#cccccc'},
							data:eval(data_pv) // PV数据
						},
						{
							name:'独立访客(IP)',lineColor:'#3292e0',marker: {symbol: 'circle',lineWidth: 1,lineColor: '#ffffff',fillColor: '#3292e0'},
							data:eval(data_ip) // UV数据
						}
						]
				});
		}, "json");
	})
});
