$(function() {
    $.get("/wp-admin/admin-ajax.php", {
        "action": "stats_data"
    },
    function(data) {
        $('#today_pv').html(data.today_pv);
        $('#today_ip').html(data.today_ip);
        $('#total_ip').html(data.total_ip);
        $('#total_pv').html(data.total_pv);
        $('#total_ip').html(data.total_ip);
        $('#total_cf_f').html(data.total_cf_f);
        $(window.parent.document).find(".side-menu-label").html(data.total_cf_noread);
        $(window.parent.document).find(".msg-txt").find("p").html("您有" + data.total_cf_noread + "封询盘未查看，询盘信息已经发送到您的收件邮箱。");
        var ip_list = '';
        for (var i = 0; i < data.ip_view_list.length; i++) {
            var cf = '';
			var user = '老用户';
			if (parseInt(data.ip_view_list[i]['is_old_user']) == 1){
				user = '新用户';
			}
			var is_moblie = 'PC';
			if (parseInt(data.ip_view_list[i]['is_moblie']) == 1){
				is_moblie = '移动端';
			}
            if (parseInt(data.ip_view_list[i]['is_cf']) == 1) {
                cf = '<i class="sm-ico-tick-grey"></i>'
            }
            ip_list += '<tr><td data-label="浏览时间"><div class="tb-txt">' + data.ip_view_list[i]['update'] + '</div></td><td data-label="访客来源"><div class="tb-txt"><a href="' + data.ip_view_list[i]['referrer'] + '" target="_blank">' + data.ip_view_list[i]['referrer'] + '</a></div></td><td data-label="访问入路页面"><div class="tb-txt"><a href="' + data.ip_view_list[i]['request'] + '" target="_blank">' + data.ip_view_list[i]['request'] + '</a></div></td><td data-label="终端"><div class="tb-txt">' + is_moblie + '</div></td><td data-label="访客IP"><div class="tb-txt">' + data.ip_view_list[i]['ip'] + '</div></td><td data-label="地区"><div class="tb-txt">' + data.ip_view_list[i]['ip_area'] + '</div></td><td data-label="访客深度(页)"><div class="tb-txt">' + data.ip_view_list[i]['pv'] + '页</div></td><td data-label="询盘转化" class="align-center"><div class="tb-txt">' + cf + '</div></td><td data-label="访问详情" class="align-center"><div class="tb-txt"><a class="btn-view-detail" href="javascript:" onclick="show_detail(\'' + data.ip_view_list[i]['id'] + '\',\'' + data.ip_view_list[i]['ip'] + '\')">详情</a></div></td></tr>'
        }
        $('#ip_list').html(ip_list);
        Highcharts.setOptions({
            colors: ['#ececec', '#7cb0d8']
        });
        Highcharts.chart('week-count-chart', {
            xAxis: {
                type: 'datetime',
                dateTimeLabelFormats: {
                    day: '%m月%d日'
                }
            },
            chart: {
                type: 'areaspline'
            },
            title: false,
            yAxis: {
                startOnTick: false,
                title: false,
                gridLineColor: '#ffffff'
            },
            tooltip: {
                shared: true,
                shadow: false,
                backgroundColor: '#ffffff',
                style: {
                    color: '#666666',
                    fontSize: '12px',
                    padding: '8px'
                }
            },
            legend: {
                itemStyle: {
                    color: '#999999',
                    fontWeight: 'normal'
                },
                itemHoverStyle: {
                    color: '#666666'
                },
                symbolHeight: 10,
                symboWidth: 10,
                symbolRadius: 5
            },
            credits: {
                enabled: false
            },
            plotOptions: {
                series: {
                    lineWidth: 1,
                    pointStart: Date.UTC(data.last7days_start_y, parseInt(data.last7days_start_m) - 1, data.last7days_start_d),
                    pointEnd: Date.UTC(data.last7days_end_y, parseInt(data.last7days_end_m) - 1, data.last7days_end_d),
                    pointInterval: 24 * 3600 * 1000
                }
            },
            series: [{
                name: '访客次数(PV)',
                lineColor: '#aaaaaa',
                marker: {
                    symbol: 'circle',
                    lineWidth: 1,
                    lineColor: '#ffffff',
                    fillColor: '#cccccc'
                },
                data: [parseInt(data.last7days_pv[0]), parseInt(data.last7days_pv[1]), parseInt(data.last7days_pv[2]), parseInt(data.last7days_pv[3]), parseInt(data.last7days_pv[4]), parseInt(data.last7days_pv[5]), parseInt(data.last7days_pv[6])]
            },
            {
                name: '独立访客(IP)',
                lineColor: '#3292e0',
                marker: {
                    symbol: 'circle',
                    lineWidth: 1,
                    lineColor: '#ffffff',
                    fillColor: '#3292e0'
                },
                data: [parseInt(data.last7days_ip[0]), parseInt(data.last7days_ip[1]), parseInt(data.last7days_ip[2]), parseInt(data.last7days_ip[3]), parseInt(data.last7days_ip[4]), parseInt(data.last7days_ip[5]), parseInt(data.last7days_ip[6])]
            }]
        });
        Highcharts.setOptions({
            colors: ['#3292e0', '#dedede']
        });
        Highcharts.chart('state-count-chart', {
            chart: {
                type: 'column'
            },
            title: false,
            subtitle: false,
            legend: {
                itemStyle: {
                    color: '#999999',
                    fontWeight: 'normal'
                },
                itemHoverStyle: {
                    color: '#666666'
                },
                symbolHeight: 10,
                symboWidth: 10,
                symbolRadius: 5
            },
            xAxis: {
                startOnTick: false,
                categories: [data.country_top10_country[0], data.country_top10_country[1], data.country_top10_country[2], data.country_top10_country[3], data.country_top10_country[4], data.country_top10_country[5], data.country_top10_country[6], data.country_top10_country[7], data.country_top10_country[8], data.country_top10_country[9]],
                title: {
                    text: null
                },
                gridLineColor: '#ffffff',
                lineWidth: 0,
                tickWidth: 0
            },
            yAxis: {
                min: 0,
                title: false,
                gridLineColor: '#ffffff',
                labels: {
                    overflow: 'justify'
                }
            },
            plotOptions: {
                series: {
                    states: {
                        hover: {
                            brightness: -0.06
                        }
                    }
                }
            },
            credits: {
                enabled: false
            },
            series: [{
                name: 'IP',
                data: [parseInt(data.country_top10_ip[0]), parseInt(data.country_top10_ip[1]), parseInt(data.country_top10_ip[2]), parseInt(data.country_top10_ip[3]), parseInt(data.country_top10_ip[4]), parseInt(data.country_top10_ip[5]), parseInt(data.country_top10_ip[6]), parseInt(data.country_top10_ip[7]), parseInt(data.country_top10_ip[8]), parseInt(data.country_top10_ip[9])]
            },
            {
                name: 'PV',
                data: [parseInt(data.country_top10_pv[0]), parseInt(data.country_top10_pv[1]), parseInt(data.country_top10_pv[2]), parseInt(data.country_top10_pv[3]), parseInt(data.country_top10_pv[4]), parseInt(data.country_top10_pv[5]), parseInt(data.country_top10_pv[6]), parseInt(data.country_top10_pv[7]), parseInt(data.country_top10_pv[8]), parseInt(data.country_top10_pv[9])]
            }]
        })
    },
    "json")
});
function show_detail(id, ip) {
    $('#pop_ip').html('');
    $('#pop_pv_list').html('');
    var html = '';
    $.get("/wp-admin/admin-ajax.php", {
        "action": "stats_get_ip_detail",
        id: id
    },
    function(data) {
        $.each(data,
        function(i, item) {
            html += '<dl><dt>' + item.time_str + '</dt><dd><a target="_blank" href="' + item.request + '">' + item.request + '</a></dd></dl>'
        });
        $('#pop_pv_list').html(html)
    },
    "json");
    $('#pop_ip').html(ip);
    popShow('.pop-page-view')
}