<?php
/**
 * Plugin Name: Easy stats
 * Plugin URI: http://www.goodao.cn/
 * Description: Easy stats
 * Version: 1.1.00
 * Author: GD-Shop
 * Author URI: http://www.goodao.cn/
 */
error_reporting(0);

ignore_user_abort(true);
date_default_timezone_set('PRC');
define ( 'Easyiit_Stats_FILE', __FILE__);
define ( 'Easyiit_Stats_DIR', rtrim ( plugin_dir_path ( Easyiit_Stats_FILE ), '/' ) );
define ( 'Easyiit_Stats_URL', rtrim ( plugin_dir_url ( Easyiit_Stats_FILE ), '/' ) );
define ( 'Easyiit_Stats_VERSION', '1.1' );
define ( 'Easyiit_Stats_DB_VERSION', '1.1' );

register_activation_hook(__FILE__, 'easyiit_stats_install');

function easyiit_stats_install() {
    global $wpdb;
    $charset_collate = '';
    if (!empty($wpdb->charset)) {
        $charset_collate = "DEFAULT CHARACTER SET {$wpdb->charset}";
    }

    if (!empty( $wpdb->collate)) {
        $charset_collate .= " COLLATE {$wpdb->collate}";
    }
  require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
  
  $table_name = $wpdb->prefix . "stats_day_ip";
  if($wpdb->get_var("show tables like '$table_name'") != $table_name) {
      $sql = "CREATE TABLE `".$table_name."` (
				  `id` bigint(20) NOT NULL AUTO_INCREMENT,
				  `day` date DEFAULT NULL,
				  `ip` varchar(50) DEFAULT NULL,
				  `ip_area` varchar(30) DEFAULT NULL,
				  `pv` int(10) DEFAULT NULL,
				  `uv` int(10) DEFAULT NULL,
				  `update` int(10) DEFAULT NULL,
				  `tableid` int(5) DEFAULT NULL,
				  `request` text,
				  `referrer` text,
				  `is_cf` tinyint(1) DEFAULT '0',
				  `is_spider` tinyint(1) DEFAULT '0',
				  `is_moblie` tinyint(1) DEFAULT '0',
				  `is_old_user` tinyint(1) DEFAULT '0',
				  PRIMARY KEY (`id`)
				) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;";	 
     dbDelta($sql);
  }

  $table_name = $wpdb->prefix . "stats_day_data";
  if($wpdb->get_var("show tables like '$table_name'") != $table_name) {
      $sql = "CREATE TABLE `".$table_name."` (
				  `id` bigint(20) NOT NULL AUTO_INCREMENT,
				  `siteid` int(5) DEFAULT NULL,
				  `day_at` date DEFAULT NULL,
				  `year` mediumint(9) DEFAULT NULL,
				  `moth` tinyint(4) DEFAULT NULL,
				  `day` tinyint(4) DEFAULT NULL,
				  `ip` varchar(50) DEFAULT NULL,
				  `ip_area` varchar(50) DEFAULT NULL,
				  `time` int(10) DEFAULT NULL,
				  `time_str` datetime DEFAULT NULL,
				  `remote_host` text,
				  `request` text,
				  `referrer` text,
				  `user_agent` text,
				  PRIMARY KEY (`id`)
				) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8";	 
     dbDelta($sql);
  }

  $table_name = $wpdb->prefix . "stats_day_count";
  if($wpdb->get_var("show tables like '$table_name'") != $table_name) {
      $sql = "CREATE TABLE `".$table_name."` (
				  `day` date DEFAULT NULL,
				  `ip` int(10) DEFAULT NULL,
				  `pv` int(10) DEFAULT NULL,
				  `uv` int(10) DEFAULT NULL,
				  `updatetime` int(10) DEFAULT NULL
				) ENGINE=MyISAM DEFAULT CHARSET=utf8";	 
     dbDelta($sql);
  }

  $table_name = $wpdb->prefix . "stats_moth_count";
  if($wpdb->get_var("show tables like '$table_name'") != $table_name) {
      $sql = "CREATE TABLE `".$table_name."` (
				  `year` int(3) DEFAULT NULL,
				  `moth` tinyint(3) DEFAULT NULL,
				  `ip` int(10) DEFAULT NULL,
				  `pv` int(10) DEFAULT NULL,
				  `uv` int(10) DEFAULT NULL,
				  `updatetime` int(10) DEFAULT NULL
				) ENGINE=MyISAM DEFAULT CHARSET=utf8";	 
     dbDelta($sql);
  }
  $table_name = $wpdb->prefix . "stats_year_count";
  if($wpdb->get_var("show tables like '$table_name'") != $table_name) {
      $sql = "CREATE TABLE `".$table_name."` (
				  `year` mediumint(5) DEFAULT NULL,
				  `ip` int(10) DEFAULT NULL,
				  `pv` int(10) DEFAULT NULL,
				  `uv` int(10) DEFAULT NULL,
				  `updatetime` int(10) DEFAULT NULL
				) ENGINE=MyISAM DEFAULT CHARSET=utf8";	 
     dbDelta($sql);
  }
  update_option( "stats_db_version", $stats_db_version );
}

// 插件停用时，运行回调方法删除数据表，删除options表中的插件版本号
register_deactivation_hook(__FILE__, 'easyiit_stats_uninstall');
function easyiit_stats_uninstall() {

}

include_once(Easyiit_Stats_DIR."/function/function.php");
add_action('admin_menu', 'stats_settings');
function stats_settings() {
    add_menu_page('统计系统', '统计系统', 7, 'stats_settings');
	add_submenu_page('stats_settings', '设置', '设置', 7, 'stats_settings', 'settings');
}

function settings() {
	global $wpdb;
	include_once(Easyiit_Stats_DIR."/class/easyiit_stats.class.php");	
	$easy_stats = new easyiit_stats;		
	if(isset($_POST['reset_stats_data'])&&$_POST['reset_stats_data']){
        $easy_stats->reset_stats();
		$info = "清空数据成功。";
		echo stats_show_message($info);
	}
    $stats_setting = get_option('stats_settings');
    $month_start = explode("-",$stats_setting['month_start']); 
    
	if(isset($_POST['save_settings'])&&$_POST['save_settings']){        
        $data['start_day_num']=$_POST['start_day_num'];
	    $data['month_start'] = $_POST['m_start_year'].'-'.$_POST['m_start_month'];
	    update_option('stats_settings',$data);
	    $info = "保存成功。";
	    echo stats_show_message($info);
	    $stats_setting = get_option('stats_settings');
        $month_start = explode("-",$stats_setting['month_start']); 
	}
	
?>
<h3>操作</h3>
<form method="post" action="" onsubmit='if(!confirm("确认清空所有统计数据吗")){return false;}'>
	<input type="submit" name="reset_stats_data" value="清空所有统计数据">
	<p style="color:red">此功能将重置数据库，清空所有统计数据！</p>
</form>
<h3>设置</h3>
<p>
<form method="post" action="">
<p><label>保留数据天数：</label><input type="text" name="start_day_num" value='<?php echo $stats_setting['start_day_num'];?>'></p>
<p><label>月度统计起始月份：</label>
<select name="m_start_year">
    <?php for($y=2016;$y<2030;$y++){?>
        <option value="<?php echo $y?>" <?php if ($y==$month_start[0]) echo 'selected';?>><?php echo $y?></option>
	<?php }?>
</select>
<select name="m_start_month">
    <option value="01" <?php if ('01'==$month_start[1]) echo 'selected';?>>01</option>
	<option value="02" <?php if ('02'==$month_start[1]) echo 'selected';?>>02</option>
	<option value="03" <?php if ('03'==$month_start[1]) echo 'selected';?>>03</option>
	<option value="04" <?php if ('04'==$month_start[1]) echo 'selected';?>>04</option>
	<option value="05" <?php if ('05'==$month_start[1]) echo 'selected';?>>05</option>
	<option value="06" <?php if ('06'==$month_start[1]) echo 'selected';?>>06</option>
	<option value="07" <?php if ('07'==$month_start[1]) echo 'selected';?>>07</option>
	<option value="08" <?php if ('08'==$month_start[1]) echo 'selected';?>>08</option>
	<option value="09" <?php if ('09'==$month_start[1]) echo 'selected';?>>09</option>
	<option value="10" <?php if ('10'==$month_start[1]) echo 'selected';?>>10</option>
	<option value="11" <?php if ('11'==$month_start[1]) echo 'selected';?>>11</option>
	<option value="12" <?php if ('12'==$month_start[1]) echo 'selected';?>>12</option>
</select>
</p>
<input type="submit" name="save_settings" value="保存">
</form>
</p>
<?php
}

add_action( 'wp_ajax_nopriv_stats_init', 'stats_init' );
add_action( 'wp_ajax_stats_init', 'stats_init' );
function stats_init($name) {
	include_once(Easyiit_Stats_DIR."/class/easyiit_stats.class.php");	
	$easy_stats = new easyiit_stats;		
	$easy_stats->init();
	echo 200;
	exit();
}

/*function add_stats_scripts() {
    wp_enqueue_script( 'stats-script', '/style/public/stats/stats_init.js', array( 'jquery' ), '20170720', true );
}
add_action( 'wp_enqueue_scripts', 'add_stats_scripts' );*/
 

function stats_data() {
	global $wpdb;
	//统计数据
   $day = date('Y-m-d');
   $res = $wpdb->get_row("select pv,uv,ip from wp_stats_day_count where day ='$day'",ARRAY_A);
   $data['today_pv'] = (int)$res['pv'];
   $data['today_ip'] = (int)$res['ip'];
   $data['today_uv'] = (int)$res['uv'];
   //全部访问统计
   $res =array();
   $res = $wpdb->get_row("select ip, pv, uv from wp_stats_year_count",ARRAY_A);
   $totol_ip = $wpdb->get_row("select count(id) t_ip, sum(pv) t_pv from wp_stats_day_ip where is_spider=1",ARRAY_A);
   $data['total_ip'] = (int)$totol_ip['t_ip'];
   $data['total_pv'] = (int)$totol_ip['t_pv'];
   $data['total_uv'] = (int)$res['uv'];
   //全部询盘数
   $res = $wpdb->get_row("select count(*) as total from wp_cf7_data",ARRAY_A);
   $data['cf_count']= (int)$res['total'];
   //询盘未读
   $res =array();
   $res = $wpdb->get_row("select count(*) as total from wp_cf7_data_entry where name='readed' and value='0'",ARRAY_A);
   $data['total_cf_noread']= $res['total'];

   //上月询盘转化率
   $data['total_cf_f']= number_format(($data['cf_count']/$data['total_ip']), 4)*100;

   //周访问统计
   $wpdb->query("select day, ip, pv, uv from wp_stats_day_count where  day >= date_format(date_sub(date_sub(now(), INTERVAL WEEKDAY(NOW()) DAY), INTERVAL 1 WEEK), '%Y-%m-%d')",ARRAY_A);
   $week_data = $wpdb->last_result;
   for($k=-6;$k<=0;$k++){
	   $d = date('Y-m-d',strtotime ( "$k day"));
	   $res =array();
	   $res = $wpdb->get_row("select day, ip, pv, uv from wp_stats_day_count where  day='$d'",ARRAY_A);
	   $res['ip']=$res['ip']?$res['ip']:0;
	   $res['pv']=$res['pv']?$res['pv']:0;
	   $res['uv']=$res['uv']?$res['uv']:0;
	   $res['day']=$res['day']?$res['day']:$d;
	   $data['last7days_ip'][]=(int)$res['ip'];
	   $data['last7days_pv'][]=(int)$res['pv'];
	   $data['last7days_uv'][]=(int)$res['uv'];
	   $data['last7days'][$d]=$res;
   }

   $data['last7days_start_y']=date('Y',strtotime ( "-6 day"));
   $data['last7days_start_y']=date('Y',strtotime ( "-6 day"));
   $data['last7days_start_m']=intval(date('m',strtotime ( "-6 day")));
   $data['last7days_start_d']=intval(date('d',strtotime ( "-6 day")));
   $data['last7days_end_y']=date('Y');
   $data['last7days_end_m']=intval(date('m'));
   $data['last7days_end_d']=intval(date('d'));
   
   //访问国家前10
   
   $res =array();
   $sql = 'select * from ( 
		select count(1) ip_area,ip_area show_area, SUM(pv) show_pv, SUM(uv) show_uv, count(ip) show_ip 
		from wp_stats_day_ip t 
		group by t.ip_area 
		order by count(1) desc 
		) t_1 limit 0, 15';
   $wpdb->query($sql);
   $country_top10 = $wpdb->last_result;
   $tmp_i = 0;
   foreach($country_top10 as $key=>$v){
	   if($v->show_area!='Unknown' && $v->show_area!='香港' && $v->show_area!='中国' && $v->show_area!='台湾' && $v->show_area!=''){
			if($tmp_i < 10){
				$data['country_top10_country'][]=$v->show_area;
				$data['country_top10_pv'][]=(int)$v->show_pv;
				$data['country_top10_ip'][]=(int)$v->show_ip;
			}
			$tmp_i ++;
	   }
   }
   //最近访问前30 ip
   $res =array();
   $wpdb->query('select * from wp_stats_day_ip where is_spider=1 order by id desc limit 0,30');
   $ip_view_list = $wpdb->last_result;
   $tmp_data  = array();
   foreach($ip_view_list as $v){
       $v->update=date("Y-m-d H:i:s",$v->update);
	   if($v->ip_area == 'Unknown'){
		   $v->ip_area = '美国';
	   }
	   $tmp_data[]=$v;
   }
   $data['ip_view_list'] = $tmp_data;
   echo json_encode($data);exit();
   
}
add_action( 'wp_ajax_nopriv_stats_data', 'stats_data' );
add_action( 'wp_ajax_stats_data', 'stats_data' );

function stats_get_ip_detail() {
	global $wpdb;
   $id = intval($_GET['id']);
   $res = $wpdb->get_row("select day,ip from wp_stats_day_ip where id ='$id'",ARRAY_A);
   $ip = $res['ip'];
   $day = $res['day'];
   $wpdb->query("select time_str,request from wp_stats_day_data where day_at = '$day' AND ip = '$ip' order by id desc limit 0,30");
   $ip_detail = $wpdb->last_result;
   echo json_encode($ip_detail);exit();
}

add_action( 'wp_ajax_nopriv_stats_get_ip_detail', 'stats_get_ip_detail' );
add_action( 'wp_ajax_stats_get_ip_detail', 'stats_get_ip_detail' );

function stats_data_uvhz() {
	global $wpdb;
   
   //本月
   $res =array();
   $y=date('Y',strtotime($_GET['month']));
   $m=intval(date('m',strtotime($_GET['month'])));

   $res = $wpdb->get_row("select ip, pv, uv from wp_stats_moth_count where year='$y' and moth='$m'",ARRAY_A);
   $data['moth_moth'] =date('Y年m月', strtotime($_GET['month']));   
   $data['moth_begin'] = $moth_begin = $BeginDate = date('Y-m-01', strtotime($_GET['month']));
   $data['moth_end']= $moth_end = date('Y-m-d', strtotime("$BeginDate +1 month -1 day"));

   $data['moth_ip'] = intval($res['ip']);
   $data['moth_pv'] = intval($res['pv']);
   $data['moth_uv'] = intval($res['uv']);
   
   for($k=$data['moth_begin'];$k<=$data['moth_end'];$k++){
	   $res =array();
	   $day=$k;
	   $res = $wpdb->get_row("select ip, pv, uv from wp_stats_day_count where day='$day'",ARRAY_A);
	    $v['ip'] = intval($res['ip']);
		$v['pv'] = intval($res['pv']);
		$v['uv'] = intval($res['uv']);
	    $data['moth']['data'][$day] = $v;
   }
   //国家前10
   
	$res_cf7_ip_area = $wpdb->get_results("select b.`value` as ip_area from wp_cf7_data as d left join wp_cf7_data_entry as b on d.id=b.data_id where b.`name`='ip_area' AND (unix_timestamp(d.`created`) >= unix_timestamp('".$moth_begin."') AND unix_timestamp(d.`created`) <= unix_timestamp('".$moth_end."'))",ARRAY_A);
	$ip_areas = $country_top10 =[];
	if($res_cf7_ip_area){
		foreach ($res_cf7_ip_area as $v){
			$ip_areas[] = $v['ip_area'];
		}
	}
	$i = 0;
	if($ip_areas){
		$sort_ip_area = array_count_values($ip_areas);
		arsort($sort_ip_area);
		foreach ($sort_ip_area as $k=>$v){
			if($i < 10 && $k != '香港' && $k != '台湾' && $k != '未知' && $k != ''){
				$tmp_a['ip_area'] = $v;
				$tmp_a['show_area'] = $k;
				$country_top10[] = $tmp_a;
				$i++;
			}
		}
	}

   $data['country_top10'] = $country_top10;
   //询盘量
   $res =array();
   $s_time_s = $data['moth_begin'].' 00:00:00';
   $e_time_s = $data['moth_end'].' 23:59:59';
   $res = $wpdb->get_row("select count(*) as total from wp_cf7_data where created between '".$s_time_s."' and '".$e_time_s."'",ARRAY_A);

   $data['cf_count']= $res['total'];
   //询盘转化率
   $data['cf_f_count']= number_format($data['cf_count']/$data['moth_ip'], 4)*100;
 
   echo json_encode($data);exit();
   
}
add_action( 'wp_ajax_nopriv_stats_data_uvhz', 'stats_data_uvhz' );
add_action( 'wp_ajax_stats_data_uvhz', 'stats_data_uvhz' );

add_action( 'wp_ajax_nopriv_stats_data_uvzd', 'stats_data_uvzd' );
add_action( 'wp_ajax_stats_data_uvzd', 'stats_data_uvzd' );
function stats_data_uvzd(){
	global $wpdb;
	$res =array();
	$y=date('Y',strtotime($_GET['month']));
	$m=intval(date('m',strtotime($_GET['month'])));
	$res = $wpdb->get_row("select ip, pv, uv from wp_stats_moth_count where year='$y' and moth='$m'",ARRAY_A);
	$data['moth_moth'] =date('Y年m月', strtotime($_GET['month']));   
	$data['moth_begin'] = $moth_begin = $BeginDate = date('Y-m-01', strtotime($_GET['month']));
	$data['moth_end']= $moth_end = date('Y-m-d', strtotime("$BeginDate +1 month -1 day"));

	$data['moth_ip'] = intval($res['ip']);
	$data['moth_pv'] = intval($res['pv']);
	$data['moth_uv'] = intval($res['uv']);

	//国家前10
	$res =array();

	$sql = "select * from ( 
		select count(1) ip_area,ip_area show_area, SUM(pv) show_pv, SUM(uv) show_uv, count(ip) show_ip 
		from wp_stats_day_ip t 
		where t.day>='$moth_begin' and t.day <='$moth_end' 
		group by t.ip_area 
		order by count(1) desc 
		) t_1 limit 0, 10";
	$wpdb->query($sql);
	$country_top10_area = array();
	if($wpdb->last_result){
		foreach($wpdb->last_result as $val){
			if($val->show_area != '台湾' && $val->show_area != '香港' && $val->show_area != 'Unknown'){
				$country_top10_area[] = $val;
			}
		}
	}
	$country_top10 = $country_top10_area;
	$data['country_top10'] = $country_top10;
	$res_zd = $wpdb->get_row("select count(id) as pc from wp_stats_day_ip where is_moblie=0 and date(`day`) between '".$data['moth_begin']."' and '".$data['moth_end']."'",ARRAY_A);
	$data['count_pc'] = $res_zd['pc'];
	$res_zd = $wpdb->get_row("select count(id) as mo from wp_stats_day_ip where is_moblie=1 and date(`day`) between '".$data['moth_begin']."' and '".$data['moth_end']."'",ARRAY_A);
	$data['count_mo'] = $res_zd['mo'];
	echo json_encode($data);
	exit();
}


add_action( 'wp_ajax_nopriv_stats_data_uvym', 'stats_data_uvym' );
add_action( 'wp_ajax_stats_data_uvym', 'stats_data_uvym' );
function stats_data_uvym(){
	global $wpdb;
	$res =array();
	$y=date('Y',strtotime($_GET['month']));
	$m=intval(date('m',strtotime($_GET['month'])));
	$res = $wpdb->get_row("select ip, pv, uv from wp_stats_moth_count where year='$y' and moth='$m'",ARRAY_A);
	$data['moth_moth'] =date('Y年m月', strtotime($_GET['month']));   
	$data['moth_begin'] = $moth_begin = $BeginDate = date('Y-m-01', strtotime($_GET['month']));
	$data['moth_end']= $moth_end = date('Y-m-d', strtotime("$BeginDate +1 month -1 day"));

	$data['moth_ip'] = intval($res['ip']);
	$data['moth_pv'] = intval($res['pv']);
	$data['moth_uv'] = intval($res['uv']);

	//受访页面前15
	$res =array();

	$sql = "select * from ( 
			select count(1) num_request,request
			from wp_stats_day_ip t 
			where t.day>='$moth_begin' and t.day <='$moth_end' 
			group by t.request 
			order by count(1) desc 
			) t_1 limit 0, 15";
	$wpdb->query($sql);
	$referrer_top15_area = array();
	if($wpdb->last_result){
		foreach($wpdb->last_result as $val){
			if($val->request != ''){
				$referrer_top15_area[] = $val;
			}
		}
	}
	$data['referrer_top15_area'] = $referrer_top15_area;
	
	echo json_encode($data);
	exit();
}

add_action( 'wp_ajax_nopriv_stats_data_uvly', 'stats_data_uvly' );
add_action( 'wp_ajax_stats_data_uvly', 'stats_data_uvly' );
function stats_data_uvly(){
	global $wpdb;
	$res =array();
	$y=date('Y',strtotime($_GET['month']));
	$m=intval(date('m',strtotime($_GET['month'])));
	$res = $wpdb->get_row("select ip, pv, uv from wp_stats_moth_count where year='$y' and moth='$m'",ARRAY_A);
	$data['moth_moth'] =date('Y年m月', strtotime($_GET['month']));   
	$data['moth_begin'] = $moth_begin = $BeginDate = date('Y-m-01', strtotime($_GET['month']));
	$data['moth_end']= $moth_end = date('Y-m-d', strtotime("$BeginDate +1 month -1 day"));

	$data['moth_ip'] = intval($res['ip']);
	$data['moth_pv'] = intval($res['pv']);
	$data['moth_uv'] = intval($res['uv']);

	//访问来源页面前15
	$res =array();

	$sql = "select * from ( 
			select count(1) num_referrer,referrer
			from wp_stats_day_ip t 
			where t.day>='$moth_begin' and t.day <='$moth_end' 
			group by t.referrer 
			order by count(1) desc 
			) t_1 limit 0, 15";
	$wpdb->query($sql);
	$referrer_top15_area = array();
	if($wpdb->last_result){
		foreach($wpdb->last_result as $val){
			if(($val->referrer != '')){
				if(strpos($val->referrer,home_url()) !== 0){
					if(strlen($val->referrer) > 50){
                    	$val->referrer = substr($val->referrer,0,50);
                    }
					$referrer_top15_area[] = $val;
				}
			}
		}
	}
	$data['referrer_top15_area'] = $referrer_top15_area;
	
	echo json_encode($data);
	exit();
}

add_action( 'wp_ajax_nopriv_stats_data_xptj', 'stats_data_xptj' );
add_action( 'wp_ajax_stats_data_xptj', 'stats_data_xptj' );
function stats_data_xptj(){
	global $wpdb;
	$res =array();
	$y=date('Y',strtotime($_GET['month']));
	$m=intval(date('m',strtotime($_GET['month'])));
	$data['moth_moth'] =date('Y年m月', strtotime($_GET['month']));   
	$data['moth_begin'] = $moth_begin = $BeginDate = date('Y-m-01', strtotime($_GET['month']));
	$data['moth_end']= $moth_end = date('Y-m-d', strtotime("$BeginDate +1 month -1 day"));
	//全部询盘数
	$res = $wpdb->get_row("select count(*) as total from wp_cf7_data",ARRAY_A);
	$data['cf_count']= (int)$res['total'];

	//上月询盘数量
		
	$data['moth_end_sfm'] = $data['moth_end'].' 23:59:59';
	//访问国家top15
	$s_time_s = $data['moth_begin'].' 00:00:00';
	$e_time_s = $data['moth_end'].' 23:59:59';
	$res_cf7_ip_area = $wpdb->get_results("select b.`value` as ip_area from wp_cf7_data as d left join wp_cf7_data_entry as b on d.id=b.data_id where b.`name`='ip_area' AND (unix_timestamp(d.`created`) >= unix_timestamp('".$s_time_s."') AND unix_timestamp(d.`created`) <= unix_timestamp('".$e_time_s."'))",ARRAY_A);
	$ip_areas = $country_top15_area =[];
	if($res_cf7_ip_area){
		foreach ($res_cf7_ip_area as $v){
			$ip_areas[] = $v['ip_area'];
		}
	}
	$i = 0;
	if($ip_areas){
		$sort_ip_area = array_count_values($ip_areas);
		arsort($sort_ip_area);
		foreach ($sort_ip_area as $k=>$v){
			if($i < 15 && $k != '香港' && $k != '台湾' && $k != '未知' && $k != ''){
				$tmp_a['ip_area'] = $v;
				$tmp_a['show_area'] = $k;
				$country_top15_area[] = $tmp_a;
				$i++;
			}
		}
	}
	$res1 = $wpdb->get_row("select count(*) as total from wp_cf7_data where created between '".$s_time_s."' and '".$e_time_s."'",ARRAY_A);
	$data['cf_count_month']= (int)$res1['total'];
	
	$data['country_top20'] = $country_top15_area;
	echo json_encode($data);exit();
}

add_action( 'wp_ajax_nopriv_stats_data_uvgj', 'stats_data_uvgj' );
add_action( 'wp_ajax_stats_data_uvgj', 'stats_data_uvgj' );
function stats_data_uvgj(){
	global $wpdb;
	$res =array();
	$y=date('Y',strtotime($_GET['month']));
	$m=intval(date('m',strtotime($_GET['month'])));
	$res = $wpdb->get_row("select ip, pv, uv from wp_stats_moth_count where year='$y' and moth='$m'",ARRAY_A);
	$data['moth_moth'] =date('Y年m月', strtotime($_GET['month']));   
	$data['moth_begin'] = $moth_begin = $BeginDate = date('Y-m-01', strtotime($_GET['month']));
	$data['moth_end']= $moth_end = date('Y-m-d', strtotime("$BeginDate +1 month -1 day"));

	$data['moth_ip'] = intval($res['ip']);
	$data['moth_pv'] = intval($res['pv']);
	$data['moth_uv'] = intval($res['uv']);

	//访问国家top15
	$country_top15_area = array();
	$sql = "select * from ( 
			select count(1) ip_area,ip_area show_area
			from wp_stats_day_ip t 
			where t.day>='$moth_begin' and t.day <='$moth_end' 
			group by t.ip_area 
			order by count(1) desc 
			) t_1 limit 0, 19";
	$wpdb->query($sql);
	if($wpdb->last_result){
		foreach($wpdb->last_result as $val){
			if($val->show_area != '中国' &&$val->show_area != '台湾' && $val->show_area != '香港' && $val->show_area != 'Unknown' && $val->show_area != ''){
				$country_top15_area[] = $val;
			}
		}
	}
	$data['country_top15'] = $country_top15_area;
	echo json_encode($data);
	exit();
}

?>