<?php
class easyiit_stats
{
    private static $ip = NULL;
	private static $siteurl = NULL;
  	private static $ip_area =  NULL;
  
	function __construct() {

    } 
	public function init(){

        $ip = $this->ip();
		if(in_array($ip,['49.51.244.7','170.106.76.202','49.51.34.216','124.156.185.151','101.32.221.154'])){
			exit;
		}
		if(empty($ip)){
            echo 'no ip';exit;
        }
		$country = $this->get_ip_country($ip);
      	$this->ip_area = $country;
		
		if($country == '中国' || $country==""){
			exit();
		}
		$request = $this->get_request();
		$cdn_setting = get_option("gd_cdn_setting");
		$cdn_weburl = $cdn_setting['weburl'];
		$top_url = $this->getTopHost($cdn_weburl);
		if(strpos($request,$top_url) === false){
			exit();
		}
		if(strpos($request,'quanqiusou.cn') !== false || strpos($request,'goodao.net') !== false){
			exit();
		}
		if(!$this->check_ip_day($ip)){			
			$this->add_day_ip();
			$this->add_day_data();
			$this->update_day_ip_count();
			$this->update_day_pv_count();
			$this->update_day_uv_count();
			$this->update_moth_count();
			$this->update_year_count();
		}else	{			
			$this->add_day_data();
			$this->update_day_pv();			
			$this->update_day_pv_count();
			$this->update_day_uv_count();
			$this->update_moth_count();
			$this->update_year_count();
		}
	}
	public function getTopHost($url){
		$url = strtolower($url);
		$hosts = parse_url($url);
		$host = $hosts['host'];
		$data = explode('.', $host);
		$n = count($data);
		$preg = '/[\w].+\.(com|net|org|gov|edu)\.cn$/';
		if(($n > 2) && preg_match($preg,$host)){
			$host = $data[$n-3].'.'.$data[$n-2].'.'.$data[$n-1];
		}else{
			$host = $data[$n-2].'.'.$data[$n-1];
		}
		return $host;
	}
	public function ip(){
	    if(isset($_GET["ip"])){
	        return $_GET["ip"];
	    }else{
    		if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')) {
    			$ip = getenv('HTTP_CLIENT_IP');
    		} elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) {
    			$ip = getenv('HTTP_X_FORWARDED_FOR');
    		} elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')) {
    			$ip = getenv('REMOTE_ADDR');
    		} elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
    			$ip = $_SERVER['REMOTE_ADDR'];
    		}
    		return preg_match ( '/[\d\.]{7,15}/', $ip, $matches ) ? $matches [0] : '';
	    }
	}
	public function get_referrer(){
		$referrer = isset($_GET["referrer"]) ? substr(urldecode($_GET["referrer"]),0,255) : "";
		if(strpos($referrer,'google') || strpos($referrer,'facebook') || strpos($referrer,'bing') || strpos($referrer,'yahoo') || strpos($referrer,'youtube') || strpos($referrer,'linkedin') || strpos($referrer,'messefrankfurt') || strpos($referrer,'yandex')){
			$referrer = str_replace('http://','https://',$referrer);
		    if($referrer == 'https://www.google.com'){
		        $referrer = $referrer.'/';
		    }
			return $referrer;
		}elseif($referrer == ""){
          	return '';
        }else{
			return 'https://www.google.com/';
		}
	}
	public function get_request(){
      	$request = isset($_GET["currweb"]) ? substr(urldecode($_GET["currweb"]),0,255) : "";
      	if(strpos($request,home_url('/') === false)){
        	$request = home_url('/');
        }
		return $request;
	}

	public function get_server_name(){
		return $_SERVER['SERVER_NAME'];
	}
	public function get_user_agent(){
	    if(isset($_GET['user_agent'])){
	        $agent = urldecode($_GET['user_agent']);
	    }else{
		    $agent = $_SERVER['HTTP_USER_AGENT'];
	    }
	    if(strpos($agent,'hubspot') === false){
            return $agent;
        }else{
            exit;
        }
	}
    public function get_referrer_head(){
		$referrer = $this->get_referrer();
		return $referrer_head=isset($referrer) ? breakurl($referrer) : "";
	}
	public function isCrawler(){
		$agent= strtolower($this->get_user_agent());   
		if (!empty($agent)) {   
			$spiderSite= array(   
				"TencentTraveler",   
				"Baiduspider+",   
				"BaiduGame",   
				"Googlebot",   
				"msnbot",   
				"Sosospider+",   
				"Sogou web spider",   
				"ia_archiver",   
				"Yahoo! Slurp",   
				"YoudaoBot",   
				"Yahoo Slurp",   
				"MSNBot",   
				"Java (Often spam bot)",   
				"BaiDuSpider",   
				"Voila",   
				"Yandex bot",   
				"BSpider",   
				"twiceler",   
				"Sogou Spider",   
				"Speedy Spider",   
				"Google AdSense",   
				"Heritrix",   
				"Python-urllib",   
				"Alexa (IA Archiver)",   
				"Ask",   
				"Exabot",   
				"Custo",   
				"OutfoxBot/YodaoBot",   
				"yacy",   
				"SurveyBot",   
				"legs",   
				"lwp-trivial",   
				"Nutch",   
				"StackRambler",   
				"The web archive (IA Archiver)",   
				"Perl tool",   
				"MJ12bot",   
				"Netcraft",   
				"MSIECrawler",   
				"WGet tools",   
				"larbin",   
				"Fish search", 
				"yandex.com/bots",
              	"google.com/bot",
              	"bingbot",
				"YandexMobileBot",
              	"BingPreview",
				"AhrefsBot",
				"bot"
			);   
			$flag = 0;
			foreach($spiderSite as $val) {   
				$str = strtolower($val);   
				if (strpos($agent, $str) !== false) {   
					$flag = 1;
				}   
			}  
          	if($flag == 1){
            	return true;
            }else{
            	return false;
            }
		} else {   
			return false;   
		}   
	}
	public function isMobile(){   
	    if(isset($_GET['is_mobile'])){
	        if($_GET['is_mobile'] == 1){
	            return true;
	        }else{
	            return false;
	        }
	    }else{
    		// 如果有HTTP_X_WAP_PROFILE则一定是移动设备
    		if (isset ($_SERVER['HTTP_X_WAP_PROFILE'])){
    			return true;
    		} 
    		// 如果via信息含有wap则一定是移动设备,部分服务商会屏蔽该信息
    		if (isset ($_SERVER['HTTP_VIA'])){ 
    			// 找不到为flase,否则为true
    			return stristr($_SERVER['HTTP_VIA'], "wap") ? true : false;
    		} 
    		// 脑残法，判断手机发送的客户端标志,兼容性有待提高
    		if (isset ($_SERVER['HTTP_USER_AGENT'])){
    			$clientkeywords = array ('nokia',
    				'sony',
    				'ericsson',
    				'mot',
    				'samsung',
    				'htc',
    				'sgh',
    				'lg',
    				'sharp',
    				'sie-',
    				'philips',
    				'panasonic',
    				'alcatel',
    				'lenovo',
    				'iphone',
    				'ipod',
    				'blackberry',
    				'meizu',
    				'android',
    				'netfront',
    				'symbian',
    				'ucweb',
    				'windowsce',
    				'palm',
    				'operamini',
    				'operamobi',
    				'openwave',
    				'nexusone',
    				'cldc',
    				'midp',
    				'wap',
    				'mobile'
    				); 
    			// 从HTTP_USER_AGENT中查找手机浏览器的关键字
    			if (preg_match("/(" . implode('|', $clientkeywords) . ")/i", strtolower($_SERVER['HTTP_USER_AGENT']))){
    				return true;
    			} 
    		} 
    		// 协议法，因为有可能不准确，放到最后判断
    		if (isset ($_SERVER['HTTP_ACCEPT'])){ 
    			// 如果只支持wml并且不支持html那一定是移动设备
    			// 如果支持wml和html但是wml在html之前则是移动设备
    			if ((strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') !== false) && (strpos($_SERVER['HTTP_ACCEPT'], 'text/html') === false || (strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') < strpos($_SERVER['HTTP_ACCEPT'], 'text/html')))){
    				return true;
    			} 
    		} 
    		return false;
	    }
	} 
	public function is_old_user(){
		global $wpdb;
		$ip = $this->ip();
		$res = $wpdb->get_row("SELECT count(*) as cnt FROM ".$wpdb->prefix."stats_day_ip WHERE ip='".$ip."'",ARRAY_A);
		if($res['cnt'] > 0){ return true; }else{ return false; }
	}
	public function is_future_cat(){
		global $wpdb;
		$res = $wpdb->get_row( "select p.id from wp_posts as p inner join wp_term_relationships as re on p.ID=re.object_id where re.term_taxonomy_id=635 and p.guid='".$this->get_request()."'" );
		if($res){
			return home_url('/');
		}else{
			return $this->get_request();
		}
	}
    public function add_day_ip(){
      
		if(strpos($this->get_referrer(),'admin/') || strpos($this->is_future_cat(),'admin/')){
			return false;
		}
		global $wpdb;
		$res = $wpdb->insert($wpdb->prefix .'stats_day_ip',
			array(
				'day' => date('Y-m-d'),
				'ip' => $this->ip(),
				'ip_area' => $this->ip_area,
			    'update' => time(),
				'pv' => 1,
			    'uv' => 1,
				'request' => $this->is_future_cat(),
				'referrer' => $this->get_referrer(),
				'is_spider' => $this->isCrawler()?0:1,
				'is_moblie' => $this->isMobile()?1:0,
				'is_old_user' => $this->is_old_user()?0:1,
			), 
			array( 
			    '%s',
			    '%s',
				'%s',
				'%s',
			    '%s',
				'%s',
			    '%s',
				'%s',
			    '%s',
			    '%s',
				'%s'
		));
		return $res;
	}

	public function add_day_data(){
		if(strpos($this->get_referrer(),'admin/') || strpos($this->is_future_cat(),'admin/')){
			return false;
		}
		global $wpdb;
		return $wpdb->insert($wpdb->prefix .'stats_day_data',
			array(
			    'day_at' => date('Y-m-d'),
			    'year' => date('Y'),
			    'moth' => date('m'),
				'day' => date('d'),
				'ip' => $this->ip(),
			    'ip_area' => $this->ip_area,
				'time' => time(),
				'time_str' => date('Y-m-d H:i:s'),
				'remote_host' => $this->ip(),
				'request' => $this->is_future_cat(),
				'referrer' => $this->get_referrer(),
				'user_agent' => $this->get_user_agent(),
			), 
			array( 
			    '%s',
			    '%s',
			    '%s',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s',
			    '%s'
		));
	}
	public function check_ip_day($ip){
		global $wpdb;
		$day = date('Y-m-d');
		$res = $wpdb->get_row( "SELECT ip FROM ".$wpdb->prefix."stats_day_ip WHERE ip='$ip' AND day ='$day'" );		
		if($res->ip){
			return $res->ip;
		}
        return false;
	}
	public function check_request_day(){
		global $wpdb;
		$year = date('Y');
		$moth = date('m');
		$day = date('d');
		$ip = $this->ip();
		$request = $this->get_request();
		$res = $wpdb->get_row( "SELECT ip FROM ".$wpdb->prefix."stats_day_data WHERE ip='$ip' AND year = '$year' AND moth = '$moth' AND day ='$day' AND request ='$request';" );		
		if($res->ip){
			return $res->ip;
		}
        return false;
	}
	public function update_day_pv(){
		if($this->isCrawler()){
			return false;
		}
		if(strpos($this->get_referrer(),'admin/') || strpos($this->is_future_cat(),'admin/')){
			return false;
		}
		global $wpdb;
		$ip = $this->ip(); 
		$day = date('Y-m-d');	
		if(!$_COOKIE['easyiit_stats']){
			$wpdb->query("update `".$wpdb->prefix."stats_day_ip` set `uv`=`uv`+1 WHERE `day` = '".$day."' AND `ip`='".$ip."'");
		}
		return $wpdb->query("update `".$wpdb->prefix."stats_day_ip` set `pv`=`pv`+1 WHERE `day` = '".$day."' AND `ip`='".$ip."'");
		
	}

	public function update_day_ip_count(){
		if($this->isCrawler()){
			return false;
		}
		if(strpos($this->get_referrer(),'admin/') || strpos($this->is_future_cat(),'admin/')){
			return false;
		}
		global $wpdb;
		$day = date('Y-m-d');
		$res = $wpdb->get_row( "SELECT count(*) as num FROM ".$wpdb->prefix."stats_day_count WHERE day ='$day'" );		
		
		if($res->num > 0){
			return $wpdb->query("update `".$wpdb->prefix."stats_day_count` set `ip`=`ip`+1 WHERE `day`='$day'");
		}else{
			return $wpdb->insert($wpdb->prefix .'stats_day_count',
				array(
					'day' => date('Y-m-d'),
					'ip' => 1,
					'pv' => 0,
					'uv' => 1,
			        'updatetime' => time(),
				), 
				array( 
					'%s',
					'%s',
					'%s',
					'%s',
					'%s'					
			));
		}
        return false;
	}

	public function update_day_pv_count(){
		if($this->isCrawler()){
			return false;
		}
		if(strpos($this->get_referrer(),'admin/') || strpos($this->is_future_cat(),'admin/')){
			return false;
		}
		global $wpdb;
		$day = date('Y-m-d');	
		if(!$this->isCrawler()){
			return $wpdb->query("update `".$wpdb->prefix."stats_day_count` set `pv`=`pv`+1 WHERE `day`='$day'");
		}
	}

	public function update_day_uv_count(){
		if($this->isCrawler()){
			return false;
		}
		if(strpos($this->get_referrer(),'admin/') || strpos($this->is_future_cat(),'admin/')){
			return false;
		}
		if(!$this->isCrawler()){
			global $wpdb;
			$day = date('Y-m-d');	
			if(!$_COOKIE['easyiit_stats']){
				$wpdb->query("update `".$wpdb->prefix."stats_day_count` set `uv`=`uv`+1 WHERE `day`='$day'");
				return true;
			}else{
				return false;
			}
        }
	}

	public function update_moth_count(){
		if($this->isCrawler()){
			return false;
		}
		if(strpos($this->get_referrer(),'admin/') || strpos($this->is_future_cat(),'admin/')){
			return false;
		}
		global $wpdb;
		$year = date('Y');
		$moth = intval(date('m'));
		$t = time();
		$res = $wpdb->get_row( "SELECT count(*) as num,updatetime FROM ".$wpdb->prefix."stats_moth_count WHERE year = $year AND moth = $moth" );				
		if($res->num > 0){
			//if((time()-$res->updatetime)>3600){	
				$sum_data = $wpdb->get_row("SELECT SUM(ip) as ip_num,SUM(pv) as pv_num,SUM(uv) as uv_num FROM ".$wpdb->prefix."stats_day_count WHERE date_format(`day`, '%Y%m') = date_format(curdate(), '%Y%m')");	
				
				return $wpdb->query("update `".$wpdb->prefix."stats_moth_count` set `ip`='$sum_data->ip_num',`pv`='$sum_data->pv_num', `uv`='$sum_data->uv_num', `updatetime`= '$t' WHERE year = $year AND moth = $moth");	
			//}
		}else{	
			$sum_data = $wpdb->get_row( "SELECT SUM(ip) as ip_num, SUM(pv) as pv_num, SUM(uv) as uv_num FROM ".$wpdb->prefix."stats_day_count WHERE date_format(`day`, '%Y%m') = date_format(curdate() , '%Y%m')" );

			return $wpdb->insert($wpdb->prefix .'stats_moth_count',
				array(
					'year' => $year,
					'moth' => $moth,
					'ip' => $sum_data->ip_num,
					'pv' => $sum_data->pv_num,
					'uv' => $sum_data->uv_num,
					'updatetime' => time(),
				), 
				array( 
					'%s',
					'%s',
					'%s',
					'%s',
					'%s',
					'%s'
			));
		}
		return false;
	}

	public function update_year_count(){
		if($this->isCrawler()){
			return false;
		}
		if(strpos($this->get_referrer(),'admin/') || strpos($this->is_future_cat(),'admin/')){
			return false;
		}
		global $wpdb;
		$year = date('Y');
		$t = time();
		$res = $wpdb->get_row( "SELECT count(*) as num,updatetime FROM ".$wpdb->prefix."stats_year_count WHERE year = $year" );		
		
		if($res->num > 0 ){	
			//if((time()-$res->updatetime)>3600*24){			
				$sum_data = $wpdb->get_row("SELECT SUM(ip) as ip_num,SUM(pv) as pv_num,SUM(uv) as uv_num FROM ".$wpdb->prefix."stats_moth_count WHERE year = $year");				
				return $wpdb->query("update `".$wpdb->prefix."stats_year_count` set `ip`='$sum_data->ip_num',`pv`='$sum_data->pv_num', `uv`='$sum_data->uv_num', `updatetime`= '$t' WHERE year = $year");
			//}
		}else{	
			$sum_data = $wpdb->get_row( "SELECT SUM(ip) as ip_num,SUM(pv) as pv_num,SUM(uv) as uv_num FROM ".$wpdb->prefix."stats_moth_count WHERE year = $year" );
			return $wpdb->insert($wpdb->prefix .'stats_year_count',
				array(
					'year' => $year,
					'ip' => $sum_data->ip_num,
					'pv' => $sum_data->pv_num,
					'uv' => $sum_data->uv_num,
					'updatetime' => time(),
				), 
				array( 					
					'%s',
					'%s',
					'%s',
					'%s',
					'%s'
			));
		}
		return false;
	}
    public function show_country_count(){
        return $sql = 'select * from ( 
		select count(1) ip_area,ip_area show_area,pv show_pv
		from '.$wpdb->prefix.'stats_day_ip t 
		group by t.ip_area 
		order by count(1) desc 
		) t_1 limit 0, 10';

	}
	public function reset_stats(){
		global $wpdb;
		$table = $wpdb->prefix . "stats_day_ip";
        $wpdb->query("truncate table $table");
		$table = $wpdb->prefix . "stats_day_data";
        $wpdb->query("truncate table $table");
		$table = $wpdb->prefix . "stats_day_count";
        $wpdb->query("truncate table $table");
		$table = $wpdb->prefix . "stats_moth_count";
        $wpdb->query("truncate table $table");
		$table = $wpdb->prefix . "stats_year_count";
        $wpdb->query("truncate table $table");
		return true;
	} 
	public function get_ip_country($ip){
	    if(isset($_GET['ip_area'])){
	        return $_GET['ip_area'];
	    }else{
	        $country = file_get_contents("http://ip.globalso.com/?ip=".$ip);
          	if($country){
            	return $country;
            }else{
            	return "Unknown";
            }	
	    }
	}
}
