<?php
/**
 * Plugin Name: 产品复制发布
 * Plugin URI: #
 * Description: 产品复制发布
 * Version: 1.0.00
 * Author: #
 * Author URI: #
 */

if (!defined('IMPORT_PATH')) define('IMPORT_PATH', plugin_dir_path(__FILE__));
add_action('admin_menu', 'easyiit_autopost_init');

function easyiit_autopost_init() {
    add_menu_page('产品复制发布', '产品复制发布', 7, 'easyiit_autopost');
    add_submenu_page('easyiit_autopost', '设置', '设置', 7, 'easyiit_autopost', 'easyiit_autopost_setting');
	
}
 
 
function easyiit_autopost_setting() {
global $products_arr;
if(isset($_POST['dosubmit'])){
	$category = get_category_by_slug("Featured");
	if(!$category){
		wp_create_category("Featured");
		$category = get_category_by_slug("Featured");
	}
	$post_setting = $_POST['setting'];	
	 update_option( "_post_setting", $post_setting );
}
$post_setting = get_option("_post_setting");
$all_cat_lists = get_term_children(490,'category');
$categorys = array();
foreach($all_cat_lists as $val){
	$cat_t = get_term_by('id',$val,'category');
	if($cat_t->parent == 490){
		$categorys[] = $val;
	}
}
?>
<div class="wrap">
<form id="posts-filter" method="post">
<h2 class="title">发布设置</h2>
<table class="form-table permalink-structure">
	<tbody>	
	<tr>
		<th>
			<label>标题随机前缀：</label>
		</th>
		<td>
			<?php foreach($categorys as $catid){ $cate=get_category($catid);?>
			<span style="text-align:left; display:block;"><?php echo $cate->name;?></span>
			<textarea id="" rows="5" cols="40" name="setting[title_pre_<?php echo $cate->term_id;?>]"><?php 
			$str_title_pre = "title_pre_".$cate->term_id;echo $post_setting[$str_title_pre]?></textarea><br>
			<?php }?>
		</td>
	</tr>
	<tr>
		<th>
			<label>标题随机后缀：</label>
		</th>
		<td>
          	<textarea id="" rows="5" cols="40" name="setting[title_suffix]"><?php echo $post_setting['title_suffix'];?></textarea>
		</td>
	</tr>
	<tr>
		<th>
			<label>随机关键字标签：</label>
		</th>
		<td>
			<?php foreach($categorys as $catid){ $cate=get_category($catid);?>
			<span style="text-align:left; display:block;"><?php echo $cate->name;?></span>
			<textarea id="" rows="5" cols="40" name="setting[tags_<?php echo $cate->term_id;?>]"><?php $str_tag = "tags_".$cate->term_id;echo $post_setting[$str_tag]?></textarea><br>
			<?php }?>
		</td>
	</tr>
	<tr>
		<th>
			<label>发布类别：</label>
		</th>
		<td>
			<select name="setting[post_type]">
			    <option value="Featured" selected>Featured</option>			
			</select>
		</td>
	</tr>

	<tr>
		<th>
			<label>最大发布数量：</label>
		</th>
		<td>
		   <input type="text" name="setting[max_num]" size="4" value="<?php echo $post_setting['max_num']?>"/>
		</td>
	</tr>
	
</tbody>
</table>

<p class="submit"><input type="submit" name="dosubmit" id="submit" class="button button-primary" value="保存更改"></p>
</form>
</div>
<div class="clear"></div>
<?php
}
add_action( 'wp_ajax_nopriv_autopost', 'easyiit_autopost' );
add_action( 'wp_ajax_autopost', 'easyiit_autopost' );
//add_action( 'wp_loaded', 'autopost' ); 
function easyiit_autopost() {
	global $wpdb;
	set_time_limit(0); 
    ignore_user_abort(true); 
	$post_setting = get_option("_post_setting");
	$last_post_time = get_option("_last_post_time");
	//$product_category = get_category_by_slug("products");
	$all_cat_lists = get_term_children(490,'category');
	$categorys = array();
	foreach($all_cat_lists as $val){
		$cat_t = get_term_by('id',$val,'category');
		if($cat_t->parent == 490){
			$categorys[] = $val;
		}
	}
	$featured_category = get_category_by_slug("featured");
	if(!$featured_category){
		wp_create_category("featured");
		$featured_category = get_category_by_slug("featured");
	}
	
	$featured_count = count(query_posts(array('cat'=>$featured_category->term_id, 'post_type' => 'post','posts_per_page'=>-1)));
	
	$max_post_num = $post_setting['max_num']?$post_setting['max_num']:1200;
	
    if(time()<($last_post_time+$post_setting['post_rate'])){
	  echo -1;exit;
	}
	
   if($featured_count >= $max_post_num){
        $home_url = home_url('/');
        $home_url_ar = explode('/',$home_url);
        //file_get_contents('http://www.quanqiusou.cn/extend_api/saas/spider.php?t=4&w='.$home_url_ar[2]);
        $every_num = 1;
    }else{
        $every_num = 100;
    }
   	for($i=0;$i<$every_num;$i++){
   	    foreach($categorys as $vv){
            $ar_tt[$vv] = count(explode("\n",$post_setting['tags_'.$vv]));
        }
        $cur_catid = get_rand($ar_tt);
        $str_title_pre = 'title_pre_'.$cur_catid;
        $str_title_suffix = 'title_suffix';
        $str_tags = 'tags_'.$cur_catid;
        if($post_setting[$str_title_pre]==''||$post_setting[$str_title_suffix]==''||$post_setting[$str_tags]==''){
          echo -2;exit;
        }
        $cat_taxonomy = $wpdb->get_row("SELECT * FROM wp_term_taxonomy where `term_id`=".$cur_catid." AND `taxonomy` = 'category'");
    	$randposts = $wpdb->get_row("SELECT * FROM wp_term_relationships  WHERE term_taxonomy_id=".$cat_taxonomy->term_taxonomy_id." ORDER BY RAND() LIMIT 1"); 
        $post = query_posts(array('p'   => $randposts->object_id));
        if(!$post[0]->post_title){
            $randposts = $wpdb->get_row("SELECT * FROM wp_term_relationships  WHERE term_taxonomy_id=".$cat_taxonomy->term_taxonomy_id." ORDER BY RAND() LIMIT 1"); 
            $post = query_posts(array('p'   => $randposts->object_id));
        }
        $product_gallery = get_post_meta($post[0]->ID,"product_gallery");
        $title_pre_arr = explode("\n",$post_setting[$str_title_pre]); 
        $tags_arr = explode("\n",$post_setting[$str_tags]);
        $title_pre = $title_pre_arr[array_rand($title_pre_arr)];
        $title_suffix = $post_setting[$str_title_suffix];
        shuffle($tags_arr);
        $tags = array_slice($tags_arr,0,10);
        //print_r($tags);exit;
        if($post[0]->post_title){
            $new_post = array(
                'post_title'    => str_replace("/n",'',$title_pre)." ".$post[0]->post_title." ".str_replace("/n",'',$title_suffix),
                'post_content'  => $post[0]->post_content,
                'post_status'   => 'publish',
                'post_author'   => 1,
                'post_date'   => '2016-01-08 00:00:00',
                'post_date_gmt'   => '2016-01-08 00:00:00',
                'post_category' => array($featured_category->cat_ID)
            );
            $post_id = wp_insert_post( $new_post );
            update_post_meta($post_id, "product_gallery", $product_gallery[0]);
            wp_set_post_tags($post_id,$tags);	
            if($post_id){
                update_option("_last_post_time",time());
                echo $post_id.'-';
            }
        }
    }
  	echo "success\n";
	exit();
}


//概率算法
function get_rand($proArr) {  
    $result = '';
    $proSum = array_sum($proArr);
    foreach ($proArr as $key => $proCur) {
        $randNum = mt_rand(1, $proSum);
        if ($randNum <= $proCur) {
            $result = $key;
            break;
        } else {
            $proSum -= $proCur;
        }
    }
    unset ($proArr);
    return $result;
}
/*function easyiit_autopost_add_scripts() {
    wp_enqueue_script( 'autopost-script', '/wp-content/plugins/easyiit_autopost/js/autopost.js', array( 'jquery' ), '20161212', true );
}
add_action( 'wp_enqueue_scripts', 'easyiit_autopost_add_scripts' );
add_action( 'admin_enqueue_scripts', 'easyiit_autopost_add_scripts' );*/
