<?php
if (!defined('ABSPATH')) {
    exit('Direct\'s not allowed');
}
function convertip_tiny($ip, $ipdatafile) {

	static $fp = NULL, $offset = array(), $index = NULL;

	$ipdot = explode('.', $ip);
	$ip    = pack('N', ip2long($ip));

	$ipdot[0] = (int)$ipdot[0];
	$ipdot[1] = (int)$ipdot[1];

	if($fp === NULL && $fp = @fopen($ipdatafile, 'rb')) {
		$offset = @unpack('Nlen', @fread($fp, 4));
		$index  = @fread($fp, $offset['len'] - 4);
	} elseif($fp == FALSE) {
		return  '- Invalid IP data file';
	}

	$length = $offset['len'] - 1028;
	$start  = @unpack('Vlen', $index[$ipdot[0] * 4] . $index[$ipdot[0] * 4 + 1] . $index[$ipdot[0] * 4 + 2] . $index[$ipdot[0] * 4 + 3]);

	for ($start = $start['len'] * 8 + 1024; $start < $length; $start += 8) {

		if ($index{$start} . $index{$start + 1} . $index{$start + 2} . $index{$start + 3} >= $ip) {
			$index_offset = @unpack('Vlen', $index{$start + 4} . $index{$start + 5} . $index{$start + 6} . "\x0");
			$index_length = @unpack('Clen', $index{$start + 7});
			break;
		}
	}

	@fseek($fp, $offset['len'] + $index_offset['len'] - 1024);
	if($index_length['len']) {
		return '- '.@fread($fp, $index_length['len']);
	} else {
		return '- Unknown';
	}

}

//add js, css
add_action('admin_enqueue_scripts', 'cf7_custom_wp_admin_style');
function cf7_custom_wp_admin_style()
{
    wp_register_script('cf7d_js', CF7D_PLUGIN_URL . '/admin/assets/js/cf7d.js', array('jquery'));

    wp_register_style('cf7d', CF7D_PLUGIN_URL . '/admin/assets/css/cf7d.css');
    wp_enqueue_style('cf7d');
}

//add admin menu page
add_action('admin_menu', 'cf7d_register_custom_submenu_page');
function cf7d_register_custom_submenu_page()
{
    $menu = add_submenu_page('wpcf7', 'Database', 'Database', 'manage_options', 'cf7-data', 'cf7d_custom_submenu_page_callback');
    add_action('load-' . $menu, 'cf7d_form_action_callback');
}
function cf7d_custom_submenu_page_callback_bak()
{
    if (!class_exists('WP_List_Table')) {
        require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
    }
    require_once 'table.php';
    $entries = new Cf7_Entries_List();
    ?>
    <div class="wrap">
        <h2>WP_List_Table Class Example</h2>

        <div id="poststuff">
            <div id="post-body" class="metabox-holder columns-2">
                <div id="post-body-content">
                    <div class="meta-box-sortables ui-sortable">
                        <form method="post">
                            <?php
                            $entries->prepare_items();
                            $entries->display(); ?>
                        </form>
                    </div>
                </div>
            </div>
            <br class="clear">
        </div>
    </div>
    <?php
}
function cf7d_custom_submenu_page_callback()
{
    global $wpdb;
	if(isset($_POST['sbt_google_js'])&&$_POST['sbt_google_js']){
		$google_js = $_POST['google_js'];
		update_option('_google_js',$google_js);		
	}
	$google_js = get_option('_google_js');
    $tinyipfile = ABSPATH . 'wp-content/plugins/contact-form-7-database/ipdata/tinyipdata.dat';
    wp_enqueue_script('cf7d_js');
    wp_enqueue_script('jquery-ui-sortable');
    echo '<div class="wrap page-inquiry" style="margin: 20px 0 0 5px;">';
    if (!class_exists('WPCF7_Contact_Form_List_Table')) {
        require_once WPCF7_PLUGIN_DIR . '/admin/includes/class-contact-forms-list-table.php';
    }

    $list_table = new WPCF7_Contact_Form_List_Table();
    $list_table->prepare_items();

    $first_form_id = 20;
    $fid = ((isset($_GET['fid'])) ? (int) $_GET['fid'] : '');
    $search = ((isset($_GET['search'])) ? addslashes($_GET['search']) : '');

    echo '<form action="'.admin_url('admin.php').'" method="GET">';
    echo '<div style="float:left;margin:3px 3px 0 0;font-weight:bold;">切换询盘表单：</div><input type="hidden" name="page" value="cf7-data" />';
    echo '<select name="fid" onchange="this.form.submit();">';
    echo '<option value="" '.(( count($list_table->items) == 0 ) ? 'selected="selected"' : '').' >'.__('Choose form').'</option>';
    $i = 0;
    foreach ($list_table->items as $k => $v) {
        if ($first_form_id == 0 && $i == 0) {
            $first_form_id = $v->id;

            if (empty($fid) && ($first_form_id > 0)) {
                $fid = $first_form_id;
            }
        }
        echo '<option value="'.$v->id.'" '.(( !empty($fid) && ($fid == $v->id)) ? 'selected="selected"' : '').'>'.$v->title.'</option>';
    }
    echo '</select>';
    echo '</form>';
    
    if (!empty($fid)) {
        
        $cf7d_entry_order_by = apply_filters('cf7d_entry_order_by', '`data_id` DESC');
        $cf7d_entry_order_by = trim($cf7d_entry_order_by);

        $items_per_page = apply_filters('cf7d_entry_per_page', 20);
        $page = isset($_GET['cpage']) ? abs((int)$_GET['cpage']) : 1;
        $offset = ( $page * $items_per_page ) - $items_per_page;

        $query = sprintf("SELECT * FROM `".$wpdb->prefix."cf7_data_entry` WHERE `cf7_id` = %d AND data_id IN(SELECT * FROM (SELECT data_id FROM `".$wpdb->prefix."cf7_data_entry` WHERE 1 = 1 ".((!empty($search)) ? "AND `value` LIKE '%%".$search."%%'" : "")." GROUP BY `data_id` ORDER BY ".$cf7d_entry_order_by." LIMIT %d,%d) temp_table) ORDER BY " . $cf7d_entry_order_by, $fid, $offset, $items_per_page);
        $data = $wpdb->get_results($query);
        $data_sorted = cf7d_sortdata($data);

        $fields = cf7d_get_db_fields($fid);

        $total = $wpdb->get_results("SELECT data_id FROM `".$wpdb->prefix."cf7_data_entry` WHERE `cf7_id` = " . (int)$fid . " ".((!empty($search)) ? "AND `value` LIKE '%%".$search."%%'" : "")." GROUP BY `data_id`");
        $total = count($total);
if( current_user_can('administrator') ) {
        $entry_actions = array(
                'delete' => '批量删除'
            );
			}
			
        $entry_actions = apply_filters('cf7d_entry_actions', $entry_actions);
        ?>
	 
        <form action="" method="GET" id="cf7d-admin-action-frm">
            <div class="inquiry-list-head">
            <span class="filter-toggle"></span>
            <input type="hidden" name="page" value="cf7-data">
            <input type="hidden" name="fid" value="<?php echo $fid; ?>">
            <div class="tablenav top xs-filter-hide">
                <div class="alignleft actions bulkactions">
                    <label for="bulk-action-selector-top" class="screen-reader-text"><?php _e('Select bulk action');?></label>
                    <select name="action" id="bulk-action-selector-top">
                        <option value="-1"><?php _e('Bulk Actions'); ?></option>
                        <?php echo cf7d_arr_to_option($entry_actions); ?>
                    </select>
                    <input id="doaction" name="btn_apply" class="button action" value="<?php _e('Apply'); ?>" type="submit" />
                    <?php do_action('cf7d_after_bulkaction_btn', $fid); ?>                    
                </div>
                <div class="tablenav-pages">
                    <span class="displaying-num"><?php echo (($total == 1) ?
                    '1 ' . __('item') :
                    $total . ' ' . __('items')) ?></span>
					<span class="pagination-links">
                        <?php
                        echo paginate_links(array(
                            'base' => add_query_arg('cpage', '%#%'),
                            'format' => '',
                            'prev_text' => __('&laquo;'),
                            'next_text' => __('&raquo;'),
                            'total' => ceil($total / $items_per_page),
                            'current' => $page
                        ));
                        ?>
                    </span>

                </div>
                </div>
            </div>
            <table class="wp-list-table widefat fixed striped posts cf7d-admin-table">
                <thead>
                    <tr>
                        <?php
                        echo '<th id="cb" class="manage-column column-cb check-column"><input type="checkbox" id="cb-select-all-1" /></th>';
      					//print_r($fields);exit;
                        foreach ($fields as $k => $v) {
                          	if($k == 'ip_area'){continue;}
							if($k=='readed'){
								echo '<th class="manage-column gd-xs-hide" data-key="'.$v.'">是否已读</th>';
							}else if($k=='submit_ip'){
                            	echo '<th class="manage-column gd-xs-hide" data-key="'.$v.'">访客国家(IP)</th>';
                            }
                            else if($v!='询盘发送时间' && $v!='邮箱(Email)'){
                            echo '<th class="manage-column gd-xs-hide '.$v.'" data-key="'.$v.'">'.cf7d_admin_get_field_name($v).'</th>';
                            }
							else{
                              	
                                echo '<th class="manage-column '.$v.'" data-key="'.$v.'">'.cf7d_admin_get_field_name($v).'</th>';
                            }
                            
                        }
                        ?>
                        <?php do_action('cf7d_admin_after_heading_field'); ?>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    foreach ($data_sorted as $k => $v) {
                        echo '<tr>';
                        echo '<th class="check-column" scope="row"><input id="cb-select-'.$k.'" type="checkbox" name="del_id[]" value="'.$k.'" /></th>';
                        foreach ($fields as $k2 => $v2) {
                          	if($k2 == 'ip_area'){continue;}
                          	if($v2 == '发送页面'){
                                echo '<td class="manage-column gd-xs-hide '.cf7d_admin_get_field_name($v2).'" data-head="'.cf7d_admin_get_field_name($v2).'">'.'<a target="_blank" href="'.((isset($v[$k2])) ? $v[$k2] : '&nbsp;').'" title="'.((isset($v[$k2])) ? $v[$k2] : '&nbsp;').'">'.((isset($v[$k2])) ? mb_strimwidth($v[$k2],0,36,'...') : '&nbsp;').'</a></td>';
                            }else if($k2=='submit_ip'){
                              	if(isset($v['ip_area']) && $v['ip_area']){
                                	echo '<td class="gd-xs-hide '.cf7d_admin_get_field_name($v2).'" data-head="'.cf7d_admin_get_field_name($v2).'">'.((isset($v[$k2])) ? $v['ip_area'].'('.$v[$k2].')' : '&nbsp;').'</td>';
                                }else{
                                  	$ip_area = get_ip_from_taobaoapi($v[$k2]);
                                  	$wpdb->query($wpdb->prepare('INSERT INTO  wp_cf7_data_entry(`cf7_id`, `data_id`, `name`, `value`) VALUES (%d,%d,%s,%s)', 19, $k, 'ip_area', $ip_area));
                                	echo '<td class="gd-xs-hide '.cf7d_admin_get_field_name($v2).'" data-head="'.cf7d_admin_get_field_name($v2).'">'.((isset($v[$k2])) ? $ip_area.'('.$v[$k2].')' : '&nbsp;').'</td>';
                                }	
							}else if($k2=='Email'){
								if(isset($v[$k2])){
									$img_twitter="/wp-content/plugins/contact-form-7/images/comment_twitter_no.png";
									if($res->color=="red"){
										$img_twitter="/wp-content/plugins/contact-form-7/images/comment_twitter.png";
									}
								}
								
	 							echo '<td class="'.cf7d_admin_get_field_name($v2).'" data-head="'.cf7d_admin_get_field_name($v2).'">'.((isset($v[$k2])) ? $v[$k2] : '&nbsp;').'</td>';
							}else if($k2=='readed'){
	 							echo '<td class="gd-xs-hide '.cf7d_admin_get_field_name($v2).'" data-head="'.cf7d_admin_get_field_name($v2).'">'.(($v[$k2]==1) ? "已读(SEO)" : "未读(SEO)").'</td>';
							}else if( $v2!='询盘发送时间' &&  $v2!='邮箱(Email)'){
                                echo '<td class="manage-column gd-xs-hide '.cf7d_admin_get_field_name($v2).'" data-head="'.cf7d_admin_get_field_name($v2).'">'.((isset($v[$k2])) ? $v[$k2] : '&nbsp;').'</td>';
                            }else{
                                echo '<td class="'.cf7d_admin_get_field_name($v2).'" data-head="'.cf7d_admin_get_field_name($v2).'">'.((isset($v[$k2])) ? $v[$k2] : '&nbsp;').'</td>';
                            }
                        }
                        $row_id = $k;
                        do_action('cf7d_admin_after_body_field', $fid, $row_id);
                        echo '</tr>';
                    }
                    ?>
                </tbody>
                <tfoot>
                    <tr>
                        <?php
                        echo '<th class="manage-column column-cb check-column"><input type="checkbox" id="cb-select-all-2" /></th>';
                        foreach ($fields as $k => $v) {
                          	if($k == 'ip_area'){continue;}
                            if($k=='readed'){
                                echo '<th class="manage-column gd-xs-hide" data-key="'.$v.'">是否已读</th>';
                            }else if($k=='submit_ip'){
                            	echo '<th class="manage-column gd-xs-hide" data-key="'.$v.'">访客国家(IP)</th>';
                            }
                            else if($v!='询盘发送时间' && $v!='邮箱(Email)'){
                            echo '<th class="manage-column gd-xs-hide '.$v.'" data-key="'.$v.'">'.cf7d_admin_get_field_name($v).'</th>';
                            }
                            else{
                                echo '<th class="manage-column '.$v.'" data-key="'.$v.'">'.cf7d_admin_get_field_name($v).'</th>';
                            }
                        }
                        ?>
                        <?php do_action('cf7d_admin_after_heading_field'); ?>
                    </tr>
                </tfoot>
            </table>
            <div class="tablenav bottom">
                <div class="alignleft actions bulkactions">
                    <label for="bulk-action-selector-bottom" class="screen-reader-text"><?php _e('Select bulk action'); ?></label>
                    <select name="action2" id="bulk-action-selector-bottom">
                        <option value="-1"><?php _e('Bulk Actions'); ?></option>
                        <?php echo cf7d_arr_to_option($entry_actions); ?>
                    </select>
                    <input id="doaction2" class="button action" value="<?php _e('Apply'); ?>" type="submit" name="btn_apply2" />
                </div>
                <div class="tablenav-pages">
                    <span class="displaying-num"><?php echo (($total == 1) ?
                    '1 ' . __('item') :
                    $total . ' ' . __('items')) ?></span>
					<span class="pagination-links">
                        <?php
                        echo paginate_links(array(
                            'base' => add_query_arg('cpage', '%#%'),
                            'format' => '',
                            'prev_text' => __('&laquo;'),
                            'next_text' => __('&raquo;'),
                            'total' => ceil($total / $items_per_page),
                            'current' => $page
                        ));
                        ?>
                    </span>
                </div>
                <br class="clear">
            </div> 			
        </form>
        <form method="post" action="" style="display:none;">
			<div id="" class="">
			    <h3>Google统计转换代码Js</h3>
			    <table width="100%">
			    <tr>
					<th width="180">开启代码执行</th>
					<td><input type="radio" name="google_js[open]" value="1" <?php if($google_js['open']==1) echo"checked";?>>开启<input type="radio" name="google_js[open]" value="1" <?php if($google_js['open']==0||!$google_js['open']) echo"checked";?>>关闭</td>
			    </tr>
				<tr>
					<th width="180">全局代码</th>
					<td><textarea name="google_js[global]" rows="8" style="width:100%"><?php echo  stripslashes($google_js['global']);?></textarea></td>
			    </tr>
				<tr>
					<th>事件代码</th>
					<td><textarea name="google_js[run]" rows="8" style="width:100%"><?php echo  stripslashes($google_js['run']);?></textarea></td>
			    </tr>
			    </table>
				<input type="submit" name="sbt_google_js" onclick="" value="保存"  >
			</div>
        </form>
        <?php do_action('cf7d_after_admin_form', $fid); ?>        
        <?php
    } else {
        if ($first_form_id > 0 && !(isset($_GET['action'])) && !(isset($_GET['action2']))) {
            ?>
            <script>
            location.replace('<?php echo admin_url("admin.php?page=cf7-data&fid=" . $first_form_id); ?>');
            </script>
            <?php
        }
    }
    echo '</div>';
}

function get_ip_from_taobaoapi($ip){
	$country = file_get_contents("http://ip.globalso.com/?ip=".$ip);
    if($country){
      	return $country;
    }else{
      	return "未知";
    }	
}

function request_post($url = '', $param = '') {
        if (empty($url) || empty($param)) {
            return false;
        }
        
        $postUrl = $url;
        $curlPost = $param;
        $ch = curl_init();//初始化curl
        curl_setopt($ch, CURLOPT_URL,$postUrl);//抓取指定网页
        curl_setopt($ch, CURLOPT_HEADER, 0);//设置header
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);//要求结果为字符串且输出到屏幕上
        curl_setopt($ch, CURLOPT_POST, 1);//post提交方式
        curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPost);
        $data = curl_exec($ch);//运行curl
        curl_close($ch);
        
        return $data;
    }


function cf7d_form_action_callback()
{
    global $wpdb;
    if ($current_action = cf7d_current_action()) {
        if ($current_action == 'delete') {
            if (isset($_GET['del_id'])) {
                $del_id = implode(',', $_GET['del_id']);
                $fid = (int)$_GET['fid'];
                $wpdb->query("DELETE FROM {$wpdb->prefix}cf7_data_entry WHERE data_id IN($del_id)");
                $wpdb->query("DELETE FROM {$wpdb->prefix}cf7_data WHERE id IN($del_id)");
                wp_safe_redirect(admin_url('admin.php?page=cf7-data&fid=' . $fid));
                exit();
            }
        }
        do_action('cf7d_entry_action', $current_action);
    }
    do_action('cf7d_main_post');
}
function cf7d_current_action()
{
    $current_action = false;
    if (isset($_REQUEST['action']) && -1 != $_REQUEST['action'] && isset($_GET['btn_apply'])) {
        $current_action = $_REQUEST['action'];
        return apply_filters('cf7d_get_current_action', $current_action);
    }

    if (isset($_REQUEST['action2']) && -1 != $_REQUEST['action2'] && isset($_GET['btn_apply2'])) {
        $current_action = $_REQUEST['action2'];
        return apply_filters('cf7d_get_current_action', $current_action);
    }
    $current_action = apply_filters('cf7d_get_current_action', $current_action);
    return false;
}
