<?php
wp_nonce_field('b2s_security_nonce', 'b2s_security_nonce');
require_once B2S_PLUGIN_DIR . 'includes/B2S/Network/Item.php';
$b2sSiteUrl = get_option('siteurl') . ((substr(get_option('siteurl'), -1, 1) == '/') ? '' : '/');
$displayName = stripslashes(get_user_by('id', B2S_PLUGIN_BLOG_USER_ID)->display_name);
$displayName = ((empty($displayName) || $displayName == false) ? __("Unknown username", "blog2social") : $displayName);
$networkItem = new B2S_Network_Item();
$networkData = $networkItem->getData();
?>

<div class="b2s-container">
    <div class=" b2s-inbox col-md-12 del-padding-left">
        <!--<div class="col-md-9 del-padding-left del-padding-right">-->
            <!--Header|Start - Include-->
            <?php require_once (B2S_PLUGIN_DIR . 'views/b2s/html/header.php'); ?>
            <!--Header|End-->
            <div class="clearfix"></div>
            <!--Content|Start-->
            <div class="panel panel-default">
                <div class="panel-body">
                    <div class="col-md-12">
                        <div class="b2s-post">
                            <div class="grid-body">
                                <div class="hidden-lg hidden-md hidden-sm filterShow"><a href="#" onclick="showFilter('show');return false;"><i class="glyphicon glyphicon-chevron-down"></i> <?php esc_html_e('filter', 'blog2social') ?></a></div>
                                <div class="hidden-lg hidden-md hidden-sm filterHide"><a href="#" onclick="showFilter('hide');return false;"><i class="glyphicon glyphicon-chevron-up"></i> <?php esc_html_e('filter', 'blog2social') ?></a></div>
                                <div class="form-inline" role="form">
                                    <?php echo $networkItem->getSelectMandantHtml($networkData['mandanten']); ?>
                                    <div class="form-group b2s-network-mandant-area">
                                        <?php if (B2S_PLUGIN_USER_VERSION > 1) { ?>
                                            <button href="#" class="btn btn-primary btn-sm b2s-network-add-mandant-btn">
                                                <span class="glyphicon glyphicon-plus"></span> <?php esc_html_e('创建新组', 'blog2social') ?> <span class="label label-success"></button>
                                        <?php } else { ?>
                                            <button href="#" class="btn btn-primary btn-sm b2s-btn-disabled b2sProFeatureModalBtn" data-type="create-network-profile" data-title="<?php esc_html_e('You want to define a new combination of networks?', 'blog2social') ?>">
                                                <span class="glyphicon glyphicon-plus"></span> <?php esc_html_e('创建新组', 'blog2social') ?> <span class="label label-success"> <?php esc_html_e("PRO", "blog2social") ?></span></button>
                                        <?php } ?>

                                        <button href="#" class="btn btn-danger btn-sm b2s-network-mandant-btn-delete" style="display:none;">
                                            <span class="glyphicon glyphicon-trash"></span> <?php esc_html_e('Delete', 'blog2social') ?>
                                        </button>
                                    </div>
                                    <!--<div class="form-group b2s-network-time-manager-area pull-right hidden-xs">
                                        <?php if (B2S_PLUGIN_USER_VERSION > 0) { ?>
                                            <a href="#" class="btn btn-primary btn-sm b2s-get-settings-sched-time-default">
                                            <?php } else { ?>
                                                <a href="#" class="btn btn-primary btn-sm b2s-btn-disabled" data-title = "<?php esc_html_e('You want to schedule your posts and use the Best Time Scheduler?', 'blog2social') ?>" data-toggle ="modal" data-target ="#b2sInfoSchedTimesModal">
                                                <?php } ?>  <span class="glyphicon glyphicon-time"></span> <?php esc_html_e('Load Best Times', 'blog2social'); ?></a>
                                    </div>-->
                                </div>
                                <br>
                            </div>
                        </div>
                        <div class="row b2s-network-auth-area">
                            <?php echo $networkItem->getPortale($networkData['mandanten'], $networkData['auth'], $networkData['portale'], $networkData['auth_count']); ?>
                        </div>
                        <div class="row b2s-loading-area width-100" style="display: none">
                            <div class="b2s-loader-impulse b2s-loader-impulse-md"></div>
                            <div class="clearfix"></div>
                            <?php esc_html_e('Loading...', 'blog2social') ?>
                        </div>
                        <?php
                        $noLegend = 1;
                        require_once (B2S_PLUGIN_DIR . 'views/b2s/html/footer.php');
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <?php require_once (B2S_PLUGIN_DIR . 'views/b2s/html/sidebar.php'); ?>
    </div>
</div>
<input type="hidden" id="lang" value="<?php echo substr(B2S_LANGUAGE, 0, 2); ?>">

<div class="modal fade" id="b2s-network-add-mandant" tabindex="-1" role="dialog" aria-labelledby="b2s-network-add-mandant" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="b2s-modal-close close" data-modal-name="#b2s-network-add-mandant" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"> <?php esc_html_e('创建新组', 'blog2social') ?></h4>
            </div>
            <div class="modal-body">
                <div class="input-group">
                    <input type="text" class="form-control b2s-network-add-mandant-input" placeholder="Profil">
                    <span class="input-group-btn">
                        <button class="btn btn-success b2s-network-add-mandant-btn-save" type="button"><?php esc_html_e('create', 'blog2social') ?></button>
                    </span>
                    <div class="input-group-btn">
                        <div class="btn btn-default b2s-network-add-mandant-btn-loading b2s-loader-impulse b2s-loader-impulse-sm" style="display:none"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="b2s-network-delete-mandant" tabindex="-1" role="dialog"  aria-labelledby="b2s-network-delete-mandant" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="b2s-modal-close close" data-modal-name="#b2s-network-delete-mandant" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"><?php esc_html_e('Delete Profile', 'blog2social') ?></h4>
            </div>
            <div class="modal-body">
                <?php esc_html_e('Do you really want to delete this profile', 'blog2social') ?>?
            </div>
            <div class="modal-footer">
                <button class="btn btn-sm btn-default" data-dismiss="modal"><?php esc_html_e('NO', 'blog2social') ?></button>
                <button class="btn btn-sm btn-danger b2s-btn-network-delete-mandant-confirm"><?php esc_html_e('YES, delete', 'blog2social') ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="b2sInfoNetwork18" tabindex="-1" role="dialog"  aria-labelledby="b2sInfoNetwork18" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="b2s-modal-close close" data-modal-name="#b2sInfoNetwork18" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"><?php esc_html_e('Google My Business', 'blog2social') ?></h4>
            </div>
            <div class="modal-body">
                <?php esc_html_e('Blog2Social uses the official Google My Business API to share your content on your business listing. You can connect Google My Business listings with up to nine different locations to Blog2Social and you can choose which location you want to share your content on.', 'blog2social'); ?>
                <br>
                <br>
                <?php esc_html_e('Google currently allows access to the API for all companies with up to 9 locations in their Google My Business Listings. However, Google plans to extend the API for companies with more than 9 locations in their Google My Business listings.', 'blog2social'); ?>
                <br>
                <br>
                <a href="https://developers.google.com/my-business/content/posts-data#faqs" target="_blank"><?php esc_html_e('Learn more', 'blog2social'); ?></a>
            </div>
        </div>
    </div>
</div>



<div class="modal fade" id="b2s-network-delete-auth" tabindex="-1" role="dialog" aria-labelledby="b2s-network-delete-auth" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="b2s-modal-close close" data-modal-name="#b2s-network-delete-auth" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"><?php esc_html_e('Delete Authorization', 'blog2social') ?></h4>
            </div>
            <div class="row b2s-loading-area width-100">
                <br>
                <div class="b2s-loader-impulse b2s-loader-impulse-md"></div>
                <div class="clearfix"></div>
                <?php esc_html_e('Loading...', 'blog2social') ?>
            </div>
            <div class="modal-body b2s-btn-network-delete-auth-confirm-text">
                <?php esc_html_e('Do you really want to delete this authorization', 'blog2social') ?>!
            </div>
            <div class="modal-body b2s-btn-network-delete-auth-show-post-text">
                <p class="b2s-btn-network-delete-sched-text" style="display: none;"><?php esc_html_e('You have still set up scheduled posts for this network:', 'blog2social'); ?></p>
                <p class="b2s-btn-network-delete-assign-text" style="display: none;"><?php esc_html_e('This network connection is still assigned to other users.', 'blog2social'); ?></p>
                <p class="b2s-btn-network-delete-assign-sched-text" style="display: none;"><?php esc_html_e('The user to whom the connection is assigned still has scheduled posts.', 'blog2social'); ?></p>
                <p><input type="checkbox" value="0" id="b2s-delete-network-sched-post"></p>
                <ul class="b2s-btn-network-delete-list">
                    <li class="b2s-btn-network-delete-sched-text" style="display: none;"><?php esc_html_e('Delete all scheduled posts for this account irrevocably', 'blog2social') ?> (<span id="b2s-btn-network-delete-auth-show-post-count"></span> <?php esc_html_e('scheduled posts', 'blog2social') ?>)</li>
                    <li class="b2s-btn-network-delete-assign-text" style="display: none;"><?php esc_html_e('The connection is still assigned to other users. Please withdraw the assigned connection from other users first.', 'blog2social'); ?></li>
                    <li class="b2s-btn-network-delete-assign-sched-text" style="display: none;"><?php esc_html_e('Delete all scheduled posts from all user who use this connection.', 'blog2social'); ?></li>
                </ul>
            </div>
            <div class="modal-footer">
                <input type="hidden" value="" id="b2s-delete-network-auth-id">
                <input type="hidden" value="" id="b2s-delete-network-id">
                <input type="hidden" value="" id="b2s-delete-network-type">
                <input type="hidden" value="" id="b2s-delete-assign-network-auth-id">
                <input type="hidden" value="" id="b2s-delete-blog-user-id">
                <input type="hidden" value="" id="b2s-delete-assignment">
                <input type="hidden" value="" id="b2s-delete-assign-list">
                <button class="btn btn-sm btn-danger b2s-btn-network-delete-auth-confirm-btn"><?php esc_html_e('YES, delete', 'blog2social') ?></button>
                <button class="btn btn-sm btn-success b2s-btn-network-delete-auth-show-post-btn"><?php esc_html_e('View schedule posts', 'blog2social') ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="b2s-modify-board-and-group-network-modal" tabindex="-1" role="dialog" aria-labelledby="b2s-modify-board-and-group-network-modal" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="b2s-modal-close close" data-modal-name="#b2s-modify-board-and-group-network-modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="b2s-modify-board-and-group-network-modal-title" class="modal-title"></h4>
            </div>
            <div class="row b2s-modify-board-and-group-network-loading-area width-100">
                <br>
                <div class="b2s-loader-impulse b2s-loader-impulse-md"></div>
            </div>
            <br>
            <div class="col-md-12">
                <div id="b2s-modify-board-and-group-network-no-data"><div class="alert alert-danger"><span class="glyphicon glyphicon-remove glyphicon-danger"></span> <?php esc_html_e('Please re-authorize your account with Blog2Social and try again', 'blog2social'); ?></div></div>
                <div id="b2s-modify-board-and-group-network-save-success"><div class="alert alert-success"><span class="glyphicon glyphicon-ok glyphicon-success"></span> <?php esc_html_e('Change successful', 'blog2social'); ?></div></div>
                <div id="b2s-modify-board-and-group-network-save-error"><div class="alert alert-danger"><span class="glyphicon glyphicon-remove glyphicon-danger"></span> <?php esc_html_e('Could not be changed', 'blog2social'); ?></div></div>
            </div>
            <div class="b2s-modify-board-and-group-network-data col-md-12"></div>
            <div class="modal-footer b2s-modify-board-and-group-network-modal-footer">
                <input type="hidden" value="" id="b2s-modify-board-and-group-network-auth-id">
                <input type="hidden" value="" id="b2s-modify-board-and-group-network-id">
                <input type="hidden" value="" id="b2s-modify-board-and-group-network-type">
                <input type="hidden" value="" id="b2s-modify-board-and-group-name">
                <button class="btn btn-sm btn-success b2s-modify-board-and-group-network-save-btn"><?php esc_html_e('modfiy', 'blog2social') ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="b2s-manage-auth-team-modal" tabindex="-1" role="dialog" aria-labelledby="b2s-manage-auth-team-modal" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="b2s-modal-close close" data-modal-name="#b2s-manage-auth-team-modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="b2s-manage-auth-team-modal-title" class="modal-title"><?php
                    esc_html_e("更换账号分组", "blog2social");
                    if (B2S_PLUGIN_USER_VERSION < 3) {
                        echo ' <span class="label label-success">BUSINESS</span>';
                    }
                    ?></h4>
            </div>
            <div class="row b2s-loading-area-manage-auth-team-modal width-100" style="display: none;">
                <br>
                <div class="b2s-loader-impulse b2s-loader-impulse-md"></div>
                <div class="clearfix"></div>
                <?php esc_html_e('Loading...', 'blog2social') ?>
            </div>
            <div class="modal-body">
                <?php if (B2S_PLUGIN_USER_VERSION >= 3) { ?>
                    <div class="b2s-move-connection" style="display: none;">
                        <div class="row">
                            <div class="col-md-12 b2s-text-bold">
                                <span><?php esc_html_e('移动到另一个组.', 'blog2social'); ?></span>
                            </div>
                        </div>
                        <div class="row" id="b2s-move-connection-failed" style="display: none;">
                            <div class="col-md-12">
                                <div class="alert alert-danger"><?php esc_html_e("An error occured. Please contact our support.", 'blog2social'); ?></div>
                            </div>
                        </div>
                        <div class="row b2s-margin-top-8" id="b2s-move-connection-input">
                            <div class="col-md-8">
                                <select class="form-control b2s-select" id="b2s-move-connection-select"></select>
                            </div>
                            <div class="col-md-4"><button class="btn btn-primary btn-sm" id="b2s-move-user-auth-to-profile"><?php esc_html_e('move', 'blog2social'); ?></button></div>
                            <input type="hidden" value="" id="b2sUserAuthId">
                            <input type="hidden" value="" id="b2sOldMandantId">
                            <input type="hidden" value="" id="b2sNetworkId">
                            <input type="hidden" value="" id="b2sNetworkType">
                        </div>
                        <div class="row b2s-margin-top-8" id="b2s-move-connection-error" style="display: none;">
                            <div class="col-md-12">
                                <div class="alert alert-warning"><?php esc_html_e('You need at least one network collection', 'blog2social'); ?></div>
                            </div>
                        </div>
                    </div>
                    
                <?php } else { ?>
                    <div class="alert alert-info">
                        <?php esc_html_e('Upgrade to Blog2Social Business to easily bundle your connections into network collection and assign your social media connections to other blog users. You can update and delete the connections as well as select forums or boards. Other users will be able to use the social media connection you assigned to them to post and schedule to your social media profile, page or group.', 'blog2social'); ?>
                        <a target="_blank" href="<?php echo esc_url(B2S_Tools::getSupportLink('affiliate')); ?>" class="b2s-bold b2s-text-underline"><?php esc_html_e('Upgrade to Blog2Social Business', 'blog2social'); ?></a>
                    </div>
                    <div class="b2s-btn-disabled">
                        <div class="b2s-move-connection">
                            <div class="row">
                                <div class="col-md-12 b2s-text-bold">
                                    <span><?php esc_html_e('移动到另一个组.', 'blog2social'); ?></span>
                                </div>
                            </div>
                            <div class="row b2s-margin-top-8" id="b2s-move-connection-input">
                                <div class="col-md-8">
                                    <select class="form-control b2s-select"><option><?php esc_html_e('My Profile', 'blog2social'); ?></option></select>
                                </div>
                                <div class="col-md-4"><button class="btn btn-primary btn-sm"><?php esc_html_e('移动', 'blog2social'); ?></button></div>
                            </div>
                        </div>
                        <div class="row b2s-connection-assign">
                            <br>
                            <hr>
                            <div class="col-md-12 b2s-margin-bottom-8 b2s-text-bold">
                                <span><?php esc_html_e('Assign the connection to other blog users', 'blog2social'); ?></span>
                            </div>
                            <div class="col-md-8"><select class="form-control b2s-select"><option><?php echo esc_html($displayName); ?></option></select></div>
                            <div class="col-md-4"><button class="btn btn-primary btn-sm"><?php esc_html_e('assign', 'blog2social'); ?></button></div>
                        </div>
                    </div>
                <?php } ?>
            </div>
            <div class="modal-footer b2s-manage-auth-team-modal-footer"></div>
        </div>
    </div>
</div>

<div class="modal fade" id="b2s-edit-template" tabindex="-1" role="dialog" aria-labelledby="b2s-edit-template" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="b2s-modal-close close" data-modal-name="#b2s-edit-template" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <img class="pull-left hidden-xs b2s-img-network b2s-edit-template-network-img" id="b2s-edit-template-network-img-1" alt="Facebook" src="<?php echo plugins_url('/assets/images/portale/1_flat.png', B2S_PLUGIN_FILE); ?>" style="display: none;">
                <img class="pull-left hidden-xs b2s-img-network b2s-edit-template-network-img" id="b2s-edit-template-network-img-2" alt="Twitter" src="<?php echo plugins_url('/assets/images/portale/2_flat.png', B2S_PLUGIN_FILE); ?>" style="display: none;">
                <img class="pull-left hidden-xs b2s-img-network b2s-edit-template-network-img" id="b2s-edit-template-network-img-3" alt="LinkedIn" src="<?php echo plugins_url('/assets/images/portale/3_flat.png', B2S_PLUGIN_FILE); ?>" style="display: none;">
                <img class="pull-left hidden-xs b2s-img-network b2s-edit-template-network-img" id="b2s-edit-template-network-img-12" alt="Instagram" src="<?php echo plugins_url('/assets/images/portale/12_flat.png', B2S_PLUGIN_FILE); ?>" style="display: none;">
                <h4 class="modal-title b2s-edit-template-title"><?php esc_html_e('Edit Post Template', 'blog2social') ?></h4> <?php echo ((B2S_PLUGIN_USER_VERSION == 0) ? '<span class="label label-success">'.esc_html__('SMART', 'blog2social').'</span>' : '') ?>
            </div>
            <div class="row b2s-loading-area width-100">
                <br>
                <div class="b2s-loader-impulse b2s-loader-impulse-md"></div>
                <div class="clearfix"></div>
                <?php esc_html_e('Loading...', 'blog2social') ?>
            </div>
            <div class="modal-body b2s-edit-template-content">

            </div>
            <div class="modal-footer b2s-edit-template-footer">
                <button class="btn btn-primary btn-sm b2s-edit-template-save-btn"><?php esc_html_e('save', 'blog2social'); ?></button>
                <input type="hidden" value="" id="b2s-edit-template-network-id">
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="b2sInfoNoCache" tabindex="-1" role="dialog" aria-labelledby="b2sInfoNoCache" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="b2s-modal-close close" data-modal-name="#b2sInfoNoCache" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"><?php esc_html_e('Instant Caching for Facebook Link Posts', 'blog2social') ?></h4>
            </div>
            <div class="modal-body">
                <?php esc_html_e('Please enable this feature, if you are using varnish caching (HTTP accelerator to relieve your website). Blog2Social will add a "no-cache=1" parameter to the post URL of your Facebook link posts to ensure that Facebook always pulls the current meta data of your blog post.', 'blog2social') ?>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="b2sInfoFormat" tabindex="-1" role="dialog" aria-labelledby="b2sInfoFormat" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="b2s-modal-close close" data-modal-name="#b2sInfoFormat" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"><?php esc_html_e('Choose your Post Format', 'blog2social') ?></h4>
            </div>
            <div class="modal-body">
                <div class="b2sInfoFormatText" data-network-id="1">
                    <?php esc_html_e('Decide in which post format you want to post your content: Link post or image post.', 'blog2social') ?>
                </div>
                <div class="b2sInfoFormatText" data-network-id="2">
                    <?php esc_html_e('Decide in which post format you want to post your content: Link post or image post.', 'blog2social') ?>
                </div>
                <div class="b2sInfoFormatText" data-network-id="3">
                    <?php esc_html_e('Decide in which post format you want to post your content: Link post or image post.', 'blog2social') ?>
                </div>
                <div class="b2sInfoFormatText" data-network-id="12">
                    <?php esc_html_e('Decide in wich form you want to post your Content. Either as image with frame, or as image cut out.', 'blog2social') ?>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="b2sInfoContent" tabindex="-1" role="dialog" aria-labelledby="b2sInfoContent" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="b2s-modal-close close" data-modal-name="#b2sInfoContent" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"><?php esc_html_e('Post Content', 'blog2social') ?></h4>
            </div>
            <div class="modal-body">
                <?php esc_html_e('Edit the content of your post. Move elements by drag and drop into the textarea and customize them as you like.', 'blog2social') ?>
                <div class="b2s-template-placeholder-legend">
                    <br/>  
                    <p class="b2s-bold"><?php esc_html_e('Legend', 'blog2social'); ?>:</p>
                    <p>
                        <span class="b2s-bold">{TITLE}</span> - <?php esc_html_e('The title of your post', 'blog2social') ?> <br>
                        <span class="b2s-bold">{EXCERPT}</span> - <?php esc_html_e('The summary of your post (you define it in the side menu of your post).', 'blog2social') ?> <br>
                        <span class="b2s-bold">{CONTENT}</span> - <?php esc_html_e('The content of your post', 'blog2social') ?> <br>
                        <span class="b2s-bold">{KEYWORDS}</span> - <?php esc_html_e('The tags you have set in your post.', 'blog2social') ?> <br>
                        <span class="b2s-bold">{AUTHOR}</span> - <?php esc_html_e('The name of the post author.', 'blog2social') ?> <br>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="b2sInfoCharacterLimit" tabindex="-1" role="dialog" aria-labelledby="b2sInfoCharacterLimit" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="b2s-modal-close close" data-modal-name="#b2sInfoCharacterLimit" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"><?php esc_html_e('Character limit', 'blog2social') ?> (CONTENT, EXCERPT)</h4>
            </div>
            <div class="modal-body">
                <div class="b2s-info-character-limit-text"><?php esc_html_e('Define the character limit for the variables "EXCERPT" and "CONTENT" individually. Your text will be shortened after the last comma, period, or space character within your character limit.', 'blog2social') ?></div>
                <div class="b2s-info-character-limit-text"><?php esc_html_e('An "EXCERPT" will only be added to your social media post if you have added a manual excerpt in the excerpt editing box of the Gutenberg side menu (document settings) of your post.', 'blog2social') ?></div>
                <div class="b2s-info-character-limit-text"><?php esc_html_e('"TITLES" and "KEYWORDS" (Hashtags) are not shortened. If you select the "TITLE" and "KEYWORD" variables for your social media posts, the character limit you define for the "EXCERPT" and/or "CONTENT" variables will be applied within the remaining available character limit of the social network.', 'blog2social') ?></div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="b2sAuthNetwork6Modal" tabindex="-1" role="dialog" aria-labelledby="b2sAuthNetwork6Modal" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="b2s-modal-close close" data-modal-name="#b2sAuthNetwork6Modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"><?php esc_html_e('Connect with Pinterest', 'blog2social') ?></h4>
            </div>
            <div class="row b2s-loading-area width-100" style="display: none">
                <div class="b2s-loader-impulse b2s-loader-impulse-md"></div>
                <div class="clearfix"></div>
                <?php esc_html_e('Loading...', 'blog2social') ?>
            </div>
            <div class="modal-body b2s-auth-network-6-login-area">
                <div class="alert alert-info"><?php esc_html_e('Please make sure to use your original Pinterest login data (email and password). Social Login via Facebook or Google login data will not work here. Please also check if the two-factor authentication in Pinterest is deactivated to ensure a stable connection to Blog2Social.', 'blog2social'); ?></div>
                <div class="alert alert-danger b2s-auth-network-6-info" data-info="default" style="display:none;"><?php esc_html_e('An error occurred! Please try again.', 'blog2social'); ?></div>
                <div class="alert alert-danger b2s-auth-network-6-info" data-info="version" style="display:none;"><?php sprintf(__('You want to connect an additional account? <a target="_blank" href="%s">Upgrade to Blog2Social Premium</a>', 'blog2social'), B2S_Tools::getSupportLink('affiliate')); ?></div>
                <div class="alert alert-danger b2s-auth-network-6-info" data-info="limit" style="display:none;"><?php echo sprintf(__('You want to connect an additional account? <a target="_blank" href="%s">Upgrade to Blog2Social Premium</a>', 'blog2social'), B2S_Tools::getSupportLink('affiliate')); ?></div>
                <div class="alert alert-danger b2s-auth-network-6-info" data-info="invalid" style="display:none;"><?php esc_html_e('Invalid Data! Please try again.', 'blog2social'); ?></div>
                <div class="alert alert-danger b2s-auth-network-6-info" data-info="board" style="display:none;"><?php echo esc_html_e('You have not yet created any pinboards in your Pinterest account. Please set up at least one pinboard to pin on your Pinterest account!', 'blog2social'); ?></div>
                <div class="alert alert-danger b2s-auth-network-6-info" data-info="login" style="display:none;"><?php echo sprintf(__('Login failed. Please check your login data for typos and please check your Pinterest settings, if the two-factor authentication is turned off for this account: <a target="_blank" href="%s">%s</a>', 'blog2social'), esc_url('https://www.pinterest.com/settings/security/'), esc_url('https://www.pinterest.com/settings/security/')); ?></div>
                <div class="alert alert-danger b2s-auth-network-6-info" data-info="access" style="display:none;"><?php esc_html_e('Pinterest has rejected the connection to your blog', 'blog2social'); ?></div>
                <div class="alert alert-danger b2s-auth-network-6-info" data-info="http_request_failed" style="display:none;"><?php esc_html_e('Please select your currect server location and connect again', 'blog2social'); ?></div>
                <div class="alert alert-danger b2s-auth-network-6-info" data-info="error_code_403" style="display:none;"><?php esc_html_e('Access to this resource on your server is denied! Please check your webserver configuration for caching.', 'blog2social'); ?></div>
                <div class="alert alert-success b2s-auth-network-6-info" data-info="success" style="display:none;"><?php esc_html_e('Login up successful. Please confirm that Blog2Social is allowed to publish on your profile.', 'blog2social'); ?></div>
                <div class="form-group row">
                    <label class="col-md-3 b2s-login-form-label"><?php esc_html_e('E-Mail', 'blog2social'); ?></label>
                    <div class="col-md-9">
                        <input class="form-control username" required="true" type="text" placeholder="" id="b2s-auth-network-6-username" aria-required="true">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-3 b2s-login-form-label"><?php esc_html_e('Password', 'blog2social'); ?></label>
                    <div class="input-group col-md-9" style="padding-left: 15px; padding-right: 15px;">
                        <input class="form-control password" required="true" type="password" placeholder="" id="b2s-auth-network-6-password" aria-required="true">
                        <span class="input-group-btn">
                            <button class="btn btn-default b2s-auth-network-6-reveal" type="button">
                                <i class="glyphicon glyphicon-eye-open"></i>
                            </button>
                        </span>
                    </div>    
                </div>
                <div class="form-group row">
                    <label class="col-md-3 b2s-login-form-label"><?php esc_html_e('Server-Location', 'blog2social'); ?></label>
                    <div class="col-md-9" style="padding-left: 15px; padding-right: 15px;">
                        <select class="form-control" id="b2s-auth-network-6-location">
                            <?php
                            $pinterestCountryList = B2S_Tools::getCountryListByNetwork(6);
                            foreach ($pinterestCountryList as $key => $name){
                                echo '<option value="'.$key.'"'.(($key == '') ? ' selected="selected"' : '').'>'.$name['name'].'</option>';
                            }
                            ?>
                        </select>
                    </div>    
                </div>
                <div class="b2s-auth-network-6-board-area" style="display: none;">
                    <div class="form-group row">
                        <label class="col-md-3 b2s-login-form-label"><?php esc_html_e('Select Pinboard', 'blog2social'); ?></label>
                        <div class="col-md-9">
                            <select id="b2s-auth-network-6-board" class="form-control valid" aria-invalid="false"></select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer b2s-edit-template-footer">
                <button class="btn btn-success b2s-auth-network-6-login-btn" type="button"><?php esc_html_e('authorize', 'blog2social'); ?></button>
                <button class="btn btn-success b2s-auth-network-6-confirm-btn" type="button" style="display: none;"><?php esc_html_e('confirm', 'blog2social'); ?></button>
                <input type="hidden" id="b2s-auth-network-6-ident-data">
                <input type="hidden" id="b2s-auth-network-6-auth-id">
                <input type="hidden" id="b2s-auth-network-6-mandant-id">
            </div>
        </div>
    </div>
</div>

<input type="hidden" id="b2sUserLang" value="<?php echo substr(B2S_LANGUAGE, 0, 2); ?>">
<input type="hidden" id="b2sServerUrl" value="<?php echo B2S_PLUGIN_SERVER_URL; ?>">
<input type="hidden" id="b2sUserVersion" value="<?php echo B2S_PLUGIN_USER_VERSION; ?>">
<input type="hidden" id="b2s-redirect-url-sched-post" value="<?php echo $b2sSiteUrl . 'wp-admin/admin.php?page=blog2social-sched'; ?>"/>