<?php

require_once('./admin.php');

if ( ! current_user_can( 'manage_options' ) )
	wp_die( __( 'You do not have sufficient permissions to manage options for this site.' ) );

$title = __('General Settings');
$parent_file = 'options-general.php';
/* translators: date and time format for exact current time, mainly about timezones, see http://php.net/date */
$timezone_format = _x('Y-m-d G:i:s', 'timezone date format');

/**
 * Display JavaScript on the page.
 *
 * @since 3.5.0
 */
function options_general_add_js() {
?>
<script type="text/javascript">
//<![CDATA[
	jQuery(document).ready(function($){
		$("input[name='date_format']").click(function(){
			if ( "date_format_custom_radio" != $(this).attr("id") )
				$("input[name='date_format_custom']").val( $(this).val() ).siblings('.example').text( $(this).siblings('span').text() );
		});
		$("input[name='date_format_custom']").focus(function(){
			$("#date_format_custom_radio").attr("checked", "checked");
		});

		$("input[name='time_format']").click(function(){
			if ( "time_format_custom_radio" != $(this).attr("id") )
				$("input[name='time_format_custom']").val( $(this).val() ).siblings('.example').text( $(this).siblings('span').text() );
		});
		$("input[name='time_format_custom']").focus(function(){
			$("#time_format_custom_radio").attr("checked", "checked");
		});
		$("input[name='date_format_custom'], input[name='time_format_custom']").change( function() {
			var format = $(this);
			format.siblings('.spinner').css('display', 'inline-block'); // show(); can't be used here
			$.post(ajaxurl, {
					action: 'date_format_custom' == format.attr('name') ? 'date_format' : 'time_format',
					date : format.val()
				}, function(d) { format.siblings('.spinner').hide(); format.siblings('.example').text(d); } );
		});
	});
//]]>
</script>
<?php
}
add_action('admin_head', 'options_general_add_js');
include('./admin-header-notop.php');


?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<meta name="renderer" content="webkit|ie-comp|ie-stand">
<title>全球搜</title>
<meta name="viewport" content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no">
<meta name="format-detection" content="telephone=no">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black">
<link rel="stylesheet" href="//www.quanqiusou.cn/admin40/base.css">
<link rel="stylesheet" href="//www.quanqiusou.cn/admin40/global.css">
<link rel="stylesheet" href="//www.quanqiusou.cn/admin40/skin.css">
<!--[if lt IE 9]>
<script src="//www.quanqiusou.cn/admin40/js/html5.js"></script>
<script src="//www.quanqiusou.cn/admin40/js/respond.js"></script>
<![endif]-->
</head>



<body class="body-loading">

<?php

function google_api_to_array($apino) {
	$nowdate = date("Y-m-d"); 
	$startDate = date("Y-m-d",strtotime("-2 day"));
	$endDate = date("Y-m-d",strtotime("-1 day"));  //昨天
	$url = "http://www.quanqiusou.cn/google-rank/data_json/".$nowdate."/".$apino."_".$startDate."_".$endDate.".json";

	$json_data = @file_get_contents($url);
    $datas = json_decode($json_data, true);
	$k=A;
	$list_arr=array();
	if(is_array($datas)){	
		foreach($datas as $val){
			foreach($val as $key=>$v){
				if(is_array($v)){
					$s[$key][$k]['change']=intval($v['change']);
				    $s[$key][$k]['class']=$v['class'];
				    $s[$key][$k]['position']=intval($v['position']);
				}				
			}
			$k++;
			$list_arr=$s;
		}
	}
	return $list_arr;
}

$news_num = count(query_posts(array( 'post_type' => 'news','posts_per_page'=>-1)));
$wpcf7_contact = $wpdb->get_results("select count(*) as count from wp_cf7_data_entry where cf7_id=19 AND name ='Email'");
$wpcf7_contact_price = $wpdb->get_results("select count(*) as count from wp_cf7_data_entry where cf7_id=20 AND name ='Email'");
$wpcf7_contact_form_num = $wpcf7_contact[0]->count + $wpcf7_contact_price[0]->count;

$nowdate = date('Y-m-d');
$endDate = date("Y-m-d",strtotime("-1 day"));  //昨天
$info_api = get_post_meta(32,'api_id');
$apino = $info_api[0]; 
  //$apino = '3676604';
$rank_home_num = $rank_10days_num = $rank_all_num = $rank_third_num = 0;
$list_arr_d = google_api_to_array($apino);
if($list_arr_d){
	foreach($list_arr_d[$endDate] as $value){
		if(($value['position']<10||$value['position']==10)&&$value['position']>0){
			$rank_home_num++;
		}
      	if($value['position'] <= 30 && $value['position'] > 0){
			$rank_third_num++;
		}
		if(($value['position']<100||$value['position']==100)&&$value['position']>0){
			$rank_10days_num++;
		}
		$rank_all_num++;	
	}
}

?>

<div class="gd-wrap">


	<!-- 信息统计 -->
	<div class="gd-floor gd-info-panel">
		<section class="gd-info-item gd-info-item-1">
			<dl>
			<dt><i class="info-item-ico ico-count-pv"></i><span class="info-item-txt">今日浏览量(PV)</span></dt>
			<dd id="today_pv">0</dd>
			</dl>
		</section>
		<section class="gd-info-item gd-info-item-2">
			<dl>
			<dt><i class="info-item-ico ico-count-uv"></i><span class="info-item-txt">今日浏览量(IP)</span></dt>
			<dd id="today_ip">0</dd>
			</dl>
		</section>
		<section class="gd-info-item gd-info-item-3">
			<dl>
			<dt><i class="info-item-ico ico-count-inquiry"></i><span class="info-item-txt">精准询盘数量</span></dt>
			<dd><?php echo $wpcf7_contact_form_num;?></dd>
			</dl>
		</section>
		<section class="gd-info-item gd-info-item-4">
			<dl>
			<dt><i class="info-item-ico ico-count-num"></i><span class="info-item-txt">产品数量</span></dt>
			<dd><?php $count_posts = wp_count_posts(); echo $published_posts = $count_posts->publish;?></dd>
			</dl>
		</section>
		<section class="gd-info-item gd-info-item-5">
			<dl>
			<dt><i class="info-item-ico ico-count-other"></i><span class="info-item-txt">新闻数量</span></dt>
			<dd><?php echo $news_num;?></dd>
			</dl>
		</section>
	</div>


	<div class="gd-floor gd-floor-2">
		<div class="gd-layer">
		<div class="gd-row">
			<!-- 网站访问量统计 -->
			<section class="gd-col-3 gd-col-page-view">
			<div class="gd-panel">
				<header class="gd-panel-hd">
					<h2 class="panel-hd-tit">网站访问量统计</h2>
				</header>
				<div class="gd-panel-bd">
					<ul class="counter-list">
						<li class="counter-item">
							<div class="counter-label">共计浏览量</div>
							<div class="counter-num"><span class="num-value" id="total_pv">0</span><i>PV</i></div>
						</li>
						<li class="counter-item">
							<div class="counter-label">共计访客量</div>
							<div class="counter-num"><span class="num-value" id="total_ip">0</span><i>IP</i></div>
						</li>
						<li class="counter-item">
							<div class="counter-label">询盘转化率</div>
							<div class="counter-num"><span class="num-value" id="total_cf_f">0</span><i>%</i></div>
						</li>
					</ul>
				</div>
			</div>
			</section>


			<!-- 关键词排名数据 -->
			<section class="gd-col-3 gd-col-page-view">
			<div class="gd-panel">
				<header class="gd-panel-hd">
					<h2 class="panel-hd-tit">关键词排名数据（<?php echo date('Y-m-d',strtotime('-1 day'));?>）</h2>
				</header>
				<div class="gd-panel-bd">
					<ul class="counter-list">
						<li class="counter-item">
							<div class="counter-label">排名首页</div>
							<div class="counter-num"><span class="num-value" ><?php echo $rank_home_num;?></span><i>个</i></div>
						</li>
						<li class="counter-item">
							<div class="counter-label">排名前三页</div>
							<div class="counter-num"><span class="num-value" ><?php echo $rank_third_num;?></span><i>个</i></div>
						</li>
						<li class="counter-item">
							<div class="counter-label">排名前十页</div>
							<div class="counter-num"><span class="num-value" ><?php echo $rank_10days_num;?></span><i>个</i></div>
						</li>
					</ul>
				</div>
			</div>
			</section>

					<!-- 全球APP下载 -->
			<section class="gd-col-3 gd-col-app">
			<div class="gd-panel">
				<header class="gd-panel-hd">
					<h2 class="panel-hd-tit">全球搜APP下载</h2>
				</header>
				<div class="gd-panel-bd">
					<ul>
					<li class="app-qrcode-item">
						<span class="item-label">Android端扫描二维码下载</span>
						<div class="item-qrcode">
							<i class="sm-ico-qrcode"></i>
							<div class="qrcode-item-pop">
								<i class="ico-small-qrcode"></i>
								<div class="qrcode-box">
									<span class="pop-qrcode-img"><img src="//www.quanqiusou.cn/admin40/img/androidqrcode.jpg"></span>
									<span class="pop-qrcode-txt">请扫描以上二维码</span>
								</div>
							</div>
						</div>
					</li>
					<li class="app-qrcode-item">
						<span class="item-label">微信公众号可登录</span>
						<div class="item-qrcode">
							<i class="sm-ico-qrcode"></i>
							<div class="qrcode-item-pop">
								<i class="ico-small-qrcode"></i>
								<div class="qrcode-box">
									<span class="pop-qrcode-img"><img src="//www.quanqiusou.cn/admin40/img/qrcode.jpg"></span>
									<span class="pop-qrcode-txt">请扫描以上二维码</span>
								</div>
							</div>
						</div>
					</li>
					<li class="ios-app-tips">
						<h4>IOS端APP下载</h4>
						<p>苹果手机请登录APP Store搜索: “全球搜”</p>
					</li>
					</ul>
				</div>
			</div>
			</section>	
			<!-- 谷道科技技术服务中心 -->
			<section class="gd-col-3 gd-col-contact">
			<div class="gd-panel">
				<header class="gd-panel-hd">
					<h2 class="panel-hd-tit">全球搜 - 技术(售后)服务中心</h2>
				</header>
				<div class="gd-panel-bd">
					<ul class="gd-contact-info">
						<li><i class="ct-ico-company"></i>成都谷道科技有限公司(总部)</li>
						<li><i class="ct-ico-address"></i>成都市金牛区三泰魔方C2栋9层</li>
						<li><i class="ct-ico-tel"></i>028-87291080</li>
						<li><i class="ct-ico-tel"></i>4008625660</li>
						<li><i class="ct-ico-qq"></i>800025660</li>
					</ul>
				</div>
			</div>
			</section>

		</div>
		</div>
	</div>





	<div class="gd-floor gd-floor-3">
	<div class="gd-row">

		<!-- 一周访问统计 -->
		<section class="gd-col-5 week-count">
			<div class="gd-panel">
				<header class="gd-panel-hd">
					<h2 class="panel-hd-tit">一周访问统计</h2>
				</header>
				<div class="gd-panel-bd">
					<div class="chart-box">
						<div id="week-count-chart" class="graph" style="height:280px;"></div>
					</div>
				</div>
			</div>
		</section>

		<!-- 访客国家前十 -->
		<section class="gd-col-7 state-count">
			<div class="gd-panel">
				<header class="gd-panel-hd">
					<h2 class="panel-hd-tit">访客国家前十</h2>
				</header>
				<div class="gd-panel-bd">
					<div class="chart-box">
						<div id="state-count-chart" class="graph" style="height:280px;"></div>
					</div>
				</div>
			</div>
		</section>
	</div>
	</div>


	<!-- 最近访客明细 -->
	<div class="gd-floor gd-floor-4">
	<section class="gd-col-12 gd-col-new-promote">
	<div class="gd-row">
		<div class="gd-panel">
			<header class="gd-panel-hd">
				<h2 class="panel-hd-tit">最近访客明细</h2>
				<a href="index-uvmx.php" class="panel-hd-more">MORE</a>
				<a href="/wp-admin/index-uvmx.php?flg=show_spider" class="panel-hd-more">查看搜索引擎爬虫流量</a>
			</header>
			<div class="gd-table">
			<table>
				<thead>
					<tr>
						<th>浏览时间</th>
						<th>访客来源</th>
						<th>访问入路页面</th>
						<th>终端</th>
						<!--<th>用户</th>-->
						<th>访客IP</th>
						<th>地区</th>
						<th>访客深度(页)</th>
						<th class="align-center">询盘转化</th>
						<th class="align-center">访问详情</th>
					</tr>
				</thead>
				<tbody id="ip_list"></tbody>
			</table>
			</div>
		</div>
	</div>
	</section>
	</div>



	<!-- ========================= 访问详情弹窗 ========================= -->
	<div class="gd-pop pop-page-view">
	<a class="pop-close" href="javascript:" onclick="popHide('.pop-page-view')" title="关闭"></a>
	<div class="gd-pop-in">
		<h4 class="pop-sm-tit"><span id="pop_ip"></span> 访问明细</h4>
		<div class="pop-pv-cont">
			<dl class="pop-pv-hd">
				<dt>浏览时间</dt>
				<dd>访问页面</dd>
			</dl>
			<div class="pop-pv-list" id="pop_pv_list"></div>
		</div>
	</div>
	</div>
	<!--// 弹窗结束 -->


	




<script src="//www.quanqiusou.cn/admin40/js/jquery.min.js"></script>
<script src="//www.quanqiusou.cn/admin40/js/fastclick.js"></script>
<script src="//www.quanqiusou.cn/admin40/js/base.js"></script>

<!-- 轮播 -->
<script src="//www.quanqiusou.cn/admin40/js/owl.carousel.js"></script>
<script>
jQuery(function(){
	jQuery('.gd-slide-banner').owlCarousel({
		autoplay:false,
		loop:true,
		margin:0,
		dots:true,
		nav:false,
		smartSpeed:600,
		autoplaySpeed:600,
		autoplayTimeout:6000,
		autoplayHoverPause:true,
		lazyLoad: true,
		items:1,
		mouseDrag:false
	});
 });
</script>
<!-- 生成图表 -->
<script src="//www.quanqiusou.cn/admin40/js/highcharts.js"></script>
<script  language='JavaScript' charset='utf8' src="/wp-content/plugins/easyiit_stats/js/stats_data.js"></script>

<!-- 现代浏览器加载waves效果-->
<script>
function createWaveFile(){
	var waveFile = document.createElement('script');
	    waveFile.setAttribute('type', 'text/javascript');
	    waveFile.setAttribute('src', '//www.quanqiusou.cn/admin40/js/waves.min.js');
	    document.getElementsByTagName('head')[0].appendChild(waveFile);
}
var DEFAULT_VERSION = "9.0";
var ua = navigator.userAgent.toLowerCase();
var isIE = ua.indexOf("msie")>-1;
var safariVersion;
if(isIE){
    safariVersion =  ua.match(/msie ([\d.]+)/)[1];
    if(safariVersion > DEFAULT_VERSION ){ 
    	createWaveFile()
    }
}else{
	createWaveFile()
}
</script>



<style>
	.load-test{background-color: #fff;padding: 20px;margin-top: 20px;}
	.load-test p{padding-bottom: 15px;color:#aaa;}
	.load-test img{display: inline-block;width: 60px;height: 60px;padding: 1px;border: 1px solid #ddd;margin:0 10px 0 0;}
</style>


</div>
</body>
</html>