<?php
require_once('./admin.php');
if ( ! current_user_can( 'manage_options' ) )
	wp_die( __( 'You do not have sufficient permissions to manage options for this site.' ) );
$title = __('General Settings');
$parent_file = 'options-general.php';
/* translators: date and time format for exact current time, mainly about timezones, see http://php.net/date */
$timezone_format = _x('Y-m-d G:i:s', 'timezone date format');
/**
 * Display JavaScript on the page.
 *
 * @since 3.5.0
 */
function options_general_add_js() {
?>
<script type="text/javascript">
//<![CDATA[
	jQuery(document).ready(function($){
		$("input[name='date_format']").click(function(){
			if ( "date_format_custom_radio" != $(this).attr("id") )
				$("input[name='date_format_custom']").val( $(this).val() ).siblings('.example').text( $(this).siblings('span').text() );
		});
		$("input[name='date_format_custom']").focus(function(){
			$("#date_format_custom_radio").attr("checked", "checked");
		});
		$("input[name='time_format']").click(function(){
			if ( "time_format_custom_radio" != $(this).attr("id") )
				$("input[name='time_format_custom']").val( $(this).val() ).siblings('.example').text( $(this).siblings('span').text() );
		});
		$("input[name='time_format_custom']").focus(function(){
			$("#time_format_custom_radio").attr("checked", "checked");
		});
		$("input[name='date_format_custom'], input[name='time_format_custom']").change( function() {
			var format = $(this);
			format.siblings('.spinner').css('display', 'inline-block'); // show(); can't be used here
			$.post(ajaxurl, {
					action: 'date_format_custom' == format.attr('name') ? 'date_format' : 'time_format',
					date : format.val()
				}, function(d) { format.siblings('.spinner').hide(); format.siblings('.example').text(d); } );
		});
	});
//]]>
</script>
<?php
}
add_action('admin_head', 'options_general_add_js');
include('./admin-header.php');
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>全球搜 - 流量报表</title>
<meta name="viewport" content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no">
<meta name="format-detection" content="telephone=no">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black">
<link rel="stylesheet" href="//www.quanqiusou.cn/admin40/base.css">
<link rel="stylesheet" href="//www.quanqiusou.cn/admin40/global.css">
<link rel="stylesheet" href="//www.quanqiusou.cn/admin40/skin.css">
<!--[if lt IE 9]>
<script src="//www.quanqiusou.cn/admin40/js/html5.js"></script>
<script src="//www.quanqiusou.cn/admin40/js/respond.js"></script>
<![endif]-->
</head>
<body class="body-loading">
<div class="gd-wrap">
	
	<!-- 最近访问明细 -->
	<div class="gd-floor gd-floor-4">
	<section class="gd-col-12 gd-col-new-promote">
	<div class="gd-row">
		<div class="gd-panel">
			<header class="gd-panel-hd">
				<h2 class="panel-hd-tit">最近访问明细</h2>
				<?php if(isset($_GET['flg']) && $_GET['flg']){?>
					<a href="/wp-admin/index-uvmx.php" class="panel-hd-more">查看客户访问流量</a>
				<?php }else{?>
					<a href="/wp-admin/index-uvmx.php?flg=show_spider" class="panel-hd-more">查看搜索引擎爬虫流量</a>
					
				<?php }?>
			</header>
			<div class="gd-table">
			<table>
				<thead>
					<tr>
						<th>浏览时间</th>
						<th class="gd-xs-hide">访客来源</th>
						<th class="gd-xs-hide">访问入路页面</th>
						<th class="gd-xs-hide">终端</th>
						<!--<th class="gd-xs-hide">用户</th>-->
						<th class="gd-xs-hide">访客IP</th>
						<th>地区</th>
						<th>访客深度(页)</th>
						<th class="gd-xs-hide" class="align-center">询盘转化</th>
						<th class="align-center">访问详情</th>
					</tr>
				</thead>
<?php 
include_once(Easyiit_Stats_DIR."/class/page.class.php");	
$_pagesize=30;
$where = 'id>0 and is_spider=1';
if(isset($_GET['flg']) && $_GET['flg']){
	$where = 'id>0 and is_spider=0';
}
$all = $wpdb->get_row("select count(*) as total from wp_stats_day_ip where $where",ARRAY_A);
$_total = $all['total'];
$_pages = new Page($_total,$_pagesize);
$limit = $_pages->limit;
$wpdb->query("select * from wp_stats_day_ip where $where order by id desc limit $limit ",ARRAY_A);
$data = $wpdb->last_result;
?>
				<tbody>
				<?php foreach($data as $v){?>
					<tr>
						<td data-label="浏览时间"><div class="tb-txt"><?php echo date('Y-m-d H:i:s',$v->update);?></div></td>
						<td class="gd-xs-hide" data-label="访客来源"><div class="tb-txt site-url"><a target="_blank" href="<?php echo $v->referrer;?>"><?php echo $v->referrer;?></a></div></td>
						<td class="gd-xs-hide" data-label="访问入路页面"><div class="tb-txt site-url"><a target="_blank" href="<?php echo $v->request;?>"><?php echo $v->request;?></a></div></td>
						<td class="gd-xs-hide" data-label="终端"><div class="tb-txt"><?php echo $v->is_moblie?'移动端':'PC';?></div></td>
						<!--<td class="gd-xs-hide" data-label="用户"><div class="tb-txt"><?php echo $v->is_old_user?'新用户':'老用户';?></div></td>-->
						<td class="gd-xs-hide" data-label="访客IP"><div class="tb-txt"><?php echo $v->ip;?></div></td>
						<td data-label="地区"><div class="tb-txt"><?php if($v->ip_area == 'Unknown') echo '美国';else echo $v->ip_area;?></div></td>
						<td data-label="访客深度(页)"><div class="tb-txt"><?php echo $v->pv;?>页</div></td>
						<td class="gd-xs-hide" data-label="询盘转化" class="align-center"><div class="tb-txt"><?php if($v->is_cf){?><i class="sm-ico-tick-grey"></i><?php }?></div></td>
						<td data-label="访问详情" class="align-center"><div class="tb-txt"><a class="btn-view-detail" href="javascript:" onclick="show_detail('<?php echo $v->id;?>','<?php echo $v->ip;?>')">详情</a></div></td>
					</tr>
				<?php }?>
				</tbody>
			</table>
			</div>
			<!-- 分页 -->
			<div class="gd-pager">
				<?php echo $_pages->showpage();?>
			</div>
		</div>
	</div>
	</section>
	</div>
	<!-- ========================= 访问详情弹窗 ========================= -->
	<div class="gd-pop pop-page-view">
	<a class="pop-close" href="javascript:" onclick="popHide('.pop-page-view')" title="关闭"></a>
	<div class="gd-pop-in">
		<h4 class="pop-sm-tit"><span id="pop_ip"></span> 访问明细</h4>
		<div class="pop-pv-cont">
			<dl class="pop-pv-hd">
				<dt>浏览时间</dt>
				<dd>访问页面</dd>
			</dl>
			<div class="pop-pv-list" id="pop_pv_list"> </div>
		</div>
	</div>
	</div>
	<!--// 弹窗结束 -->
<script src="//www.quanqiusou.cn/admin40/js/jquery.min.js"></script>
<script src="//www.quanqiusou.cn/admin40/js/fastclick.js"></script>
<script src="//www.quanqiusou.cn/admin40/js/base.js"></script>
<!-- 现代浏览器加载waves效果-->
<script>
function createWaveFile(){
	var waveFile = document.createElement('script');
	    waveFile.setAttribute('type', 'text/javascript');
	    waveFile.setAttribute('src', '//www.quanqiusou.cn/admin40/js/waves.min.js');
	    document.getElementsByTagName('head')[0].appendChild(waveFile);
}
var DEFAULT_VERSION = "9.0";
var ua = navigator.userAgent.toLowerCase();
var isIE = ua.indexOf("msie")>-1;
var safariVersion;
if(isIE){
    safariVersion =  ua.match(/msie ([\d.]+)/)[1];
    if(safariVersion > DEFAULT_VERSION ){ 
    	createWaveFile()
    }
}else{
	createWaveFile()
}
function show_detail(id,ip){
	$('#pop_ip').html('');
	$('#pop_pv_list').html('');
	var html = '';
	$.get("/wp-admin/admin-ajax.php", { "action": "stats_get_ip_detail",id:id},
	   function(data){
		$.each(data, function(i,item){
			html += '<dl><dt>'+ item.time_str+'</dt><dd><a href="#">'+ item.request+ '</a></dd></dl>';
		  });
		  $('#pop_pv_list').html(html);
	}, "json");	
	$('#pop_ip').html(ip);
	popShow('.pop-page-view');
}
</script>
</div>
</body>
</html>