<?php
require_once('./wp-load.php');

global $wpdb;
//获取自定义分类url
function get_cate_zdy_url($cat_type = 'news',$per_page_num = 0,$has_parent = 1){
    $count_g = 0;
    $ar_show = ['news','project','aboutch','solutions','applications','download','video','service','blog','application','case','project-case'];
    $taxnomy = $cat_type.'_category';
    if(in_array($cat_type,$ar_show)){
        $taxnomy = $cat_type.'_catalog';
    }
    $arg = array(
        'taxonomy' => $taxnomy,
        'orderby' => 'name',
        'show_count' => 1,
        'pad_counts' => 0,
        'hierarchical' => 0
    );
    $ar_url = array();
    $categories = get_categories( $arg );
    if(isset($categories['errors'])){
        return $ar_url;
    }
    foreach($categories as $category){
        $categoryid = $category->term_id;
        $category_link = home_url("/").$cat_type.'-categories/'.$category->slug.'/';
        if(in_array($cat_type,$ar_show)){
            $category_link = home_url("/").$cat_type.'_catalog/'.$category->slug.'/';
        }
        $ar_url[] = $category_link;
        if($category->count > $per_page_num){
            $page_count = ceil($category->count/$per_page_num);
            for($i=2;$i<=$page_count;$i++){
                $ar_url[] = $category_link.'page/'.$i.'/';
            }
        }
        if($has_parent == 0){
            $count_g += $category->count;
        }
    }
    if($has_parent == 0){
        $ar_url[] = home_url("/").$cat_type.'/';
        $g_page_count = ceil($count_g/$per_page_num);
        for($i=2;$i<=$g_page_count;$i++){
            $ar_url[] = home_url("/").$cat_type.'/page/'.$i.'/';
        }
    }
    return $ar_url;
}
$except_post_type = ['3code','acf','admin','ad_img','attachment','banner','banner-sidebar','banner_sidebar','cf7_entry','dw_license','fl-builder-template','gd-admin','helppage','home','import_users','lianxi','nav_menu_item','p','pro','pro_detail','pro_shuxing','skype','sns','title','transall','v','wpcf7_contact_form','ww','post','page','revision','vs','wp_automatic'];
$post_types_res = $wpdb->get_results('select post_type from wp_posts group by post_type',ARRAY_A);
$post_types = [];
foreach ($post_types_res as $v){
    if(!in_array($v['post_type'],$except_post_type)){
        $post_types[] = $v['post_type'];
    }
}
$ar_url = array();
$ar_url[] = home_url("/");
$args = array(
    'hide_empty'  => 0
);

$categories = get_categories( $args );
$per_page_num = get_option('posts_per_page');
$cat_ids = array();
foreach($categories as $category){
    if($category->name != 'Featured' && $category->name != 'Featured Products'){
        $cat_ids[] = $category->term_id;
        $categoryid = $category->term_id;
        $category_link = get_category_link( $categoryid );
        $ar_url[] = $category_link;
        if($category->count > $per_page_num){
            $page_count = ceil($category->count/$per_page_num);
            for($i=2;$i<=$page_count;$i++){
                $ar_url[] = $category_link.'page/'.$i.'/';
            }
        }
    }
}

if($post_types){
    foreach ($post_types as $v){
        $gallery_url = get_cate_zdy_url($v,$per_page_num);
        if($gallery_url){
            $ar_url = array_merge($ar_url,$gallery_url);
        }
        $ar_url[] = home_url("/").$v.'/';
        $news_num = count(query_posts(array( 'post_type' => $v,'posts_per_page'=>-1)));
        if($news_num>$per_page_num){
            $page_count = ceil($news_num/$per_page_num);
            for($i=2;$i<=$page_count;$i++){
                $ar_url[] = home_url("/").$v.'/'.'page/'.$i.'/';
            }
        }

        query_posts(array( 'post_type' => $v,'showposts' => 5000) ); while (have_posts()) : the_post();
            $ar_url[] = get_permalink($post->ID);
        endwhile; wp_reset_query();
    }
}
query_posts(array( 'post_type' => 'page','showposts' => 5000) ); while (have_posts()) : the_post();
    $ar_url[] = get_permalink($post->ID);
endwhile; wp_reset_query();
$ar_url_cnt = count($ar_url);
$posts = $wpdb->get_results("select ID from wp_posts where not post_date_gmt='2016-01-08 00:00:00' and post_type='post' and post_status='publish'");
    if($posts){
        foreach($posts as $post){
            $ar_url[] = get_permalink($post -> ID);
        }
    }
$ar_url = array_unique($ar_url);


$ar_url = array_unique($ar_url);
echo implode('<br>',$ar_url);
echo '<br/>' ;
$tags = get_tags();
foreach($tags as $tag){
    echo get_tag_link ($tag->term_id);
    echo '<br/>' ;
}
?>

    <hr>
<?php wp_tag_cloud('smallest=12&largest=12&unit=px&number=500&orderby=count&order=DESC&taxonomy=category');?>
<?php wp_tag_cloud('smallest=12&largest=12&unit=px&number=500&orderby=count&order=DESC');?><hr>

<?php
$args = array(
    'hide_empty'               => 0
);
$categories = get_categories( $args );
//上面的代码获取所有分类
?>
<?php foreach($categories as $category){ ?>
    <?php $categoryid = $category->term_id;
    $categoryname = $category->cat_name;
    $category_link = get_category_link( $categoryid );?>
    <?php echo $category_link; ?>{<?php echo $categoryname; ?>}<br />
<?php } ?>
<?php
//tag地址
$tags = get_tags();
foreach($tags as $tag){
    echo get_tag_link ($tag->term_id);
    echo '{' .$tag->name.'}<br/>' ;
}
echo '<hr>';
$posts = query_posts(array('post_type' => 'post','showposts' => 10000));while ( have_posts() ) : the_post();
    echo get_permalink($post->ID);
    echo '{' .$post->post_title.'}<br/>' ;
endwhile; wp_reset_query();
?>