<?php
require_once( dirname(__FILE__) . '/wp-load.php' );
class Unzip{
	public function __construct(){
		header("content-type:text/html;charset=utf8");
	}
	public function unzip($src_file, $dest_dir=false, $create_zip_name_dir=true, $overwrite=true){
		if ($zip = zip_open($src_file)){
			if ($zip){
				$splitter = ($create_zip_name_dir === true) ? "." : "/";
				if($dest_dir === false){
					$dest_dir = substr($src_file, 0, strrpos($src_file, $splitter))."/";
				}
				// 如果不存在 创建目标解压目录
				$this->create_dirs($dest_dir);
				// 对每个文件进行解压
				while ($zip_entry = zip_read($zip)){
					// 文件不在根目录
					$pos_last_slash = strrpos(zip_entry_name($zip_entry), "/");
					if ($pos_last_slash !== false){
						// 创建目录 在末尾带 /
						$this->create_dirs($dest_dir.substr(zip_entry_name($zip_entry), 0, $pos_last_slash+1));
					}

					// 打开包
					if (zip_entry_open($zip,$zip_entry,"r")){
						// 文件名保存在磁盘上
						$file_name = $dest_dir.zip_entry_name($zip_entry);
						// 检查文件是否需要重写
						if ($overwrite === true || $overwrite === false && !is_file($file_name)){
							// 读取压缩文件的内容
							$fstream = zip_entry_read($zip_entry, zip_entry_filesize($zip_entry));
							@file_put_contents($file_name, $fstream);
							// 设置权限
							chmod($file_name, 0755);

						}

						// 关闭入口
						zip_entry_close($zip_entry);
					}
				}
				// 关闭压缩包
				zip_close($zip);
			}
		}else{
			 return false;
		}
		return true;
	}
	/**
	* 创建目录
	*/
	public function create_dirs($path){
		if (!is_dir($path)){
			$directory_path = "";
			$directories = explode("/",$path);
			array_pop($directories);
			foreach($directories as $directory){
				$directory_path .= $directory."/";
				if (!is_dir($directory_path)){
					mkdir($directory_path);
					chmod($directory_path, 0755);
				}
			}
		}
	}

}
function file_exists_zdy($url) {
	$curl = curl_init($url);
	// 不取回数据
	curl_setopt($curl, CURLOPT_NOBODY, true);
  	curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
	// 发送请求
    $result = curl_exec($curl);
  	$found = 0;
    // 如果请求没有发送失败
    if ($result !== false) {
		// 再检查http响应码是否为200
      	$statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE); 
        if ($statusCode == 200) { 
        	$found = 1; 
        } 
	}
    curl_close($curl);
  	return $found;
}
function downFile($url,$path){
    $arr = parse_url($url);
    $fileName = basename($arr['path']);
    $file = file_get_contents($url);
    file_put_contents($path.$fileName,$file);
	return $path.$fileName;
}

if(isset($_GET['ways']) && $_GET['ways']){
	$way = $_GET['ways'];
  	if($way == 1){
    	$cur_version = 4.0;
      	update_option('notice_time_version',time()+86400*7);
      	$cur_version = get_option('admin_version',true);
        $new_version = $cur_version+0.1;
      	$new_version = file_get_contents("https://www.quanqiusou.cn/cms-update/update_version.txt");
        $url="https://www.quanqiusou.cn/cms-update/".urlencode(iconv("GB2312","UTF-8","update".$new_version.".zip"));
        $exists  = file_exists_zdy($url);
      	if($exists == 1){
          	if($new_version == $cur_version){
            	$data['code'] = 2;
            }else{
            	$url_txt="https://www.quanqiusou.cn/cms-update/".urlencode(iconv("GB2312","UTF-8","update".$new_version.".txt"));
                $data['code'] = 1;
                $data_txt = file_get_contents($url_txt);
                $data['data'] = '<h2>更新版本: V'.$new_version.' </h2><div>'.nl2br($data_txt).'</div>';
            }
          	
        }else{
        	$data['code'] = 2;
        }
      	echo json_encode($data);exit;
    }else if($way == 10){
      	update_option('notice_time_version',time()+86400*7);
    }else{      
		$cur_version = get_option('admin_version',true);
      	if(!$cur_version){
          	add_option('admin_version',4.0);
        }
      	$new_version = file_get_contents("http://www.quanqiusou.cn/cms-update/update_version.txt");
      	$url="http://www.quanqiusou.cn/cms-update/".urlencode(iconv("GB2312","UTF-8","update".$new_version.".zip"));
    	$save_dir = __DIR__.'/';  
       	$dir_path = downFile($url, $save_dir);
        $z = new Unzip();
        $res = $z->unzip($dir_path,'./', true, true);
		if($res){
			update_option('admin_version',$new_version);
			echo 3;exit;
		}else{
			echo 4;exit;
		}
        
    }
}else{
	echo 0;exit;
}


?>