<?php
    session_start();
    if (isset($_SESSION['is_login']) && $_SESSION['is_login'] == 1) {
        $url = 'http://' . $_SERVER['HTTP_HOST'] . '/admin/plugins/proofreading/index.php';
        header('Location: ' . $url);
    }
?>

<!DOCTYPE html>
<html>
<head>
    <title>登录进入校对页面</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="./style.css" rel='stylesheet' type='text/css' />
</head>
<body>
<div class="main">
    <div class="login">
        <div class="inset">
            <!--start-main-->
            <div>
                <div>
                    <span><label>请输入登录密码</label></span>
                    <span><input type="password" name="password" class="password"></span>
                </div>
                <div class="sign">
                    <input type="button" value="登录" id="confirm" class="submit" />
                </div>
            </div>
        </div>
    </div>
    <!--//end-main-->
</div>
</body>
<script src="/wp-content/plugins/proofreading/resource/js/jquery-2.1.4.min.js"></script>
<script src="/wp-content/plugins/proofreading/resource/layer/layer.js"></script>
<script>
    $('#confirm').unbind('click').bind('click', function() {
        let password = $('input[name=password]').val()
        if (!password || password.length < 6) {
            layer.msg('请输入至少6位数的密码！', {icon: 5, shade: [0.3, '#393D49'], shadeClose: true, time: 1000})
            return false;
        }

        $.post('/admin/plugins/proofreading/api.php?type=login', {password: password}, function (result) {
            result = JSON.parse(result);
            if (parseInt(result.status) === 1) {
                layer.msg(result.msg, {icon: 1, shade: [0.3, '#393D49'], shadeClose: true, time: 1000}, function () {
                    let domain = "<?php echo $_SERVER['HTTP_HOST']; ?>";
                    window.location.href = 'http://' + domain + '/admin/plugins/proofreading/index.php'
                })
            } else {
                layer.msg(result.msg, {icon: 5, shade: [0.3, '#393D49'], shadeClose: true, time: 1000})
            }
        })
    })
</script>
</html>