<?php

$service_path = $_SERVER['DOCUMENT_ROOT'] . '/wp-content/plugins/proofreading/services/FileService.php';
require_once($service_path);

$service = new FileService();
$method  = $_GET['type'];

// 获取当前需要翻译的文件的数据 返回到前端
if ($method == 'change_language') {
    $param  = $_POST;

    $language   = isset($param['language']) ? $param['language'] : '';
    $old_string = isset($param['old_string']) ? $param['old_string'] : '';
    $new_string = isset($param['new_string']) ? $param['new_string'] : '';

    if (empty($language) || empty($old_string) || empty($new_string)) {
        echo json_encode(['status' => 0, 'msg' => '操作失败，参数错误！']);
        exit();
    }
    foreach($language_data['change_data'] as $k=>&$v){
        if($v["type"] == "texts"){
            $v['source'] = base64_decode($v['source']);
            $v['new_string'] = stripslashes($v['new_string']);
        }
    }
    $language_data = [];
    $language_data['change_data'][0] = [
            "type"=>"texts",
            "source"=>$old_string,
            "new_string"=>$new_string
        ];
$service->proofreading(1, '/', $language, $language_data);
    //$service->changeLanguageString($language, $old_string, $new_string);
    echo json_encode(['status' => 1, 'msg' => '操作成功！']);
}

if ($method == 'proofreading_all_language')
{
    $param    = $_POST;
    $language = isset($param['language']) ? $param['language'] : '';

    if (empty($language)) {
        echo json_encode(['status' => 0, 'msg' => '操作失败，参数错误！']);
        exit();
    }

    $result = $service->proofreading(3, '', $language, []);
    echo $result;
    exit();
}

// 校对密码
if ($method == 'login') {
    $param = $_POST;
    $password = isset($param['password']) ? $param['password'] : '';

    if (empty($password)) {
        echo json_encode(['status' => 0, '登录失败，请输入密码！']);
        exit();
    }

    $user_password = $service->getUserConfig('password');

    if ($password == $user_password) {
        session_start();
        $_SESSION['is_login'] = 1;
        echo json_encode(['status' => 1, 'msg' => '登录成功！']);
    } else {
        echo json_encode(['status' => 0, 'msg' => '登录失败，请输入正确的密码！']);
    }
}

// 校对成功过后 在后台执行文件上传 用户无感知
if ($method == 'proofreading_success') {
    // 校对成功后 后台上传校对后的json 文件
    ignore_user_abort();
    set_time_limit(0);

    $qiNiuService = new QiNiuService();
    $pages        = $qiNiuService->pages;
    $param        = $_POST;
    $language     = isset($param['language']) ? $param['language'] : '';
    foreach ($pages as $key => $value) {
        $json_file_name  = $service->getJsonFileName($value['path'], $language);
        $local_file_path = $qiNiuService->jsonPath . '/' . $json_file_name;
        if (file_exists($local_file_path)) {
            $content = file_get_contents($local_file_path);
            if ($content != null || !empty($content)) {
                $load_result    = $qiNiuService->uploadFile($local_file_path);
                if ($load_result) {
                    $qiNiuService->writeLog(3, '文件上传成功: ' . $local_file_path);
                } else {
                    $qiNiuService->writeLog(3, '文件上传失败: ' . $local_file_path);
                }
            }
        } else {
            $qiNiuService->writeLog(3, '文件上传失败，找不到文件 == ' . $local_file_path);
        }
    }

}