<?php
require_once( dirname(__FILE__) . '/../wp-load.php' );
global $wpdb;
$home_url = home_url('/');
$cdn_setting = get_option("gd_cdn_setting");
$domain = $home_url;
if($cdn_setting){
    if(strpos($home_url,'quanqiusou.cn') !== false || strpos($home_url,'goodao.net') !== false){
        $domain = trim($cdn_setting['weburl']);
    }
}
$page = isset($_GET['page'])?trim($_GET['page']):1;
$pagesize = isset($_GET['pagesize'])?trim($_GET['pagesize']):100;
$start = $pagesize*($page-1);
$type = $_GET['w'];
$post_types = get_post_types(array('public' => true), "names", "and");
$ar_post_type = [];
foreach ($post_types as $post_type_key => $post_type_value) {
    if(!in_array($post_type_key, ['3code','acf','admin','ad_img','attachment','banner','banner-sidebar','banner_sidebar','cf7_entry','dw_license','fl-builder-template','gd-admin','helppage','home','import_users','lianxi','nav_menu_item','p','pro','pro_detail','pro_shuxing','skype','sns','title','transall','v','wpcf7_contact_form','ww','post','page','revision','vs','wp_automatic','qq','xunpan','sitemap','help','news'])){
        $ar_post_type[] = $post_type_value;
    }
}

switch($type){
	case "website_info"://网站基础信息
        $banners = get_post_meta(50,'ad_index_banner',true);
        $img_urls = [];
        if($banners){
            foreach ($banners as $v){
                $img_urls[] = wp_get_attachment_url($v);
            }
        }
		$data['company_name'] = get_post_meta(50,'lianxi_company',true);
		$data['company_address'] = get_post_meta(50,'lianxi_adress',true);
        $logo_id = get_post_meta(50,'ad_logo',true);
        $logo = '';
        if($logo_id){
            $logo = wp_get_attachment_url($logo_id);
        }
        $icon = '';
        $icon_id = get_post_meta(50,'ad_favicon',true);
        if($icon_id){
            $icon = wp_get_attachment_url($icon_id);
        }
        $data['banner'] = $img_urls;
        $data['logo'] = $logo;
        $data['icon'] = $icon;
		$data['phones'] = get_post_meta(50,'lianxi_phone_01',true);
		$phone2 = get_post_meta(50,'lianxi_phone_02',true);
		if($phone2){
			if($data['phones']){
				$data['phones'] .= ','.$phone2;	
			}else{
				$data['phones'] = $phone2;
			}
		}
		$data['emails'] = get_post_meta(50,'lianxi_mail_01',true);
		$email2 = get_post_meta(50,'lianxi_mail_02',true);
		if($email2){
			if($data['emails']){
				$data['emails'] .= ','.$email2;	
			}else{
				$data['emails'] = $email2;
			}
		}
		$data['fax'] = get_post_meta(50,'lianxi_fax',true);
		$data['whatsapp'] = get_post_meta(50,'lianxi_whatsapp',true);

        $tags_tmp = get_terms('post_tag',['hide_empty'=>false]);
        $tags = [];
        if($tags_tmp){
            foreach ($tags_tmp as $v){
                $tags[] = $v->name;
            }
        }
        $data['tags'] = $tags;
        
        $data['customposttypes'] = $ar_post_type;
        echo json_encode(['code'=>200,'data'=>$data]);exit;
        break;
	case 'post':
        $count_posts = $wpdb->get_row("select count(*) as cnt from wp_posts where post_type='post' and post_status='publish'",ARRAY_A);
        $data['count'] = $count_posts['cnt'];
        $arr = [];
        $posts = $wpdb->get_results("select ID,post_title,post_content,post_date from wp_posts where post_type='post' and post_status='publish' order by ID DESC limit $start,$pagesize");
        if($posts){
            foreach ($posts as $post){
                $tmp['ttile'] = $post->post_title;
                $tmp['url'] = str_replace($home_url,$domain,get_permalink($post->ID));
				$tmp['short_description'] = '';
                if(get_post_meta($post->ID,'short_description',true)){
                    $tmp['short_description'] = get_post_meta($post->ID,'short_description',true);
                }
                $tmp['content'] = sanitize_text_field(strip_tags($post->post_content));
                $tmp['images'] = [];
                $product_gallery = get_post_meta($post->ID,'product_gallery',true);
                if($product_gallery){
                    foreach ($product_gallery as $vv){
                        $tmp['images'][] = str_replace($home_url,$domain,wp_get_attachment_url($vv));
                    }
                }
                $cats_post = wp_get_post_terms($post->ID,'category');
                $cats = [];
                if($cats_post){
                    foreach ($cats_post as $vv){
                        $tmp_cat['id'] = $vv->term_id;
                        $tmp_cat['name'] = $vv->name;
                        $tmp_cat['parent'] = $vv->parent;
                        $cats[] = $tmp_cat;
                    }
                }
                $tmp['category'] = $cats;
                $tdk_info = $wpdb->get_row("select * from wp_tdks where type=3 and pid=".$post->ID.' order by id desc',ARRAY_A);
                $tmp['description'] = '';
                $tmp['keywords'] = '';
                if($tdk_info){
                    $tmp['description'] = $tdk_info['meta_description'];
                    $tmp['keywords'] =$tdk_info['meta_keywords'];
                }
                $tmp['post_date'] = $post->post_date;
                $tmp['sort'] = $post->ID;
                $sort = get_post_meta($post->ID,'_listorder',true);
                if($sort){
                    $tmp['sort'] = $sort;
                }
				$tmp['tags'] = [];
                $tags = get_the_tags( $post->ID );
                if($tags){
                    foreach ($tags as $tag){
                        $tag_tmp['id'] = $tag->term_id;
                        $tag_tmp['name'] = $tag->name;
                        $tmp['tags'][] = $tag_tmp;
                    }
                }
                $arr[] = $tmp;
                
            }
        }
        $data['data'] = $arr;
        echo json_encode(['code'=>200,'data'=>$data]);exit;
        break;
    case 'page':
    case 'news':
    case 'blog':
        $count_posts = $wpdb->get_row("select count(*) as cnt from wp_posts where post_type='".$type."' and post_status='publish'",ARRAY_A);
        $data['count'] = $count_posts['cnt'];
        $arr = [];
        $posts = $wpdb->get_results("select ID,post_title,post_content,post_date from wp_posts where post_type='".$type."' and post_status='publish' order by ID DESC limit $start,$pagesize");
        if($posts){
            foreach ($posts as $post){
                $tmp['ttile'] = $post->post_title;
                $tmp['url'] = str_replace($home_url,$domain,get_permalink($post->ID));
                $tmp['content'] = sanitize_text_field(strip_tags($post->post_content));
                $tmp['description'] = '';
                $tmp['keywords'] = '';
                $tmp['images'] = [];
				$image_id = get_post_meta($post->ID,'news_img',true);
                if($image_id){
                    $tmp['images'] = wp_get_attachment_image_src($image_id,'full')[0];
                }
                $cats_post = wp_get_post_terms($post->ID,'news_catalog');
                $cats = [];
                if($cats_post){
                    foreach ($cats_post as $vv){
                        $tmp_cat['id'] = $vv->term_id;
                        $tmp_cat['name'] = $vv->name;
                        $tmp_cat['parent'] = $vv->parent;
                        $cats[] = $tmp_cat;
                    }
                }
                $tmp['category'] = $cats;
                if($type == 'page'){
                    $tdk_info = $wpdb->get_row("select * from wp_tdks where type=4 and pid=".$post->ID.' order by id desc',ARRAY_A);
                    if($tdk_info){
                        $tmp['description'] = $tdk_info['meta_description'];
                        $tmp['keywords'] = $tdk_info['meta_keywords'];
                    }
                }
                $tmp['post_date'] = $post->post_date;
                $tmp['sort'] = $post->ID;
                $arr[] = $tmp;
                
            }
        }
        $data['data'] = $arr;
        echo json_encode(['code'=>200,'data'=>$data]);exit;
        break;
    case 'tag':
        $tags = get_tags();
        $data['count'] = count($tags);
        $data['data'] = [];
        $arrs = array_chunk($tags,$pagesize);
        foreach($arrs[$page-1] as $tag){
            $tmp['url'] = get_tag_link ($tag->term_id);
			$tmp['name'] = $tag->name;
            $tdk_info = $wpdb->get_row("select * from wp_tdks where type=1 and pid=".$tag->term_id.' order by id desc',ARRAY_A);
            $tmp['seo_title'] = '';
            $tmp['seo_keywords'] = '';
            $tmp['seo_description'] = '';
            $tmp['text_title'] = '';
            $tmp['text_description'] = '';
            if($tdk_info){
                $tmp['seo_title'] = $tdk_info['page_title'];
                $tmp['seo_keywords'] = $tdk_info['meta_keywords'];
                $tmp['seo_description'] = $tdk_info['meta_description'];
                $tmp['text_title'] = $tdk_info['content_title'];
                $tmp['text_description'] = $tdk_info['content_description'];
            }
            $data['data'][] = $tmp;
        }
        echo json_encode(['code'=>200,'data'=>$data]);exit;
        break;
    case 'category':
        $data = get_cagetory_children(0);
        echo json_encode(['code'=>200,'data'=>$data]);exit;
        break;
    case 'category_news':
        $data = get_cate_zdy();
        echo json_encode(['code'=>200,'data'=>$data]);exit;
        break;
    default:
        if($ar_post_type){
            if(in_array($type,$ar_post_type)){
                $return['category'] = get_cate_zdy($type);
                $sql = "SELECT SQL_CALC_FOUND_ROWS  ".$wpdb->prefix."posts.* FROM ".$wpdb->prefix."posts  WHERE 1=1  AND (".$wpdb->prefix."posts.post_type = '".$type."') AND ((".$wpdb->prefix."posts.post_status = 'publish'))  ORDER BY ".$wpdb->prefix."posts.ID DESC LIMIT ".$start.", ".$pagesize;
                $recent_custom_posts = $wpdb->get_results($sql, ARRAY_A);
				$return['count'] = $wpdb->get_row("SELECT count(*) as cnt FROM ".$wpdb->prefix."posts  WHERE 1=1  AND (".$wpdb->prefix."posts.post_type = '".$type."') AND ((".$wpdb->prefix."posts.post_status = 'publish'))",ARRAY_A)['cnt'];
                $return_t = [];
                foreach ($recent_custom_posts as $key => $post) {
                    $data['title'] = $post['post_title'];
                    $data['url'] = get_permalink($post["ID"]);
                    $data['content'] = mb_strimwidth(strip_tags(apply_filters('the_content', $post['post_content'])), 0, 300,"...");
					$data['post_time'] = $post['post_date'];
                    $cats_post = wp_get_post_terms($post['ID'],$type.'_catalog');
                    $cats = [];
                    if($cats_post){
                        foreach ($cats_post as $vv){
                            $tmp_cat['id'] = $vv->term_id;
                            $tmp_cat['name'] = $vv->name;
                            $tmp_cat['parent'] = $vv->parent;
                            $cats[] = $tmp_cat;
                        }
                    }
                    $data['category'] = $cats;
					$image_id = get_post_meta($post["ID"],'news_img',true);
                    if($image_id){
                        $data['images'] = wp_get_attachment_image_src($image_id,'full')[0];
                    }
					$data['sort'] = $post["ID"];
					$sort = get_post_meta($post["ID"],'_listorder',true);
					if($sort){
						$data['sort'] = $sort;
					}
                    $return_t[] = $data;
                }
                $return['data'] = $return_t;
                //print_r($return_t);exit;
                echo json_encode(['code'=>200,'data'=>$return]);exit;  
            }
        }
        echo json_encode(['code'=>1,'msg'=>'error']);exit;
}
//获取自定义分类url
function get_cate_zdy($cat_type = 'news'){
    $count_g = 0;
	$taxnomy = $cat_type.'_catalog';
    $arg = array(
        'taxonomy' => $taxnomy,
        'orderby' => 'name',
        'show_count' => 1,
        'pad_counts' => 0,
        'hierarchical' => 0
    );
    $ar_url = array();
    $categories = get_categories( $arg );
    if(isset($categories['errors'])){
        return $ar_url;
    }
    foreach($categories as $category){
        $categoryid = $category->term_id;
		$category_link = home_url("/").$cat_type.'_catalog/'.$category->slug.'/';
		$tmp['id'] = $categoryid;
		$tmp['name'] = $category->name;
		$tmp['url'] = $category_link;
		$tmp['parent'] = $category->parent;
        $ar_url[] = $tmp;
    }
    
    return $ar_url;
}
function get_cagetory_children($term_id){
    global $wpdb;
    $per_page_num = get_option('posts_per_page');
    
	$args = array(
		'hide_empty'  => 0,
		'parent'=>$term_id
	);
    
    $return = [];
    $categories = get_categories( $args );
    $categories = json_decode(json_encode($categories),true);
    foreach ($categories as $category){
        $categoryid = $category['term_id'];
        $category_link = get_category_link( $categoryid );
		$tmp['id'] = $categoryid;
        $tmp['name'] = $category['name'];
        $tmp['url'] = $category_link;
        $tdk_info = $wpdb->get_row("select * from wp_tdks where type=2 and pid=".$category['term_id'].' order by id desc',ARRAY_A);
        if($tdk_info){
            $tmp['keywords'] = $tdk_info['meta_keywords'];
            $tmp['description'] = $tdk_info['meta_description'];
        }
        $tmp['children'] = get_cagetory_children($categoryid);
        $return[] = $tmp;
    }
    return $return;
}

?>